<?php

/**
 * Streamit\Utility\Actions\Component class
 *
 * @package streamit
 */

namespace Streamit\Utility\Actions;

use Streamit\Utility\Component_Interface;
use Streamit\Utility\Templating_Component_Interface;

/**
 * Class for managing comments UI.
 *
 * Exposes template tags:
 * * `streamit()->the_comments( array $args = array() )`
 *
 * @link https://wordpress.org/plugins/amp/
 */
class Component implements Component_Interface, Templating_Component_Interface
{
	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */

	public function get_slug(): string
	{
		return 'actions';
	}

	public function initialize()
	{
	}

	/**
	 * Gets template tags to expose as methods on the Template_Tags class instance, accessible through `streamit()`.
	 *
	 * @return array Associative array of $method_name => $callback_info pairs. Each $callback_info must either be
	 *               a callable or an array with key 'callable'. This approach is used to reserve the possibility of
	 *               adding support for further arguments in the future.
	 */

	public function template_tags(): array
	{
		return array(
			'streamit_get_comment_btn' 		=> array($this, 'streamit_get_comment_btn'),
			'streamit_get_blog_readmore_link' => array($this, 'streamit_get_blog_readmore_link'),
		);
	}

	//** Blog Read More Button Link **//
	public function streamit_get_blog_readmore_link($link, $label = "Read More")
	{
		echo '<a class="button-link btn" href="' . esc_url($link) . '">' . esc_html($label) . '<i class="fas fa-angle-right" aria-hidden="true"></i></a>';
	}

	public function streamit_get_comment_btn($tag = 'a',  $label = 'Post Comment', $show_icon = true, $attr = array())
	{
		$icon = $show_icon ? '<i class="fas fa-angle-right" aria-hidden="true"></i>' : '';

		$classes = isset($attr['class']) ? $attr['class'] : '';

		$attr_render = '';
		$attr_render = ($tag == 'button') ? 'type="submit" ' : '';

		foreach ($attr as $key => $value) {
			$attr_render .= $key . '=' . $value . ' ';
		}

		return '<' . tag_escape($tag) . '  class="iq-button btn ' . esc_attr($classes) . '  " ' . esc_attr($attr_render) . '  >
				' . esc_html($label) .
			$icon .
			' </' . tag_escape($tag) . '>';
	}
}
