<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $streamit_options, $template;

$favicon_url    = '';
$c_url          = explode('/', $template);
$c_page         = end($c_url);
$body_classes   = 'overflow-hidden';

if (class_exists("ReduxFramework")) {
    if (isset($streamit_options['streamit_display_loader']) && $streamit_options['streamit_display_loader'] === 'yes' && !empty($streamit_options['streamit_loader_gif']['url'])) {
        $bgurl = $streamit_options['streamit_loader_gif']['url'];
    } else {
        $body_classes = '';
    }
} else {
    $bgurl = get_template_directory_uri() . '/assets/images/redux/loader.gif';
}

if (!has_site_icon() && !empty($streamit_options['streamit_fevicon']['url']))
    $favicon_url = $streamit_options['streamit_fevicon']['url'];

if (isset($streamit_options['email_and_button']) && $streamit_options['email_and_button'] == 'yes')
    $body_classes .= " iq-header-top";

if (in_array($c_page, ['single-movie.php', 'single-episode.php', 'single-video.php', 'single-person.php']))
    $body_classes .= " iq-hide-header";

if (isset($streamit_options['opt-container-width']) && !empty($streamit_options['opt-container-width']))
    $body_classes .= " iq-container-width"; ?>

<!doctype html>
<html <?php language_attributes(); ?> class="no-js" <?php do_action('streamit_layout_mode_add_attr'); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
  


    <link rel="profile" href="<?php echo is_ssl() ? 'https:' : 'http:' ?>//gmpg.org/xfn/11">

    <?php if (!empty($favicon_url)) { ?>
        <link rel="shortcut icon" href="<?php echo esc_url($favicon_url); ?>" />
    <?php }

    wp_head(); ?>
    
</head>

<body <?php body_class($body_classes); ?>>
    <?php wp_body_open();

    if (isset($bgurl) && !empty($bgurl)) { ?>
        <div id="loading">
            <div id="loading-center">
                <img src="<?php echo esc_url($bgurl); ?>" alt="<?php esc_attr_e('loader', 'streamit'); ?>">
            </div>
        </div>
    <?php } ?>

    <?php get_template_part('template-parts/header/header'); ?>