(function ($) {
    "use strict";

    $(document).ready(function () {
        var is_free = false;
        var proceed = true;

        var movie_excerpt = $('.pmpro-no-access .movie__player p');
        var video_excerpt = $('.pmpro-no-access .video__player p');

        //removes double excerpt when pmpro restrict
        if (movie_excerpt.length > 2) {
            movie_excerpt.slice(0, 2).remove();
        }

        if (video_excerpt.length > 2) {
            video_excerpt.slice(0, 2).remove();
        }

        //removes pmpro restrict message
        if ($('.pmpro-no-excerpt .streamit-content-details .pmpro_content_message').length == 0) {
            $('.pmpro-no-access .streamit-content-details .pmpro_content_message').remove();
        }

        //removes pmp default required field structure from all pmpro forms
        $('form.pmpro_form').find(".pmpro_asterisk").remove();

        //adds custom required field structure in checkout form
        $('.pmpro_required').each(function () {
            if ($(this).closest('.pmpro_checkout-field').children().first().find('.pmpro_asterisk').length == 0) {
                $(this).closest('.pmpro_checkout-field').children().first().append('<span class="pmpro_asterisk"> <abbr title="Required Field">*</abbr></span>');
            }
        })

        //adds custom required field structure in change password form
        $('.pmpro_change_password-field').each(function () {
            if ($(this).children().first().find('.pmpro_asterisk').length == 0) {
                $(this).children().first().append('<span class="pmpro_asterisk"> <abbr title="Required Field">*</abbr></span>');
            }
        });

        //=========================REGISTRATION WIZARD========================
        //show registration setup wizard for the PMP pricing plan widget
        if ($('.pmpro-levels #pmpro_levels_table').length > 0) {
            $.ajax({
                url: streamit_pmpro_object.ajaxurl,
                type: 'POST',
                async: false,
                data: {
                    action: 'streamit_pmpro_register_wizard',
                },
                success: function (data) {
                    if ($('.pmpro-levels .site-main .container .row .col-md-12').length > 0) {
                        $('.pmpro-levels .site-main .container .row .col-md-12').prepend(data);
                    } else if ($('.pmpro-levels .site-content-contain .site-content').length > 0) {
                        $('.pmpro-levels .site-content-contain .site-content').prepend(data);
                    }
                }
            });
        }

        //Step 1: Select Plan
        var step_selectPlan_page = $('#pmpro_levels_table');
        var step_selectPlan = $('#streamit-pmpro_select_plan');

        if (step_selectPlan_page.length > 0) {
            step_selectPlan.addClass('active');
        }

        //Step 2: Account Registration
        var step_register_page = $('#pmpro_form')
        var step_register = $('#streamit-pmpro_register');

        if (step_register_page.length > 0) {
            step_register.addClass('active');
        }

        //Step 3: Payment Success/Invoice Bill
        var step_invoice_page = $('#pmpro_confirmation_wrap');
        var step_invoice = $('#streamit-pmpro_checkout_success');

        if (step_invoice_page.length > 0) {
            step_invoice.addClass('active');
        }

        //importing PMS plans to PMP
        $('.import_pms_plans').click(function () {
            ajax_import_PMS_plans();
        });

        $('.import_pms_members_info').click(function () {
            ajax_import_PMS_member_details();
        });
    });

    function ajax_import_PMS_plans() {
        $.ajax({
            url: streamit_pmpro_object.ajaxurl,
            type: 'POST',
            async: false,
            data: {
                action: 'streamit_import_PMS_plans_and_restriction_content',
            },
            error: function (xhr) {
                console.error(xhr);
            },
            success: function (data) {
                if (data) {
                    var formattedData = data.replace(/<br>/g, '\n');
                    $('.import_pms_plans').off('click').addClass('disabled');

                    alert(formattedData);
                }
            }
        });
    }

    function ajax_import_PMS_member_details() {
        $.ajax({
            url: streamit_pmpro_object.ajaxurl,
            type: 'POST',
            async: false,
            data: {
                action: 'streamit_import_PMS_member_details',
            },
            error: function (xhr) {
                console.error(xhr);
            },
            success: function (data) {
                if (data) {
                    var formattedData = data.replace(/<br>/g, '\n');
                    $('.import_pms_members_info').off('click').addClass('disabled');

                    alert(formattedData);
                }
            }
        });
    }

    //Apply discount code directly on checkout.
    $(document).ready(function () {
        var code = $('#other_discount_code').val();
        var level_id = $('#level').val();

        if (code) {
            $.ajax({
                url: streamit_pmpro_object.ajaxurl,
                type: 'GET',
                timeout: 2000,
                dataType: 'html',
                data: "action=applydiscountcode&code=" + code + "&level=" + level_id + "&msgfield=pmpro_message",
                error: function (xml) {
                    alert('Error applying discount code [1]');

                    //enable apply button
                    $('#other_discount_code_button').removeAttr('disabled');
                },
                success: function (responseHTML) {
                    if (responseHTML == 'error') {
                        alert('Error applying discount code [2]');
                    }
                    else {
                        $('#pmpro_message').html(responseHTML);
                    }

                    //enable invite button
                    $('#other_discount_code_button').removeAttr('disabled');
                }
            });
        }
    });

    $(document).ready(function () {
        setTimeout(function () {
            //Apply Additional discount
            var mainPrice = ($('.streamit-pmpro-checkout .main-price').text().trim());
            var additional_discount_amount = ($('.streamit-pmpro-checkout .additional_discount_wrapper input[name="additional_discount_price"]').val());

            if (mainPrice !== undefined && additional_discount_amount !== undefined) {
                var priceSymbol = mainPrice.charAt(0);
                var price = mainPrice.slice(1);

                if (price) {
                    price = parseFloat(price)
                    var discounted_price = price - additional_discount_amount;
                }
                applyAdditionalDiscount(priceSymbol, discounted_price);
            }
        });
    }, 100);

    function applyAdditionalDiscount(priceSymbol, discounted_price) {
        $('.streamit-pmpro-checkout .main-price').text(priceSymbol + discounted_price);
    }
})(jQuery)