
(function (jQuery) {
    jQuery(document).ready(continueWatchingEpisode);
    jQuery(window).on('load', continueWatchingEpisode);
})(jQuery);

function continueWatchingEpisode() {
    typeof MediaElementPlayer !== "undefined" && jQuery.extend(MediaElementPlayer.prototype, {
        buildnextEpisode: function (player, controls, layers, media) {
            jQuery(`<div class="mejs-button streamit-next-episode" style="display:none">
                        <div class="streamit-next-episode-box" style="--episode-bg:url(${streamit_upcoming_episode.nextEpisodeThumbnail})">
                        <a href="${streamit_upcoming_episode.nextEpisodeLink}" class="streamit-next-episode-link">
                        <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="70px" height="70px" viewBox="0 0 213.7 213.7" enable-background="new 0 0 213.7 213.7" xml:space="preserve">
                                            <polygon stroke="black" style="stroke:var(--iq-primary)" class="triangle" fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="73.5,62.5 148.5,105.8 73.5,149.1 "></polygon>
                                            <circle class="circle" fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" cx="106.8" cy="106.8" r="103.3"></circle>
                                        </svg>
                                        <h6>${streamit_upcoming_episode.nextEpisodeName}</h6>
                        </a>
                        </div>
                </div>`)
                .appendTo(controls);
        },
        buildcontinueWatching: function (player, controls, layers, media) {
            jQuery(`
            <div class="mejs-layer">
            </div>
            <div class="streamit-video-continue-watch-container mejs-layer">
            <div class="streamit-video-continue-watch">
                <p> ${streamit_continue_watch?.desc} </p>
                <div class="continue-watch-model-btn-wrapper">
                    <button class='btn btn-hover iq-button' onClick="continueWatchHandler(this)">${streamit_continue_watch?.resume_btn}</button>
                    <button class='btn btn-hover iq-button' onClick="continueWatchRemoveHandler(this)">${streamit_continue_watch?.cancle_btn}</button>
                </div>
            </div>
        </div>`)
                .css('display', 'none')
                .appendTo(layers);
        },
        buildUnfocus: (player, controls, layers, media) => {
            jQuery(`<div class="streamit-video-overlay"></div>`)
                .css('display', 'none')
                .appendTo(layers);
        }
    });



    let mediaPlayer = jQuery(".iq-main-slider video");
    if (typeof mediaPlayer.mediaelementplayer === 'function') {
        mediaPlayer.mediaelementplayer({
            features: [typeof streamit_continue_watch != undefined && 'continueWatching', typeof streamit_upcoming_episode != undefined && 'nextEpisode', 'playpause', 'current', 'progress', 'duration', 'volume', 'fullscreen', 'Unfocus'],
            error: function (mediaElementObject, domObject) {
                jQuery('.streamit-video-continue-watch-container').hide();
            },
        });
    }

    let isPlay = false;
    mediaPlayer.on('ended', function (event) {
        let nextEpisodeContainer = jQuery('.mejs-button.streamit-next-episode');
        jQuery('.streamit-video-overlay').show();
        nextEpisodeContainer.fadeIn().addClass('animated');
        typeof streamit_continue_watch == undefined && watchedAjaxHandler();
        isPlay = false;
        setTimeout(function () {
            nextEpisodeContainer.find('.streamit-next-episode-link');
            if (!isPlay) {
                window.location.href = nextEpisodeContainer.find('.streamit-next-episode-link').attr('href')
            }
        }, 5000)
    })
    mediaPlayer.on('play', function (event) {
        let nextEpisodeContainer = jQuery('.mejs-button.streamit-next-episode');
        jQuery('.streamit-video-overlay').css('display', 'none');
        nextEpisodeContainer.fadeOut("slow").removeClass('animated');
        isPlay = true;
    })
}

