(function ($) {
    "use strict";

    $(document).ready(function () {
        let canBeLoaded = true;

        $('.streamit-notification').click(function (event) {

            if (canBeLoaded) {
                $.ajax({
                    url: streamit_loadmore_params.ajaxurl,
                    data: {
                        action: "streamit_notification_data",
                    },
                    type: "POST",
                    success: function (data) {
                        $('.streamit-notification').append(data);

                        let notification_count = $('.streamit_notification_wrapper').data('notification_count');
                        if (notification_count !== undefined) {
                            $('.streamit-notification .notification-count').html(notification_count);
                        } else {
                            $('.streamit-notification .notification-count').remove();
                        }

                        canBeLoaded = false;
                    }
                });
            }

            if ($(event.target).closest('.streamit_notification_wrapper').length === 0) {
                $(this).toggleClass('notification-open');
            }

            $(document).click(function (event) {
                if ($(event.target).closest('.streamit-notification').length === 0) {
                    $('.streamit-notification').removeClass('notification-open');
                }
            });
        });
    });
})(jQuery);