(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        let desc = jQuery('.description-content');

        if (desc.length == 0) return;

        desc.toggleClass('showContent hideContent');
        let desc_panel_height = countLines(desc);
        desc.toggleClass('showContent hideContent');
        if (desc_panel_height > 8) {
            desc.addClass('hideContent').next('.show-more').show();
            desc.next('.show-more').on('click', function () {
                let btn = jQuery(this).find('a');
                desc.toggleClass('showContent hideContent');
                if (!desc.hasClass('showContent')) {
                    btn.text(btn.data('showmore'));
                } else {
                    btn.text(btn.data('showless'));
                }
            });
        } else {
            desc.removeClass('showContent ').next('.show-more').hide();
        }
    });
}(jQuery));
var countLines = (el) => Math.round(Number(el.outerHeight() / parseInt(el.css('lineHeight').slice(0, -2))));