
(function (jQuery) {
    jQuery(document).ready(function () {
        jQuery('.remodal').wrap('<div class="streamit-model-wrapper"></div>');
    });

    jQuery(window).on('load', function () {
        if (typeof streamit_continue_watch !== 'undefined' && typeof streamit_continue_watch?.watchedTime == 'object') {
            jQuery('.streamit-video-continue-watch-container').closest('.streamit-video-continue-watch-container').fadeIn();
        }
    });
})(jQuery);

function continueWatchHandler(_this) {
    let contentPlayer = document.querySelector(".iq-main-slider video").player;
    contentPlayer.setCurrentTime(streamit_continue_watch?.watchedTime['watchedTime']);
    contentPlayer.play();
    jQuery(_this).closest('.streamit-video-continue-watch-container').fadeOut();
}

function continueWatchRemoveHandler(_this) {
    jQuery(_this).closest('.streamit-video-continue-watch-container').fadeOut();
}

function watchHandler(currentTime, totaltime, percent) {
    jQuery.ajax({
        url: streamit_loadmore_params.ajaxurl, // AJAX handler
        async: false,
        data: {
            'action': 'streamit_update_watched',
            'postID': streamit_continue_watch.ID,
            'watchedTime': currentTime,
            'watchedTotalTime': totaltime,
            'watchedTimePercentage': percent,
            'nonce': streamit_continue_watch.nonce,
        },
        type: 'GET',
    });
}

function watchedAjaxHandler() {
    jQuery.ajax({
        url: streamit_loadmore_params.ajaxurl, // AJAX handler
        async: false,
        data: {
            'action': 'streamit_delete_watched',
            'postID': streamit_continue_watch.ID,
            'nonce': streamit_continue_watch.nonce,
        },
        type: 'GET',
    });
}
