/*----------------------------------------------
Index Of Script
------------------------------------------------
1. Page Loader
2. Back To Top
3. Header
6. Header Menu Dropdown
7. Mobile Menu Overlay
8. Inner-Slider
9. Select 2 Dropdown
10. Video popup
11. Flatpicker
12. Custom File Uploader
13. Vertical Menu
14. Add to cart with plus minus
15. Cart Btn
------------------------------------------------
Index Of Script
----------------------------------------------*/

(function ($) {
	"use strict";

	//sets the page postion to top, when loader is disabled to, prevent displaying broken content while loading, and disables scroll temporary
	$(window).on('beforeunload', function (e) {
		if ($('#loading').length <= 0) {
			$('body, html').animate({
				scrollTop: 0
			}, 800);

			// Disables mouse scroll
			window.addEventListener('mousewheel', preventScroll, { passive: false }); // For modern browsers
			window.addEventListener('DOMMouseScroll', preventScroll, { passive: false }); // For older Firefox

			function preventScroll(event) {
				event.preventDefault();
			}
		}
	});

	jQuery(window).on('load', function (e) {
		jQuery('body').removeClass('overflow-hidden');
		jQuery('ul.page-numbers').addClass('justify-content-center');

		/*------------------------
		Page Loader
		--------------------------*/
		jQuery("#loading").fadeOut(1000);

		/*------------------------
		Back To Top
		--------------------------*/
		const $backToTop = jQuery('#back-to-top');
		$backToTop.hide();

		jQuery(window).on("scroll", function (e) {
			e.preventDefault();

			const scrollTop = jQuery(this).scrollTop();
			$backToTop.stop().fadeTo(200, scrollTop > 200 ? 1 : 0);
		});

		$backToTop.on('click', function (e) {
			e.preventDefault();

			jQuery('html, body').animate({
				scrollTop: 0
			}, 800);

			return false;
		});

		jQuery('.widget .fa.fa-angle-down, #main .fa.fa-angle-down').on('click', function () {
			jQuery(this).next('.children, .sub-menu').slideToggle();
		});

		/*---------------------------
		Vertical Menu
		---------------------------*/
		if (jQuery('.menu-style-one.streamit-mobile-menu').length > 0) {
			getDefaultMenu();
			jQuery(window).on('resize', function () {
				getDefaultMenu();
			});
		}

		/*------------------------
		Header
		--------------------------*/
		function headerHeight() {
			var height = jQuery("#main-header").height();
			jQuery('.iq-height').css('height', height + 'px');
		}

		jQuery(function () {
			headerHeight();

			jQuery(window).resize(headerHeight);
			var position = jQuery(window).scrollTop();

			jQuery(window).on('scroll', function () {
				if (jQuery('.has-sticky').length > 0) {
					var scroll = jQuery(window).scrollTop();
					if (scroll < position) {
						jQuery('.has-sticky').addClass('header-up');
						jQuery('body').addClass('header--is-sticky');
						jQuery('.has-sticky').removeClass('header-down');
					} else {
						jQuery('.has-sticky').addClass('header-down');
						jQuery('.has-sticky').removeClass('header-up ');
						jQuery('body').removeClass('header--is-sticky');
					}
					if (scroll == 0) {
						jQuery('.has-sticky').removeClass('header-up');
						jQuery('.has-sticky').removeClass('header-down');
						jQuery('body').removeClass('header--is-sticky');
					}
					position = scroll;
				}
			});
		});
	});


	jQuery(document).ready(function () {

		/*------------------------
			Calculate Header Height 
	   --------------------------*/

		const headerHeightCount = () => {
			var header = document.querySelector('header');
			if (header) {
				let headerHeight = header.getBoundingClientRect().height;
				document.querySelector(':root').style.setProperty('--header-height', headerHeight + 'px');
			}
		}
		headerHeightCount();

		jQuery(window).on('resize', function () {
			headerHeightCount();
		});

		window.onscroll = function () {
			jQuery(document).find('.nav-link[aria-selected="true"]').addClass("active");
		};

		/*------------------------
		Header
		--------------------------*/
		function headerHeight() {
			var height = jQuery("#default-header").height();
			jQuery('.iq-height').css('height', height + 'px');
		}

		jQuery(function () {
			var header = jQuery("#main-header"),
				yOffset = 0,
				triggerPoint = 80;

			headerHeight();

			jQuery(window).resize(headerHeight);
		});

		/*---------------------------------------------------------------------
			Header Menu Dropdown
		---------------------------------------------------------------------*/
		jQuery('[data-toggle=more-toggle]').on('click', function () {
			jQuery(this).next().toggleClass('show');
		});

		/*---------------------------------------------------------------------
	   search bar toggle
	   ----------------------------------------------------------------------- */

		if (!jQuery("body").hasClass("streamit-default-header")) {

			if (jQuery("header .search__input").length > 0 && jQuery("header .search-box").length > 0) {
				jQuery('#btn-search').on('click', function (e) {
					var $this = jQuery(this);

					jQuery('li.header-search-right').toggleClass('iq-show');
					jQuery(this).parent('.search_form_wrap').toggleClass('iq-show');
					jQuery('header .search-box').toggleClass('active');

					jQuery('.iq-usermenu-dropdown li.header-user-rights ,.iq-usermenu-dropdown .header-user-rights').removeClass('iq-show');
					jQuery('header .iq-sub-dropdown.iq-user-dropdown').removeClass('active');

					//shows recent search history
					search_history_ajax_handler($this, '.header-search-right');
				});
			}
		};

		jQuery(document).on(' click', '#btn-user-list', function () {
			jQuery(this).parent().toggleClass('iq-show');
			jQuery(this).next('.iq-user-dropdown').toggleClass('active');
		});

		ajax_search();

		jQuery(document).on('mouseover', '#btn-user-list', function () {

			jQuery('.iq-usermenu-dropdown li.header-search-right , .iq-usermenu-dropdown .header-search-right, .search_form_wrap').removeClass('iq-show');
			jQuery('header .search-box, .search-box').removeClass('active');
		});
		jQuery(window).on('click', function (e) {
			if (!jQuery(e.target).closest(".header-search-right").length) {
				jQuery('.header-search-right').removeClass('iq-show');
			}
		});

		/*------------------------
			Search Bar Layout
		--------------------------*/
		if (jQuery(".btn-search").length > 0) {
			jQuery(document).on('click', '.btn-search', function () {
				jQuery(this).parent().find('.streamit-search').toggleClass('search--open');
			});
			jQuery(document).on('click', '.btn-search-close', function () {
				jQuery(this).closest('.streamit-search').toggleClass('search--open');
			});

		}

		/*------------------------
		   shop sidebar toggle button
	   --------------------------*/
		if (jQuery('.shop-filter-sidebar').length > 0) {
			jQuery(document).on('click', '.shop-filter-sidebar', function () {
				jQuery('body').find('.streamit-woo-sidebar').toggleClass('woo-sidebar-open');
				jQuery('body').addClass('woof-overlay');

			});
		}

		/*------------------------
			Close Panel And Menu When Click Outside
		--------------------------*/

		jQuery(window).on('click', function (e) {
			let target = jQuery(e.target);

			if (!target.closest(".search_form_wrap.iq-show").length) {
				jQuery('.search_form_wrap.iq-show').removeClass('iq-show');
			}

			if (!target.closest(".header-user-rights.iq-show").length) {
				jQuery('.header-user-rights.iq-show').removeClass('iq-show');
			}
			if (!target.closest(".iqonic-custom-layouts.open").length) {
				jQuery('.iqonic-custom-layouts.open').removeClass('open');
			}
			if (!target.closest(".streamit-woo-sidebar.woo-sidebar-open").length && !target.hasClass('streamit-filter-button') && !target.parent().hasClass('streamit-filter-button')) {
				jQuery('.streamit-woo-sidebar.woo-sidebar-open').removeClass('woo-sidebar-open');
				jQuery('body').removeClass('woof-overlay');
			}
		});

		jQuery('.iqonic-custom-layouts').each(function () {
			let id = '#' + jQuery(this).attr('id');
			let clickId = 'a[href=' + id + ']';
			jQuery(clickId).on('click', function (e) {
				jQuery('.search_form_wrap.iq-show').removeClass('iq-show');
				jQuery('.header-user-rights.iq-show').removeClass('iq-show');
				e.stopPropagation();
			});
		});

		jQuery(window).on('click', function (e) {
			if (!jQuery(e.target).closest(".iqonic-custom-layouts.open").length) {
				jQuery('.iqonic-custom-layouts.open').removeClass('open');
			}
		});

		/*---------------------------------------------------------------------
		Mobile Menu Overlay
		----------------------------------------------------------------------- */
		jQuery(document).on("click", function (event) {
			var jQuerytrigger = jQuery(".main-header .navbar");
			if (jQuerytrigger !== event.target && !jQuerytrigger.has(event.target).length) {
				jQuery(".main-header .navbar-collapse").collapse('hide');
				jQuery('body').removeClass('nav-open');
			}
		});
		jQuery('.c-toggler').on("click", function () {
			jQuery('body').addClass('nav-open');
		});


		watchlist_last_item();

		// jQuery(document).ready(function () {
		// 	let videoPlayer = document.querySelector(".iq-main-slider video").player;
		// 	let videoPlayerID = videoPlayer.node.id;

		// 	const video = document.getElementById(videoPlayerID);
		// 	video.autoplay = true;
		// 	video.muted = true;
		// });

		/*------------------------
			Inner-Slider
		--------------------------*/
		if (jQuery('.inner-slider').length > 0) {
			jQuery('.inner-slider').slick({
				speed: 300,
				dots: false,
				arrows: true,
				infinite: true,
				autoplay: false,
				slidesToShow: 6,
				slidesToScroll: 1,
				nextArrow: '<button class="NextArrow-two"><i class="fas fa-angle-right"></i></button>',
				prevArrow: '<button class="PreArrow-two"><i class="fas fa-angle-left"></i></button>',
				responsive: [{
					breakpoint: 1200,
					settings: {
						slidesToShow: 3,
						slidesToScroll: 1,
						infinite: true,
						dots: true
					}
				},
				{
					breakpoint: 768,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 1
					}
				},
				{
					breakpoint: 480,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 1,
						arrows: false,
					}
				}
				]
			});

			jQuery('.inner-slider').each(function () {
				var jQuerySlider = jQuery(this);
				var active = jQuerySlider.find(".slick-active")
				var slideItems = jQuerySlider.find(".slick-track .slide-item,.slick-track .slide-items");
				active.first().addClass("first");
				active.last().addClass("last");

				jQuerySlider.on('afterChange', function (event, slick, currentSlide, nextSlide) {
					var active = jQuerySlider.find(".slick-active");
					slideItems.removeClass("first last");
					active.first().addClass("first");
					active.last().addClass("last");
				});
			});
		}

		jQuery('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
			jQuery('.inner-slider').slick('setPosition');
		})

		/*---------------------------------------------------------------------
			Select 2 Dropdown
		-----------------------------------------------------------------------*/
		if (jQuery('select').hasClass('season-select')) {
			jQuery('select.season-select').select2({
				// theme: 'bootstrap4',
				allowClear: false,
				width: 'resolve',
				minimumResultsForSearch: -1,
				dropdownCssClass: 'seasons-dropdown'
			});
		}
		if (jQuery('select').hasClass('pro-dropdown')) {
			jQuery('.pro-dropdown').select2({
				theme: 'bootstrap4',
				minimumResultsForSearch: Infinity,
				width: 'resolve'
			});
			jQuery('#lang').select2({
				theme: 'bootstrap4',
				placeholder: 'Language Preference',
				allowClear: true,
				width: 'resolve'
			});
		}

		if (jQuery('select:not(.select2-hidden-accessible)').length > 0) {

			jQuery('select:not(.season-select)').each(function () {
				let select_config = {
					width: '100%',
					dropdownParent: jQuery(this).parent()
				}
				if (jQuery(this).parent().closest(".checkout").length > 0) {
					select_config = {
						width: '100%',
					}
				}
				jQuery(this).select2(select_config);
			});

			jQuery('.select2-container').addClass('wide');

		}

		/*---------------------------------------------------------------------
			Video popup
		-----------------------------------------------------------------------*/
		if (jQuery('.video-open').length > 0) {
			jQuery('.video-open').magnificPopup({
				type: 'iframe',
				mainClass: 'mfp-fade',
				removalDelay: 160,
				preloader: false,
				fixedContentPos: false,
				autoFocusLast:false,
				iframe: {
					markup: '<div class="mfp-iframe-scaler">' +
						'<div class="mfp-close"></div>' +
						'<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>' +
						'</div>',

					srcAction: 'iframe_src',
				}
			});
		}


		/*---------------------------------------------------------------------
			Custom File Uploader
		-----------------------------------------------------------------------*/
		jQuery(".file-upload").on("change", function () {
			! function (e) {
				if (e.files && e.files[0]) {
					var t = new FileReader;
					t.onload = function (e) {
						jQuery(".profile-pic").attr("src", e.target.result)
					}, t.readAsDataURL(e.files[0])
				}
			}(this)
		}), jQuery(".upload-button").on("click", function () {
			jQuery(".file-upload").click();
		});


		/*------------------------
			Comment Form validation
		--------------------------*/
		if (jQuery('.validate-form').length > 0) {
			jQuery('.validate-form #commentform').submit(function () {
				jQuery('.error-msg').hide();
				var cmnt = jQuery.trim(jQuery(".validate-form #comment").val());
				var error = '';
				if (jQuery(".validate-form #author").length > 0) {
					var author = jQuery.trim(jQuery(".validate-form #email").val());
					var email = jQuery.trim(jQuery(".validate-form #author").val());
					var url = jQuery.trim(jQuery(".validate-form #url").val());
					jQuery(".validate-form #comment,.validate-form #author,.validate-form #email,.validate-form #url").removeClass('iq-warning');

					if (cmnt === "") {
						jQuery(".validate-form #comment").addClass('iq-warning');
						error = '1';
					}
					if (author === "") {
						jQuery(".validate-form #author").addClass('iq-warning');
						error = '1';
					}
					if (email === "") {
						jQuery(".validate-form #email").addClass('iq-warning');
						error = '1';
					}
					if (url === "") {
						jQuery(".validate-form #url").addClass('iq-warning');
						error = '1';
					}

				} else {
					jQuery(".validate-form #comment").removeClass('iq-warning');
					if (cmnt === "") {
						jQuery(".validate-form #comment").addClass('iq-warning');
						error = '1';
					}
				}
				if (error !== '' && error === '1') {
					jQuery('.error-msg').html('One or more fields have an error. Please check and try again.');
					jQuery('.error-msg').slideDown();
					return false;
				}


			});
		}

		/*------------------------
		   Description Tab
	   --------------------------*/
		jQuery('.streamit-content-details .nav-link:first').addClass('active');
		jQuery('.streamit-content-details .tab-pane:first').addClass('active show');

		/*------------------------
			Read More content
		--------------------------*/
		var content_count = jQuery(".streamit-content-details .show-more a,.iq-tvshows-slider .shows-content .show-more a").attr('data-count');
		if (content_count > 50) {
			jQuery(".streamit-content-details .show-more a, .iq-tvshows-slider .shows-content .show-more a").on("click", function () {
				var $this = jQuery(this);
				var content = $this.parent().prev(".description-content");
				var moretext = $this.attr('data-showmore');
				var lesstext = $this.attr('data-showless');
				var linkText = $this.text();
				if (linkText === moretext) {
					var linkText_less = lesstext;
					linkText = linkText_less;
				} else {
					var linkText_more = moretext;
					linkText = linkText_more;
				}
				content.toggleClass('showContent hideContent');

				$this.text(linkText);
			});
		}
		/*---------------------------------------------------------------------
			Slick Slider
		----------------------------------------------------------------------- */

		jQuery('.season-select.iq-single').on('change', function () { //For Single Page Season Select Only
			jQuery('.streamit_seasons_episode_tab').each(function () {
				jQuery(this).removeClass('active show');
			});
			jQuery('[data-season="' + jQuery(this).val() + '"]').addClass('active show');
		});


		/*---------------------------
		Vertical Menu
		---------------------------*/
		jQuery('nav.mobile-menu .widget i,nav.mobile-menu .top-menu i').click(function () {
			jQuery(this).next('.children, .sub-menu').slideToggle();
		});

		/*---------------------------
		   Persons Circle Chart
		   ---------------------------*/
		circle_chart();

		/*------------------------
   main menu toggle
  --------------------------*/
		jQuery(document).on("click", '.custom-toggler', function () {
			if (jQuery('.streamit-mobile-menu ').hasClass('menu-open')) {
				jQuery('.streamit-mobile-menu ').toggleClass('open-delay');
				setTimeout(function () {
					jQuery('.streamit-mobile-menu ').toggleClass('menu-open');
					jQuery('.streamit-mobile-menu ').toggleClass('open-delay');
				});
			} else {
				jQuery('.streamit-mobile-menu ').toggleClass('menu-open');
			}
			jQuery('.opn-menu').toggleClass('streamit-open');
		});
		jQuery(document).on("click", '.ham-toggle', function () {
			jQuery('.ham-toggle .menu-btn').toggleClass('is-active');
		});
		jQuery(document).on("click", '.mob-toggle', function () {
			jQuery('body').toggleClass('overflow-hidden');
		});


		/*------------------------
		Add to cart with plus minus
		--------------------------*/
		jQuery(document).on('click', 'button.plus, button.minus', function () {

			jQuery('button[name="update_cart"]').removeAttr('disabled');

			var qty = jQuery(this).closest('.quantity').find('.qty');


			if (qty.val() == '') {
				qty.val(0);
			}
			var val = parseFloat(qty.val());

			var max = parseFloat(qty.attr('max'));
			var min = parseFloat(qty.attr('min'));
			var step = parseFloat(qty.attr('step'));

			// Change the value if plus or minus
			if (jQuery(this).is('.plus')) {
				if (max && (max <= val)) {
					qty.val(max);
				} else {
					qty.val(val + step);
				}
			} else {
				if (min && (min >= val)) {

					qty.val(min);
				} else if (val >= 1) {

					qty.val(val - step);
				}
			}
			set_quanity(jQuery(this));
		});




		/*------------------------
		Cart btn 
		--------------------------*/

		if (jQuery(document).find('.dropdown-hover').length > 0) {
			jQuery(document).on('click', ".dropdown-hover a.dropdown-cart", function () {
				jQuery(".dropdown-menu-mini-cart").addClass('cart-show');
			});
			jQuery(document).on('click', ".dropdown-close", function () {
				jQuery(".dropdown-menu-mini-cart").removeClass('cart-show');
			});
			jQuery('body').mouseup(function (e) {
				if (jQuery(e.target).parents('.dropdown-menu-mini-cart').length === 0) {
					jQuery(".dropdown-menu-mini-cart").removeClass('cart-show');
				}
			});
			jQuery(".streamit-users-settings .dropdown-hover").hover(function () {
				var isHovered = jQuery(this).is(":hover");
				if (isHovered) {
					jQuery(this).find(".dropdown-menu").stop().fadeIn(300);
				} else {
					jQuery(this).find(".dropdown-menu").stop().fadeOut(300);
				}
			});
		}

		jQuery('.streamit-count-box').prev('.wp_ulike_counter_up').hide();

		/*------------------------
		Default Active Tab Script 
		--------------------------*/

		let tabs = document.querySelectorAll('.trending-pills li a');
		if (tabs !== undefined && tabs.length != 0 && !jQuery('.trending-pills li a').hasClass('active')) {
			var firstTab = new bootstrap.Tab(document.querySelector('.trending-pills li:first-child a'))
			firstTab?.show()
		}

		//Download URL For Masvideos Movies/Episodes
		streamit_masvideos_download_sources_link();
	});


	jQuery(document).on('change input', 'input.qty', function () {
		set_quanity(jQuery(this));
	});

	jQuery('.show-more-btn').click(function () {
		let id = jQuery(this).attr('data-target');
		jQuery('a[href=' + id + ']').tab('show');


		jQuery('html, body').stop().animate({
			'scrollTop': jQuery('a[href=' + id + ']').offset().top - 200
		}, 800, 'swing');
	});
	jQuery(document).on('added_to_cart', function (a, b, c, d) {
		jQuery('*[title]').tooltip('disable');
	});

	jQuery(document.body).on('woosq_loaded woosq_close', function () {
		jQuery('#woosq-popup select').select2({
			theme: 'bootstrap4',
			allowClear: false,
		});
	});

	if (jQuery('.streamit-notification').length > 0) {
		let args = {
			cssPath: streamit_loadmore_params.template_dir + '/assets/css/notification.min.css',
			jsPath: streamit_loadmore_params.template_dir + '/assets/js/notification.min.js',
			id: "streamit-notification"
		};

		streamit_enqueue_scripts(args);
	}
})(jQuery);

const setCookie = function (cname, cvalue, exdays = 1) {
	let date = new Date();
	date.setTime(date.getTime() + (exdays * 24 * 60 * 60 * 1000));
	const expires = "expires=" + date.toUTCString();
	let domain = "domain=" + !isSubdomain() ? "." + window.location.hostname : "" + window.location.hostname + ";";
	document.cookie = cname + "=" + cvalue + "; " + expires + "; Path=/;" + domain;
}

const isSubdomain = function (url = window.location.hostname) {
	var regex = new RegExp(/^([a-z]+\:\/{2})?([\w-]+\.[\w-]+\.\w+)$/);
	return !!url.match(regex); // make sure it returns boolean
}

const getCookie = function (cname) {
	var name = cname + "=";
	var ca = document.cookie.split(';');
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') {
			c = c.substring(1);
		}
		if (c.indexOf(name) == 0) {
			return c.substring(name.length, c.length);
		}
	}
	return "";
}

/*------------------------
		 watchlist last item
--------------------------*/
function watchlist_last_item() {
	if (jQuery('.wl-child').length) {
		jQuery('.iq_genres-contents ,.iq_archive_items,.watchlist-contens , .movie_playlist').each(function () {


			let count;
			let in_count;
			let width = jQuery(window).width();
			if (width > 991) {
				count = 3;
				in_count = 4;
			} else if (width > 767 && width < 991) {
				count = 2;
				in_count = 3;
			} else if (width < 768) {
				count = 1;
				in_count = 2;
			} else {
				count = 3;
				in_count = 4;
			}
			let k = 0;
			let j = count;
			let len = jQuery(this).find('.wl-child').length;

			jQuery(this).find('.wl-child').each(function () {
				if (k === 0) {
					jQuery(this).find('.watchlist-img,.archive-media').addClass('watchlist-first');
				}
				if (j == k || k === count || (len.length - 1) === k) {
					j += in_count;
					jQuery(this).find('.watchlist-img,.archive-media').addClass('watchlist-last');
					jQuery(this).next().find('.watchlist-img,.archive-media').addClass('watchlist-first');
				}
				k++;
			});
		});

		jQuery('.iq_tags-contents').each(function () {
			let count;
			let in_count;
			let width = jQuery(window).width();

			if (width > 991) {
				count = 5;
				in_count = 6;
			} else if (width > 767 && width < 991) {
				count = 3;
				in_count = 4;
			} else if (width < 768) {
				count = 2;
				in_count = 3;
			} else {
				count = 3;
				in_count = 4;
			}
			let k = 0;
			let j = count;
			let len = jQuery(this).find('.wl-child').length;
			jQuery(this).find('.wl-child').each(function () {
				if (k === 0) {
					jQuery(this).find('.iq-tag-box').addClass('watchlist-first');
				}
				if (j == k || k === count || (len.length - 1) === k) {
					j += in_count;
					jQuery(this).find('.iq-tag-box').addClass('watchlist-last');
					jQuery(this).next().find('.iq-tag-box').addClass('watchlist-first');
				}
				k++;
			});
		});
	}
}

function circle_chart() {
	jQuery('.progress').each(function () {
		let deg = jQuery(this).data('deg');
		if (deg > 180) {
			jQuery(this).css('--secound', deg + 'deg');
		} else {
			jQuery(this).css({
				'--first': deg + 'deg',
				'--secound': 0 + 'deg'
			});
			jQuery(this).children('.right').hide();
		}
	});

}

function getDefaultMenu() {
	jQuery('.menu-style-one nav.mobile-menu .sub-menu').css('display', 'none ');
	jQuery('.menu-style-one nav.mobile-menu .top-menu li .dropdown').hide();
	jQuery('.menu-style-one nav.mobile-menu .sub-menu').prev().prev().addClass('submenu');
	jQuery('.menu-style-one nav.mobile-menu .sub-menu').before('<span class="toggledrop"><i class="fas fa-plus menu-open"></i><i class="fas fa-minus menu-close"></i></span>');

	jQuery('nav.mobile-menu .widget i,nav.mobile-menu .top-menu i').on('click', function () {
		jQuery(this).next('.children, .sub-menu').slideToggle();
	});
	jQuery('.menu-style-one nav.mobile-menu .top-menu .menu-item .toggledrop').off('click');

	jQuery('.menu-style-one nav.mobile-menu .menu-item .toggledrop').on('click', function () {
		if (jQuery(this).closest(".menu-is--open").length == 0) {
			jQuery('.menu-style-one nav.mobile-menu .menu-item').removeClass('menu-is--open');
		}
		if (jQuery(this).parent().find("ul").length > 1) {
			jQuery(this).parent().addClass('menu-is--open');
		}
		jQuery('.menu-style-one nav.mobile-menu .menu-item:not(.menu-is--open) .children,.menu-style-one nav.mobile-menu .menu-item:not(.menu-is--open) .sub-menu').slideUp();
		if (!jQuery(this).next('.children, .sub-menu').is(':visible') || jQuery(this).parent().hasClass("menu-is--open")) {
			jQuery(this).next('.children, .sub-menu').slideToggle();
		}
		jQuery('.menu-style-one nav.mobile-menu .menu-item:not(.menu-is--open) .toggledrop').not(jQuery(this)).removeClass('active');
		jQuery(this).toggleClass('active');

		jQuery('.menu-style-one nav.mobile-menu .menu-item').removeClass('menu-clicked');
		jQuery(this).parent().addClass('menu-clicked');

		jQuery('.menu-style-one nav.mobile-menu .menu-item').removeClass('current-menu-ancestor');
	});
}

// Wocomerce Set Quantiy Input 
function set_quanity(this_) {
	if (!this_.hasClass('qty')) {
		this_ = this_.siblings('input.qty');
	}
	let current = this_.attr('name');

	let item_hash = current ? current.replace(/cart\[([\w]+)\]\[qty\]/g, "$1") : false;
	if (!item_hash)
		return

	let item_quantity = this_.val();
	let currentVal = parseFloat(item_quantity);

	jQuery.ajax({
		type: 'POST',
		url: streamit_loadmore_params.ajaxurl,
		data: {
			action: 'qty_cart',
			hash: item_hash,
			quantity: currentVal
		},
		success: function (res) {
			jQuery(document.body).trigger('wc_fragment_refresh');
			jQuery('.streamit-cart-count').html(res['data']['quantity'])
		}
	});
}

function search_history_ajax_handler($this, $closest) {
	jQuery.ajax({
		url: streamit_loadmore_params.ajaxurl,
		type: 'POST',
		data: {
			action: 'load_search_result',
		},
		beforeSend: function () {
			$this.closest($closest).find('.search_result_history').css("display", "none");
		},
		success: function (data) {
			$this.closest($closest).find('.search_result_history').css("display", "block")
			$this.closest($closest).find('.search_result_history').html(data);

			search_history_click(); //ajax call when clicked on searched result
		}
	});

	ajax_search_input_closed($closest) // code to be executed when the search input is cleared or closed
}

function search_history_click() {
	jQuery('.search-result').on('click', function () {
		var keyword = jQuery(this).text();
		var form = jQuery(this).closest('form');

		keyword = keyword.trim();
		jQuery('.search__input').val(keyword);

		jQuery.ajax({
			url: streamit_loadmore_params.ajaxurl,
			type: 'post',
			data: {
				action: 'data_fetch',
				keyword: keyword,
				is_include: 'posts',
			},
			beforeSend: function () {
				form.find('.search_result_history').css("display", "none");
			},
			success: function (data) {
				form.find('.datafetch').html(data);
				form.find('.datafetch').css('display', 'block');
			}
		});
	});
}

function ajax_search_input_closed($closest) {

	jQuery('#searchInput').on('search', function (e) {
		e.stopPropagation();
		e.preventDefault();

		var $this = jQuery(this);
		var form = jQuery(this).closest('form');

		form.find('.datafetch').css('display', 'none');
		// search_history_ajax_handler($this,$closest);
	});
}

function streamit_masvideos_download_sources_link() {

	jQuery('.download_source_link').on("click", function () {
		const $this = jQuery(this);
		let FileUrl = $this.data('url');
		let FileName = $this.data('filename');

		var data = {
			action: 'download_file',
			FileUrl: FileUrl,
			FileName: FileName
		}

		jQuery.ajax({
			url: streamit_loadmore_params.ajaxurl,
			type: 'POST',
			dataType: 'json',
			data: data,
			success: function (response) {
				if (response) {
					var DownloadFileURL = response.fileUrl;
					var DownloadFileName = response.fileName;

					if (DownloadFileURL !== undefined && DownloadFileName !== undefined) {
						var a = document.createElement('a');
						a.href = DownloadFileURL;
						a.download = DownloadFileName;

						// Check if the file extension is ".mp4"
						if (DownloadFileURL.toLowerCase().endsWith(".mp4")) {
							// Add "target" attribute to ensure download behavior on Safari
							a.target = "_blank";
						}

						a.style.display = 'none';

						document.body.appendChild(a);
						a.click();
						document.body.removeChild(a);
					} else {
						alert('Error downloading the file!');
					}
				}
			},
			error: function (xhr) {
				alert('Error downloading the file!');
			}
		});
	});
}

function ajax_search() {
	jQuery('.iq-ajax-search').each(function (e) {
		jQuery(this).find('.search-toggle').on('click', function () {
			var $this = jQuery(this);

			$this.parent().addClass('iq-show');
			$this.addClass('active');
			$this.siblings('.search-box').find('.search__input').focus();

			//shows recent search history
			search_history_ajax_handler($this, '.iq-ajax-search');
		});

		jQuery(this).find('.search__input').keyup(_.debounce(function () {

			let keyword = jQuery(this).val();
			let style = jQuery(this).data('search-style');
			let form = jQuery(this).closest("form");
			if (keyword.length < 3) return;
			if (keyword == "") {
				jQuery(this).siblings('.datafetch').html('');
			} else {
				jQuery.ajax({
					url: streamit_loadmore_params.ajaxurl,
					data: {
						action: 'data_fetch',
						keyword: keyword,
						style: style
					},
					type: 'POST',
					beforeSend: function () {
						form.find('.search_result_history').css("display", "none");
						for (var i = 0; i < 3; i++) {
							form.find('.datafetch').css('display', 'block');
							form.find('.datafetch').html('<div class="episodes-info skeleton-box"><div class="skeleton-img skeleton"></div><div class="skeleton-meta"><div class="skeleton-name skeleton"></div><div class="skeleton-time skeleton"></div></div></div>');
						}
					},
					success: function (data) {
						form.find('.datafetch').html(data);
					}
				});
			}
		}, 500));
	});

	jQuery(window).on('click', function (e) {
		if (!jQuery(e.target).closest(".iq-ajax-search").length) {
			jQuery('.iq-ajax-search.iq-show').removeClass('iq-show');
			jQuery('.datafetch').css('display', 'none');
		}
	});
}

function streamit_enqueue_scripts(args) {

	const version = streamit_loadmore_params.version;
	const cssElement = document.createElement("link");
	const jsElement = document.createElement("script");

	const cssPath = args.cssPath;
	const jsPath = args.jsPath;

	cssElement.setAttribute("rel", "stylesheet");
	cssElement.setAttribute("id", args.id + "-css");
	cssElement.setAttribute("href", cssPath + '?ver=' + version);
	document.head.append(cssElement);

	jsElement.setAttribute("id", args.id + "-js");
	jsElement.setAttribute("src", jsPath + '?ver=' + version);
	document.head.append(jsElement);
}