
(function (jQuery) {
    jQuery(window).on('load', readyHandler)
    jQuery(document).ready(readyHandler)
})(jQuery);

function readyHandler() {
    var watchDebounceSeekedHandler = _.debounce(watchHandler, 200, false);
    var watchDebounceTimeupdateHandler = _.debounce(watchHandler, 1000, false);
    let mediaPlayer = jQuery(".iq-main-slider video");

    if (mediaPlayer.length == 0) {
        mediaPlayer = jQuery(".single-product video");
    }

    mediaPlayer.on('timeupdate', function (event) {
        var totaltime = Math.floor(this.duration),
            currenttime = Math.floor(this.currentTime),
            percent = Math.floor((currenttime * 100) / totaltime);

        if (currenttime % 17 == 0 && currenttime != 0) {
            watchDebounceTimeupdateHandler(currenttime, totaltime, percent)
        }
    });

    mediaPlayer.on('seeked', function (event) {
        var totaltime = Math.floor(this.duration),
            currenttime = Math.floor(this.currentTime),
            percent = Math.floor((currenttime * 100) / totaltime);

        watchDebounceSeekedHandler(currenttime, totaltime, percent)
    });

    mediaPlayer.on('ended', watchedAjaxHandler);

    typeof MediaElementPlayer !== "undefined" && jQuery.extend(MediaElementPlayer.prototype, {
        buildcontinueWatching: function (player, controls, layers, media) {
            jQuery(`<div class="streamit-video-continue-watch-container mejs-layer">
            <div class="streamit-video-continue-watch">
                <p> ${streamit_continue_watch?.desc} </p>
                <div class="continue-watch-model-btn-wrapper">
                    <button class='btn btn-hover iq-button' onClick="continueWatchHandler(this)">${streamit_continue_watch?.resume_btn}</button>
                    <button class='btn btn-hover iq-button' onClick="continueWatchRemoveHandler(this)">${streamit_continue_watch?.cancle_btn}</button>
                </div>
            </div>
        </div>`)
                .css('display', 'none')
                .appendTo(layers);
        }
    });

    if (typeof mediaPlayer.mediaelementplayer === 'function' && typeof streamit_upcoming_episode == "undefined") {
        mediaPlayer.mediaelementplayer({
            features: [typeof streamit_continue_watch != undefined && 'continueWatching', typeof streamit_upcoming_episode != undefined && 'nextEpisode', 'playpause', 'current', 'progress', 'duration', 'volume', 'fullscreen', 'Unfocus'],
            error: function (mediaElementObject, domObject) {
                jQuery('.streamit-video-continue-watch-container').hide();
            },
        });
    }
}