<?php

/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package streamit
 */

namespace Streamit\Utility;

global $wp_query, $streamit_options;

get_header();

$streamit_layout          = '';
$post_section               = streamit()->post_style();
// $args['post_type']          = $wp_query->query_vars['post_type'];
$is_sidebar                 = streamit()->is_primary_sidebar_active();
$options_streamit_load    = !empty($streamit_options) ? $streamit_options['streamit_genere_tag_category_item'] : '';
$archive_cards_style        = isset($streamit_options['streamit_archive_cards_style']) && !empty($streamit_options['streamit_archive_cards_style']) ? $streamit_options['streamit_archive_cards_style'] : '1';

$is_ajax_enable      = true;
$lazy_load           = $is_ajax_enable ? " iqonic-lazy-load-images" : '';

if ($wp_query->query_vars['post_type'] != 'person' && $wp_query->query_vars['post_type'] != 'tv_show')
    $args = $wp_query->query;

if (isset($streamit_options['streamit_blog']))
    $streamit_layout = $streamit_options['streamit_blog'];

$args['posts_per_page'] = isset($streamit_options['streamit_genere_tag_category_post_per_page']) && !empty($streamit_options['streamit_genere_tag_category_post_per_page']) ? $streamit_options['streamit_genere_tag_category_post_per_page'] : $wp_query->query_vars['posts_per_page'];
// $is_generes_tag         = !empty(wp_get_post_terms(get_the_ID(), array('movie_genre', 'movie_tag', 'video_tag', 'video_cat', 'tv_show_tag', 'tv_show_genre', 'persons')));
$is_generes_tag         = !empty(wp_get_post_terms(get_the_ID(), array('movie_genre', 'movie_tag', 'video_tag', 'video_cat', 'tv_show_tag', 'tv_show_genre'))) || !empty(get_post_type() == 'person');

if ($is_generes_tag) {
    if ($archive_cards_style == "2") {
        wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css');
        $main_class = 'iq-card-wrapper streamit_datapass_archive';
    } else {
        $main_class = 'watchlist-contens streamit_datapass_archive';
    }
} else {
    $main_class = 'streamit_datapass_blog streamit_datapass_archive';
}
$main_class .= $lazy_load;
$args['post_type'] = get_post_type();
$wp_post = new \WP_Query($args); ?>
<div class="site-content-contain">
    <div id="content" class="site-content">
        <div id="primary" class="content-area">
            <main id="main" class="site-main <?php echo esc_attr($main_class); ?>" data-displaypost="<?php echo esc_attr($args['posts_per_page']) ?>" data-options="<?php echo esc_attr($is_generes_tag ? $options_streamit_load : $streamit_options['streamit_display_pagination']); ?>" data-pages="<?php echo esc_attr(round($wp_post->found_posts / $args['posts_per_page'])) ?>" data-totalpages="<?php echo esc_attr($wp_post->max_num_pages) ?>">
                <?php if (class_exists('MasVideos') && $is_generes_tag && !(is_date() || is_author()) && get_post_type() != 'post') {
                    if ($wp_post->have_posts()) { ?>
                        <div class="container-fluid ">
                            <div class="row iq_archive_items <?php echo esc_attr('iq-archive-' . get_post_type()) ?>">
                                <?php while ($wp_post->have_posts()) {
                                    $wp_post->the_post();
                                    get_template_part('template-parts/content/entry_archive', get_post_type($wp_post->ID));
                                }
                                wp_reset_postdata(); ?>
                            </div>

                            <?php if (isset($streamit_options['streamit_genere_tag_category_item'])) {
                                $options = $streamit_options['streamit_genere_tag_category_item'];

                                if ($options == "load_more") {
                                    if (get_post_type() != "person") {
                                        if ($wp_post->max_num_pages > 1)
                                            echo '<a class="streamit_loadmore_btn btn btn-hover iq-button" tabindex="0" data-loading-text="' . $streamit_options['streamit_genere_tag_category_loadmore_text_2'] . '"><span data-parallax="scroll">' . $streamit_options['streamit_genere_tag_category_display_loadmore_text'] . '</span></a>';
                                    } else {
                                        echo '<a class="streamit_persons_list btn btn-hover iq-button" tabindex="0" data-loading-text="' . $streamit_options['streamit_genere_tag_category_loadmore_text_2'] . '"><span data-parallax="scroll">' . $streamit_options['streamit_genere_tag_category_display_loadmore_text'] . '</span></a>';
                                    }
                                } elseif ($options == "infinite_scroll") {
                                    echo '<div class="loader-wheel-container"></div>';
                                } else {
                                    get_template_part('template-parts/content/pagination');
                                }
                            } else {
                                get_template_part('template-parts/content/pagination');
                            } ?>
                        </div>
                    <?php
                    } else {
                        get_template_part('template-parts/content/error');
                    }
                } else {
                    $args = $wp_query->query_vars;
                    unset($args['post_type']);
                    unset($args['posts_per_page']);
                    $args['post_type'] = array('post'); ?>

                    <div class="container">
                        <div class="row <?php echo esc_attr($post_section['row_reverse']); ?>" id="<?php if($streamit_options['streamit_display_pagination']=='infinite_scroll'){echo 'targetRow';} ?>">
                            <?php if ($is_sidebar) {
                                echo '<div class="col-xl-8 col-sm-12 streamit-blog-main-list">';
                            } else if ($streamit_layout != '4' && $streamit_layout != '5') {
                                echo '<div class="col-lg-12 col-sm-12 streamit-blog-main-list">';
                            }

                            if (have_posts()) {
                                while (have_posts()) {
                                    the_post();
                                    get_template_part('template-parts/content/entry', get_post_type(), ['entry_item_class' => $post_section['post']]);
                                }
                            } else {
                                get_template_part('template-parts/content/error');
                            }

                            if ($is_sidebar || $streamit_layout != '4' && $streamit_layout != '5') {
                                echo '</div>';
                                get_sidebar();
                            } ?>
                       

                <?php if (!is_singular()) {
                        if (isset($streamit_options['streamit_display_pagination'])) {
                            $options = $streamit_options['streamit_display_pagination'];
                            if ($options == "load_more") {

                                if ($wp_query->max_num_pages > 1)
                                    echo '<div class="col-12 default-loadmore-container"><a class="streamit_loadmore_btn_blog btn btn-hover iq-button" tabindex="0" data-loading-text="' . $streamit_options['streamit_display_blog_loadmore_text_2'] . '"><span>' . $streamit_options['streamit_display_blog_loadmore_text'] . '</span></a></div>';
                            } elseif ($options == "infinite_scroll") {

                                echo '<div class="loader-wheel-container"></div>';
                            } else {
                                get_template_part('template-parts/content/pagination');
                            }
                        } else {
                            get_template_part('template-parts/content/pagination');
                        }
                    }
                    ?>
                        </div>
                    </div>
                    <?php
                } ?>
            </main><!-- #main -->
        </div> <!-- #primary -->
    </div>
</div>

<?php get_footer();
