<?php

/**
 * Plugin Name:       Streamit Extensions
 * Plugin URI:        https://wordpress.iqonic.design/product/wp/streamit
 * Description:       Streamit Extension.
 * Version:           3.4.2
 * Author:            Iqonic Design
 * Author URI:        https://iqonic.design/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       streamit-extensions
 * Domain Path:       /languages
 */

use Iqonic\Classes\Streamit_Extension;
use Iqonic\Classes\Streamit_Extension_Activator;
use Iqonic\Classes\Streamit_Extension_Deactivator;

if (!defined('WPINC')) die;

if (!function_exists('get_plugin_data')) require_once(ABSPATH . 'wp-admin/includes/plugin.php');

define('SE_TEXT_DOMAIN', 'streamit-extensions');
define('STREAMIT_EXTENSION_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('STREAMIT_EXTENSION_PLUGIN_URL', plugins_url('/', __FILE__));

$plugin_data = get_plugin_data(STREAMIT_EXTENSION_PLUGIN_PATH . '/streamit-extension.php');
define('STREAMIT_EXTENSION_VERSION', $plugin_data['Version']);

// Require once the Composer Autoload
(file_exists(dirname(__FILE__) . '/vendor/autoload.php')) ? require_once dirname(__FILE__) . '/vendor/autoload.php' : die('Something went wrong');

register_activation_hook(__FILE__, [Streamit_Extension_Activator::class, 'activate']);
register_deactivation_hook(__FILE__,  [Streamit_Extension_Deactivator::class, 'deactivate']);

$get_config_widgets         = require_once STREAMIT_EXTENSION_PLUGIN_PATH . 'config.php';
$GLOBALS['iqonic_config']   = $get_config_widgets;

new Streamit_Extension();
