<?php

function streamit_social_media_widgets()
{
	register_widget('iq_socail_media');
}
add_action('widgets_init', 'streamit_social_media_widgets');

class iq_socail_media extends WP_Widget
{

	function __construct()
	{
		parent::__construct(

			// Base ID of your widget
			'iq_socail_media',

			// Widget name will appear in UI
			esc_html__('Iqonic Social Media', 'streamit-extensions'),

			// Widget description
			array('description' => esc_html('Iqonic social media. ', 'streamit-extensions'),)
		);
	}

	// Creating widget front-end

	public function widget($args, $instance)
	{
		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}

		$title = (!empty($instance['title'])) ? $instance['title'] : false;
		$title = apply_filters('widget_title', $title, $instance, $this->id_base);

		$iq_option = get_option('streamit_options');;

		if (isset($iq_option['social-media-iq'])) {
			$top_social = $iq_option['social-media-iq']; ?>
			<h6 class="footer-link-title">
				<?php if (!empty($title))
					echo esc_html($title);
				else
					echo esc_html__("Follow Us :", SE_TEXT_DOMAIN); ?>
			</h6>

			<ul class="info-share">
				<?php
				foreach ($top_social as $key => $value) {
					if ($value) {
						echo '<li><a target="_blank" href="' . $value . '"><i class="fab fa-' . $key . '"></i></a></li>';
					}
				}  ?>
			</ul>
		<?php
		}
	}

	// Widget Backend 
	public function form($instance)
	{
		$title     = isset($instance['title']) ? esc_attr($instance['title']) : ''; ?>

		<p>
			<label for="<?php echo esc_html($this->get_field_id('title', 'streamit-extensions')); ?>"><?php esc_html_e('Title:', 'streamit-extensions'); ?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('title', 'streamit-extensions')); ?>" name="<?php echo esc_html($this->get_field_name('title', 'streamit-extensions')); ?>" type="text" value="<?php echo esc_html($title, 'streamit-extensions'); ?>" />
		</p>
<?php
	}

	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		return $instance;
	}
}
