<?php

function unisaas_recent_post_widgets()
{
	register_widget('iq_subscribe');
}
add_action('widgets_init', 'unisaas_recent_post_widgets');

class iq_subscribe extends WP_Widget
{

	function __construct()
	{
		parent::__construct(

			// Base ID of your widget
			'iq_subscribe',

			// Widget name will appear in UI
			esc_html__('Iqonic Recent Post', SE_TEXT_DOMAIN),

			// Widget description
			array('description' => esc_html('Iqonic most recent Posts. ', SE_TEXT_DOMAIN),)
		);
	}

	// Creating widget front-end

	public function widget($args, $instance)
	{
		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}

		$title = (!empty($instance['title'])) ? $instance['title'] : false;

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters('widget_title', $title, $instance, $this->id_base);

		$number = (!empty($instance['number'])) ? absint($instance['number']) : 5;
		if (!$number) {
			$number = 5;
		}
		$show_date = isset($instance['show_date']) ? $instance['show_date'] : false;

		/* here add extra display item  */

		$iq_contact = isset($instance['iq-contact']) ? $instance['iq-contact'] : ''; ?>

		<div class="iq-widget-menu widget">
			<?php if ($title) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
			<div class="list-inline iq-widget-menu">
				<ul class="iq-post">
					<?php $args = array('post_type' => 'post', 'posts_per_page' => $number,);
					$loop = new WP_Query($args);
					while ($loop->have_posts()) : $loop->the_post(); ?>
						<li>
							<?php if ($iq_contact) {
								foreach ($iq_contact as $iq_contacts) { ?>
									<div class="post-img">
										<?php if ($iq_contacts == "image") {
											$img_url = wp_get_attachment_image_url(get_post_thumbnail_id(get_the_ID()), "thumbnail"); ?>
											<div class="post-img-holder">
												<a href="<?php echo esc_url(get_permalink($loop->ID)); ?>" style='background-image: url("<?php echo esc_url($img_url); ?>");'></a>
											</div>
										<?php } ?>

										<div class="post-blog">
											<div class="blog-box">
												<ul class="list-inline">
													<a class="new-link" href="<?php echo esc_url(get_permalink($loop->ID)); ?>">
														<h6><?php the_title(); ?></h6>
													</a>

													<?php if ($show_date) : ?>
														<li class="list-inline-item  mr-3"><a class="date-widget" href="<?php echo esc_url(get_permalink($loop->ID)); ?>">
																<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
																	<path d="M2.19336 5.59936H11.8109" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M9.39685 7.70678H9.40185" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M7.00232 7.70678H7.00732" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M4.60291 7.70678H4.6079" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M9.39685 9.80371H9.40185" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M7.00232 9.80371H7.00732" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M4.60291 9.80371H4.6079" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M9.18255 1.60425V3.37991" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path d="M4.82318 1.60425V3.37991" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																	<path fill-rule="evenodd" clip-rule="evenodd" d="M11.8571 2.4563H2.14453V12.3959H11.8571V2.4563Z" stroke="#E50914" stroke-width="1.5" stroke-linecap="square"></path>
																</svg>
																<?php echo get_the_date();  ?></a></li>
													<?php endif; ?>
												</ul>
											</div>
										</div>
									</div>
								<?php }
							} ?>
						</li>
					<?php endwhile;
					wp_reset_postdata(); ?>
				</ul>
			</div>
		</div>
	<?php
	}

	// Widget Backend
	public function form($instance)
	{
		$title     = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$number    = isset($instance['number']) ? absint($instance['number']) : 5;
		$show_date = isset($instance['show_date']) ? (bool) $instance['show_date'] : false;

		if (isset($instance['iq-contact'])) {
			$iq_contact = $instance['iq-contact'];
			foreach ($iq_contact as $iq_contacts) {
				if ($iq_contacts == "image") {
					$ch_image = "checked";
				}
			}
		} ?>

		<p>
			<label for="<?php echo esc_html($this->get_field_id('title', 'streamit-extensions')); ?>"><?php esc_html_e('Title:', 'streamit-extensions'); ?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('title', 'streamit-extensions')); ?>" name="<?php echo esc_html($this->get_field_name('title', 'streamit-extensions')); ?>" type="text" value="<?php echo esc_html($title, 'streamit-extensions'); ?>" />
		</p>

		<p>
			<label for="<?php echo esc_html($this->get_field_id('number', 'streamit-extensions')); ?>"><?php esc_html_e('Number of posts to show:', 'streamit-extensions'); ?></label>
			<input class="tiny-text" id="<?php echo esc_html($this->get_field_id('number', 'streamit-extensions')); ?>" name="<?php echo esc_html($this->get_field_name('number', 'streamit-extensions')); ?>" type="number" step="1" min="1" value="<?php echo esc_html($number, 'streamit-extensions'); ?>" size="3" />
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($show_date); ?> id="<?php echo esc_html($this->get_field_id('show_date', 'streamit-extensions')); ?>" name="<?php echo esc_html($this->get_field_name('show_date', 'streamit-extensions')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('show_date', 'streamit-extensions')); ?>"><?php esc_html_e('Display post Date?', 'streamit-extensions'); ?></label>
		</p>

		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('iq-contact', 'streamit-extensions')); ?>" name="<?php echo esc_html($this->get_field_name('iq-contact[]', 'streamit-extensions')); ?>" value="image" <?php if (isset($ch_image)) echo esc_html($ch_image, 'streamit-extensions'); ?>>
			<label for="<?php echo esc_html($this->get_field_id('title', 'streamit-extensions')); ?>"><?php echo esc_html__('Image', 'streamit-extensions'); ?></label></br />
		</p>
		<?php
	}

	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$instance['show_date'] = isset($new_instance['show_date']) ? (bool) $new_instance['show_date'] : false;
		$instance['iq-contact'] = $new_instance['iq-contact'];
		return $instance;
	}
}