<?php

if (!is_plugin_active('woocommerce/woocommerce.php')) return false;

if (!function_exists('iqonic_get_all_taxonomies')) {
    function iqonic_get_all_taxonomies($taxo = '', $return_by = 'slug')
    {
        if (empty($taxo)) {
            return;
        }

        $array = array();

        $args = array(
            'taxonomy'      => $taxo,
            'show_count'    => 0,
            'pad_counts'    => 0,
            'hierarchical'  => 1,
            'hide_empty'    => true,
        );

        $wp_object = get_categories($args);

        if (!empty($wp_object)) {
            foreach ($wp_object as $val) {
                $array[$val->$return_by] = $val->name;
            }
        }

        return $array;
    }
}

function streamit_pmpro_woo_product()
{
    $args = array(
        'post_type' => 'product',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'meta_query'         => array(
            array(
                'key'     => '_membership_product_level',
                'value'   => '0',
                'compare' => '!='
            ),
        ),
    );
    $wp_query = new \WP_Query($args);

    if ($wp_query->have_posts()) {
        while ($wp_query->have_posts()) {
            $wp_query->the_post();

            $array[get_the_ID()] = get_the_title();
        }
    }
    wp_reset_postdata();

    return $array;
}

// Wooocmerce add to cart popup
add_action('wp_ajax_streamit_ajax_add_to_cart', 'streamit_ajax_add_to_cart');
add_action('wp_ajax_nopriv_streamit_ajax_add_to_cart', 'streamit_ajax_add_to_cart');
function streamit_ajax_add_to_cart()
{
    global $woocommerce;
    $product_id  = $_POST['product_id'];
    $woocommerce->cart->add_to_cart($product_id);
    die;
}

//you have to change according to above mini cart shortcode function.
add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start(); ?>

    <a href="#" class="dropdown-back" data-toggle="dropdown">
        <i class="fas fa-shopping-cart"></i>
        <div class="basket-item-count" style="display: inline;">
            <span class="cart-items-count count">
                <?php echo WC()->cart->get_cart_contents_count(); ?>
            </span>
        </div>
    </a>
<?php $fragments['a.dropdown-back'] = ob_get_clean();
    return $fragments;
});

add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start(); ?>

    <div class="dropdown-menu-mini-cart">
        <div class="widget_shopping_cart_content">
            <?php woocommerce_mini_cart(); ?>
        </div>
    </div>

<?php $fragments['ul.dropdown-menu'] = ob_get_clean();
    return $fragments;
});

/* woocommerce register shortcode */
add_shortcode('iqonic-signup-form', 'iqonic_woocommerce_registration');
function iqonic_woocommerce_registration()
{
    if (is_admin()) return;
    if (is_user_logged_in()) return;
    ob_start();
    do_action('woocommerce_before_customer_login_form'); ?>

    <form id="register-form" method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action('woocommerce_register_form_tag'); ?>>
        <?php do_action('woocommerce_register_form_start'); ?>

        <?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>

            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" placeholder="<?php echo esc_attr('Enter Your Username *', 'streamit-extensions'); ?>" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" />
            </p>

        <?php endif; ?>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" placeholder="<?php echo esc_attr('Your email id *', 'streamit-extensions'); ?>" value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>" />
        </p>

        <?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>

            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                <input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" placeholder="<?php echo esc_attr('Enter Your Password *', 'streamit-extensions'); ?>" />
            </p>

        <?php endif; ?>

        <?php if (wc_get_page_id('terms') > 0) {
        ?>
            <div class="form-row terms wc-terms-and-conditions streamit-check">
                <label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
                    <input type="checkbox" required class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" name="terms" <?php checked(apply_filters('woocommerce_terms_is_checked_default', isset($_POST['terms'])), true); ?> id="terms" /> <span class="text-check"><?php printf(__('By creating an account, you agree to the <a href="%s" target="_blank" class="woocommerce-terms-and-conditions-link">Terms and Conditions</a>', 'streamit-extensions'), esc_url(wc_get_page_permalink('terms'))); ?></span> <span class="required">*</span><span class="checkmark"></span>
                </label>
                <input type="hidden" name="terms-field" value="1" />
            </div>
        <?php }  ?>

        <?php do_action('woocommerce_register_form'); ?>

        <p class="woocommerce-FormRow form-row sign-up-btn">
            <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
            <!-- register button  -->
            <button type="submit" class="streamit-box-shadow streamit-btn woocommerce-Button" name="register" value="<?php esc_attr_e('Register', 'streamit-extensions'); ?>">
                <span class="streamit-btn-line-holder">
                    <span class="streamit-btn-line-hidden"></span>
                    <span class="streamit-btn-text"><?php esc_html_e('Register', 'streamit-extensions'); ?></span>
                    <span class="streamit-btn-line"></span>
                    <i class="fas fa-chevron-right"></i>
                </span>
            </button>
        </p>

        <?php do_action('woocommerce_register_form_end'); ?>
    </form>
<?php
    return ob_get_clean();
}

/* woocommerce login shortcode */
add_shortcode('iqonic-login-form', 'iqonic_woocommerce_login_form');
function iqonic_woocommerce_login_form($attr)
{
    if (is_admin()) return;
    if (is_user_logged_in()) return;
    ob_start();
    $args = shortcode_atts(array(
        'btn_text_string' => '',
        'button_text' => 'Sign Up',
        'url' => '#',

    ), $attr); ?>
    <form class="woocommerce-form woocommerce-form-login login" method="post">

        <?php do_action('woocommerce_login_form_start'); ?>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" placeholder="<?php echo esc_attr('Enter Username or Email Address*', 'streamit-extensions'); ?>" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" />
        </p>
        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <input class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php echo esc_attr('Enter Password*', 'streamit-extensions'); ?>" type="password" name="password" id="password" autocomplete="current-password" />
        </p>

        <?php do_action('woocommerce_login_form'); ?>

        <div class="login-inner">
            <div class="streamit-check">
                <label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
                    <input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /><span class="checkmark"></span>
                    <span class="text-check"><?php esc_html_e('Remember me', 'streamit-extensions'); ?></span>
                </label>
            </div>
            <p class="woocommerce-LostPassword lost_password">
                <a href="<?php echo esc_url(wp_lostpassword_url()); ?>"><?php esc_html_e('Forgot Password?', 'streamit-extensions'); ?></a>
            </p>
        </div>

        <p class="form-row form-submit-btn">
            <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
            <!-- login button -->
            <button type="submit" class="streamit-box-shadow streamit-btn woocommerce-Button" name="login" value="<?php esc_attr_e('Log in', 'streamit-extensions'); ?>">
                <span class="streamit-btn-line-holder">
                    <span class="streamit-btn-line-hidden"></span>
                    <span class="streamit-btn-text"><?php esc_html_e('Log in', 'streamit-extensions'); ?></span>
                    <span class="streamit-btn-line"></span>
                    <i class="fas fa-chevron-right"></i>
                </span>
            </button>
        </p>

        <div class="sign-link d-flex align-items-center">
            <p class="my-0"><?php echo esc_html($args['btn_text_string']); ?></p>
            <h5 class="sign_up_text mb-0 ml-2"><a href="<?php echo esc_url($args['url']); ?>"><?php echo esc_html($args['button_text']);  ?></a></h5>
        </div>

        <?php do_action('woocommerce_login_form_end'); ?>

    </form>
<?php
    return ob_get_clean();
}

add_action('wp_ajax_loadmore_product_widget', 'streamit_loadmore_loadmore_product_widget_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_product_widget', 'streamit_loadmore_loadmore_product_widget_ajax_handler');

if (!function_exists('streamit_loadmore_loadmore_product_widget_ajax_handler')) {
    function streamit_loadmore_loadmore_product_widget_ajax_handler()
    {
        $args = isset($_POST['query']) ? (array) json_decode(str_replace("\\", "", $_POST['query'])) : false;
        $args['paged'] = isset($_POST['current_page']) ? (int) $_POST['current_page'] + 1 : 1;

        $wp_query = new WP_Query($args);
        if ($wp_query->have_posts()) {
            ob_start();
            while ($wp_query->have_posts()) {
                $wp_query->the_post();
                locate_template('/template-parts/wocommerce/entry.php', true, false, $args = array('id' => get_the_ID()));
            }
            $data = ob_get_clean();
            wp_send_json_success($data, 200);
            wp_reset_postdata();
        } else {
            wp_send_json_error("No Found", 404);
        }

        die;
    }
}

add_action('wp_ajax_qty_cart', 'ajax_qty_cart');
add_action('wp_ajax_nopriv_qty_cart', 'ajax_qty_cart');

function ajax_qty_cart()
{
    // Set item key as the hash found in input.qty's name
    $cart_item_key = $_POST['hash'];

    // Get the array of values owned by the product we're updating
    $threeball_product_values = WC()->cart->get_cart_item($cart_item_key);

    // Get the quantity of the item in the cart
    $threeball_product_quantity = apply_filters('woocommerce_stock_amount_cart_item', apply_filters('woocommerce_stock_amount', preg_replace("/[^0-9\.]/", '', filter_var($_POST['quantity'], FILTER_SANITIZE_NUMBER_INT))), $cart_item_key);

    // Update cart validation
    $passed_validation = apply_filters('woocommerce_update_cart_validation', true, $cart_item_key, $threeball_product_values, $threeball_product_quantity);

    // Update the quantity of the item in the cart
    if ($passed_validation) {
        WC()->cart->set_quantity($cart_item_key, $threeball_product_quantity, true);

        wp_send_json_success(array('quantity' => WC()->cart->get_cart_contents_count()));
    }

    // Refresh the page
    wp_send_json_error();
}
