<?php

function get_iqonic_config()
{
    return $GLOBALS['iqonic_config']['Elements'];
}

function get_lazy_load_image()
{
    return apply_filters("streamit_lazy_load_image_url", STREAMIT_EXTENSION_PLUGIN_URL . "includes/Elementor/assets/img/placeholder_genre.jpg");
}

function get_cards_lazy_load_image()
{
    return STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/dummy-min.png';
}

function streamit_premium_bage_svg()
{
    return apply_filters("streamit_premium_badge_image_url", STREAMIT_EXTENSION_PLUGIN_URL . "includes/Elementor/assets/img/premium.svg");
}

function streamit_get_portrait_image($post_id)
{
    $vertical_image_id = get_post_meta($post_id, '_portrait_thumbmail', true);
    if (!empty($vertical_image_id)) {
        return wp_get_attachment_image_src($vertical_image_id, "streamit-portrait-image")[0];
    } else {
        if (has_post_thumbnail($post_id))
            return wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "streamit-portrait-image");

        return STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/dummy-min.png';
    }
}

if (!function_exists('streamit_get_seasons_count')) {
    function streamit_get_seasons_count($meta)
    {
        $season_data = unserialize($meta['_seasons'][0]);
        if (is_array($season_data)) {
            $count = count($season_data);
            return $count . _n(" Season", " Seasons", $count, SE_TEXT_DOMAIN);
        } else {
            return esc_html__("Arriving soon", SE_TEXT_DOMAIN);
        }
    }
}

if (!function_exists('streamit_get_casts_list')) {
    function streamit_get_casts_list($meta)
    {
        $cast_list = '';
        $casts = unserialize($meta['_cast'][0]);

        if (is_array($casts)) {
            foreach ($casts as $data) {
                $cast_obj = get_post($data['id']);
                if (get_post_type($cast_obj) !== 'person') {
                    continue;
                }
                $cast_list .= '<a href="' . get_the_permalink($cast_obj) . '"><span class="text-body">' . $cast_obj->post_title . '</span></a>, ';
            }
            $cast_list = rtrim($cast_list, ", ");
        }
        return $cast_list;
    }
}

if (!function_exists('streamit_get_casts')) {
    function streamit_get_casts($meta)
    {
        global $streamit_options;

        $cast_list = streamit_get_casts_list($meta);
        if (!empty($cast_list)) {
            return '
            <div class="trending-list m-0">
                <div class="text-primary title starring m-0 d-flex">' .
                esc_html($streamit_options['streamit_starring_title']) . ': 
                <span class="text-body"> ' .
                $cast_list . '
                    </span>
                </div>
            </div>';
        }
        return '';
    }
}

if (!function_exists('streamit_get_genres_list')) {
    function streamit_get_genres_list($genres)
    {
        $genre_list = '';
        if (!empty($genres)) {
            foreach ($genres as $val) {
                if ($val->parent == 0) {
                    $genre_list .= '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>, ';
                }
            }
            $genre_list = rtrim($genre_list, ", ");
        }
        return $genre_list;
    }
}

if (!function_exists('streamit_get_genres')) {
    function streamit_get_genres($genres)
    {
        global $streamit_options;

        $genre_list = streamit_get_genres_list($genres);
        if (!empty($genre_list)) {
            return '
            <div class="text-primary title genres font-normal">' .
                esc_html($streamit_options['streamit_genres_title']) . ': 
                <span class="text-body"> ' .
                $genre_list . '
                </span>
            </div>';
        }
        return '';
    }
}

if (!function_exists('streamit_get_tags')) {
    function streamit_get_tags($tags)
    {
        $tag = '';
        if (!empty($tags)) {
            $tag = '<ul class="p-0 mb-0 list-inline d-flex flex-wrap align-items-center movie-content movie-space-action">';
            foreach ($tags as $val) {
                $tag .= '
                <li class="text-primary">
                    <a href="' . get_term_link($val) . '">
                        <span>' . esc_html($val->name) . '</span>
                    </a>
                </li>';
            }
            $tag .= '</ul>';
        }
        return $tag;
    }
}

if (!function_exists('streamit_popular_custom_query')) {
    function streamit_popular_custom_query($post_type, $limit = '', $offset = '')
    {
        global $wpdb, $total_pages;

        $posts_table        = $wpdb->prefix . 'posts';
        $postmeta_table     = $wpdb->prefix . 'postmeta';
        $ulikemeta_table    = $wpdb->prefix . 'ulike_meta';

        $sql = "SELECT post_id, wp_postmeta.meta_key, wp_postmeta.meta_value, wp_ulike_meta.meta_key, wp_ulike_meta.meta_value, post_type, post_title
		FROM $postmeta_table
		INNER JOIN $ulikemeta_table on $postmeta_table.post_id = $ulikemeta_table.item_id
		LEFT JOIN $posts_table on wp_postmeta.post_id = $posts_table.ID
		WHERE $postmeta_table.meta_key = 'post_views_count' AND $ulikemeta_table.meta_key = 'count_distinct_like'
		AND $posts_table.post_type = '$post_type'
		GROUP by post_id, $postmeta_table.meta_value, $ulikemeta_table.meta_value
		ORDER BY CAST($ulikemeta_table.meta_value AS UNSIGNED ) DESC, CAST($postmeta_table.meta_value AS UNSIGNED ) DESC";

        if (isset($limit) && !empty($limit)) {
            $results        = $wpdb->get_results($sql);
            $total_posts    = $wpdb->get_var("SELECT FOUND_ROWS()");
            $total_pages    = $total_posts / $limit;

            $sql .= " LIMIT $limit";
        }

        if (isset($offset) && !empty($offset)) {
            $sql .= " OFFSET $offset";
        }

        $results = $wpdb->get_results($sql);

        return array('results' => $results, 'total_pages' => $total_pages);
    }
}

if (!function_exists('streamit_get_numbers_pagination')) {
    function streamit_get_numbers_pagination($total_pages)
    {
        if ($total_pages > 1) {
            $big = 999999999;
            $pagination_args = array(
                'base'          => str_replace($big, '%#%', get_pagenum_link($big)),
                'format'        => '?paged=%#%',
                'current'       => max(1, get_query_var('paged')),
                'total'         => $total_pages,
                'prev_next'     => True,
                'prev_text'     => '<i class="fas fa-chevron-left"></i>',
                'next_text'     => '<i class="fas fa-chevron-right"></i>',
                'type'          => 'list',
                'add_args'      => false,
                'add_fragment'  => ''
            );

            $paginate_links = paginate_links($pagination_args);
            if ($paginate_links) {
                echo '<div class="col-lg-12 col-md-12 col-sm-12">
                     <div class="pagination justify-content-center">
                                 <nav aria-label="Page navigation">';
                printf(esc_html__('%s', 'streamit-extensions'), $paginate_links);
                echo '</nav>
                         </div>
                     </div>';
            }
        }
    }
}

function streamit_get_pagination_args($args)
{
    foreach ($args as $key => $value) {
        if (is_array($value)) {
            echo '<input class="' . esc_attr($key) . '" name="' . esc_attr($key) . '" value="' . str_replace("\"", "'", json_encode($value)) . '" type="hidden">';
            continue;
        }

        echo '<input class="' . esc_attr($key) . '" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" type="hidden">';
    }
}

function streamit_get_cards_meta_queries($post_type, $settings, $paged = NULL)
{
    $args = $tax_query = $taxargs = array();
    $post_filter = $settings['post_view_type'];

    //When Ajax Call, set the paged variable of the ajax request
    if (!wp_doing_ajax()) {
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    }

    if ($post_type == "movie") {
        $selected_type      = 'iq_select_movies';

        $genre_taxanomy     = 'movie_genre';
        $genre_name         = 'iq_movie_genre';
        $tag_taxanomy       = 'movie_tag';
        $tag_name           = 'iq_movie_tag';
    } elseif ($post_type == "tv_show") {
        $selected_type = 'iq_select_tvshows';

        $genre_taxanomy     = 'tv_show_genre';
        $genre_name         = 'iq_tvshow_genre';
        $tag_taxanomy       = 'tv_show_tag';
        $tag_name           = 'iq_tvshow_tag';
    } elseif ($post_type == "video") {
        $selected_type      = 'iq_select_videos';

        $genre_taxanomy     = 'video_cat';
        $genre_name         = 'iq_videos_genre';
        $tag_taxanomy       = 'video_tag';
        $tag_name           = 'iq_videos_tag';
    }

    $is_empty = empty($settings[$selected_type]) ? true : false;

    $args = array(
        'post_type'         => $post_type,
        'post_status'       => 'publish',
        'paged'             => $paged,
        'posts_per_page'    => $settings['posts_per_page']['size'],
        "suppress_filters"  => true,
        'fields'            => 'ids'
    );

    if (!empty($settings[$genre_name])) {
        $tax_query['taxonomy']  = $genre_taxanomy;
        $tax_query['field']     = 'slug';
        $tax_query['terms']     = $settings[$genre_name];
        $tax_query['operator']  = 'IN';
        array_push($taxargs, $tax_query);
    }

    if (!empty($settings[$tag_name])) {
        $tax_query['field']     = 'slug';
        $tax_query['taxonomy']  = $tag_taxanomy;
        $tax_query['terms']     = $settings[$tag_name];
        $tax_query['operator']  = 'IN';
        array_push($taxargs, $tax_query);
    }

    if (!$is_empty) {
        $args['post_name__in'] = $settings[$selected_type];
    }

    if ($is_empty && $post_filter === 'most_liked') {
        $args['post__in']   = iq_get_most_liked($post_type, array(), 'id');
        $args['orderby']    = 'post__in';
    }

    if ($is_empty && $post_filter === 'most_viewd') {
        $args['meta_key']   = 'post_views_count';
        $args['orderby']    = 'meta_value_num';
        $args['order']      = 'DESC';
    }

    if ($is_empty && $post_filter === 'rand') {
        $args['orderby']    = 'rand';
    }

    if ($post_filter === 'latest') {
        $args['orderby']    = 'publish_date';
        $args['order']      = 'DESC';
    }

    if ($post_filter === 'none' && !empty($settings['order'])) {
        $args['order']  = $settings['order'];
    }

    if ($post_filter === 'upcoming' && !empty($settings['order'])) {
        $args['order'] = $settings['order'];
        $args['meta_query'] = array(
            array(
                'key'     => 'name_upcoming',
                'value'   => '"yes"',
                'compare' => 'LIKE'
            )
        );
    } else {
        $args['meta_query'] = array(
            array(
                'key'     => 'name_upcoming',
                'value'   => '',
                'compare' => '=='
            )
        );
    }

    if ($post_filter === 'alphabetic' && !empty($settings['order'])) {
        $args['orderby']    = 'title';
        $args['order']      = $settings['order'];
    }

    if (!empty($taxargs)) {
        $args['tax_query']              = $taxargs;
        $args['tax_query']['relation']  = 'OR';
    }

    return $args;
}

function streamit_get_shortcode_title($slider_title, $title_tag, $view_all)
{ ?>
    <div class="iq-main-header d-flex align-items-center justify-content-between">
        <?php if (!empty($slider_title)) : ?>
            <<?php echo esc_attr($title_tag); ?> class="main-title">
                <?php echo esc_html($slider_title); ?>
            </<?php echo esc_attr($title_tag); ?>>

        <?php
            if ($view_all && !empty($view_all)) {
                echo $view_all;
            }
        endif; ?>
    </div>
<?php
}

if (!function_exists('iqonic_by_blog_cat')) {
    function iqonic_by_blog_cat()
    {
        $taxonomy = 'category';
        $iq_blog_cat = array();
        $terms = get_terms($taxonomy);

        foreach ($terms as $term) {
            $iq_blog_cat[$term->slug] = $term->name;
        }
        return $iq_blog_cat;
    }
}

if (!function_exists('streamit_pmp_subscription_plan_list')) {
    function streamit_pmp_subscription_plan_list()
    {
        $pmp_levels = array();
        if (function_exists('pmpro_sort_levels_by_order')) {
            $pmpro_levels = pmpro_sort_levels_by_order(pmpro_getAllLevels(false, true));

            foreach ($pmpro_levels as $level) {
                $pmp_levels[$level->id] = $level->name;
            }
        }
        return $pmp_levels;
    }
}

if (!function_exists('streamit_pmp_discount_code_list')) {
    function streamit_pmp_discount_code_list()
    {
        global $wpdb;
        $discount_code = array();

        if (isset($wpdb->pmpro_discount_codes)) {
            $pmp_discount_code = $wpdb->get_results("SELECT * FROM $wpdb->pmpro_discount_codes");
            if (!empty($pmp_discount_code)) {
                foreach ($pmp_discount_code as $discount_codes) {
                    $discount_code[$discount_codes->code] = $discount_codes->code;
                }
            }
        }

        return $discount_code;
    }
}

if (!function_exists('iqonic_blog_time_link')) {
    function iqonic_blog_time_link($post_id = NULL)
    {
        if ($post_id == NULL)
            $post_id = get_the_ID();

        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
        $time_string = sprintf(
            $time_string,
            get_the_date(DATE_W3C, $post_id),
            get_the_date('', $post_id),
            get_the_modified_date(DATE_W3C, $post_id),
            get_the_modified_date('', $post_id)
        );

        $archive_year  = get_the_time('Y', $post_id);
        $archive_month = get_the_time('m', $post_id);
        $archive_day   = get_the_time('d', $post_id);

        return sprintf(
            __('<span class="screen-reader-text">Posted on</span> %s', SE_TEXT_DOMAIN),
            '<a href="' . esc_url(get_day_link($archive_year, $archive_month, $archive_day)) . '" rel="bookmark">' . $time_string . '</a>'
        );
    }
}

if (!function_exists('streamit_get_post_format_dynamic')) {
    function streamit_get_post_format_dynamic()
    {
        global $blog_post_format;

        if (isset($blog_post_format) && !empty($blog_post_format))
            return $blog_post_format;

        if (current_theme_supports('post-formats')) {
            $get_post_formats_slug = get_post_format_slugs();

            foreach ($get_post_formats_slug as $name => $slug) {
                $post_format_list[$name] = $slug;
            }

            $blog_post_format = $post_format_list;

            return $post_format_list;
        }
    }
}

if (!function_exists('iqonic_get_taxonomies')) {
    function iqonic_get_taxonomies($taxo = '', $return_by = 'slug')
    {
        if (empty($taxo)) return;

        $array = array();

        $args = array(
            'taxonomy'      => $taxo,
            'show_count'    => 0,
            'pad_counts'    => 0,
            'hierarchical'  => 1,
            'hide_empty'    => true,
            'parent'        => 0
        );

        $wp_object = get_categories($args);

        if (!empty($wp_object)) {
            foreach ($wp_object as $val) {
                $array[$val->$return_by] = $val->name;
            }
        }

        return $array;
    }
}

// get custom taxonomy
function iq_get_custom_taxonomy($taxo)
{
    global $iq_get_custom_taxonomy;

    if (empty($taxo)) return;

    if (isset($iq_get_custom_taxonomy[$taxo]) && !empty($iq_get_custom_taxonomy[$taxo])) {
        return $iq_get_custom_taxonomy[$taxo];
    }

    $array = array();

    $args = array(
        'taxonomy' => $taxo,
        'show_count' => 0,
        'pad_counts' => 0,
        'hierarchical' => 1,
        'hide_empty' => false,
    );
    $wp_object = get_categories($args);

    if (!empty($wp_object)) {
        foreach ($wp_object as $val) {
            $parent_category_name = '';

            if (isset($val->category_parent) && $val->category_parent != "0") {
                $term = get_term($val->category_parent);
                $parent_category_name = $term->name;
            }

            if (!empty($parent_category_name)) {
                $array[$val->slug] = $val->name . ' - ' .  $parent_category_name;
            } else {
                $array[$val->slug] = $val->name;
            }
        }
    }

    $iq_get_custom_taxonomy[$taxo] = $array;
    return $array;
}

function iq_custom_post_data($post_type = '', $post_return_key = true, $show_item_badges = false)
{
    global $iq_get_CPT;

    $iqonic_blog_list = [];

    if (empty($post_type)) return $iqonic_blog_list;

    //return if posts cached data already set
    if (is_array($post_type)) {
        foreach ($post_type as $key => $CPT) {
            if (isset($iq_get_CPT[$CPT][$post_return_key]) && !empty($iq_get_CPT[$CPT][$post_return_key])) {
                return $iq_get_CPT[$CPT][$post_return_key];
            }
        }
    } else {
        if (isset($iq_get_CPT[$post_type][$post_return_key]) && !empty($iq_get_CPT[$post_type][$post_return_key])) {
            return $iq_get_CPT[$post_type][$post_return_key];
        }
    }

    $args = array(
        'post_type'         => $post_type,
        'post_status'       => 'publish',
        'posts_per_page'    => -1,
        'suppress_filters'  => true,
        'fields'            => 'ids'
    );

    $wp_query = new WP_Query($args);

    if ($wp_query->have_posts()) {
        $post_ids = $wp_query->posts; // Get an array of post IDs

        if ($post_return_key) {
            foreach ($post_ids as $post_id) {
                $slug       = get_post_field('post_name', $post_id);

                $upcoming   = get_post_meta($post_id, 'name_upcoming', true);
                $upcoming   = !empty($upcoming) ? esc_html__(" - Upcoming", 'streamit-extensions') : '';

                if (get_post_parent($post_id))
                    $slug = get_page_uri($post_id);

                $show_item_badges           = $show_item_badges ? ' - ' . get_post_type($post_id) : '';
                $iqonic_blog_list[$slug]    = apply_filters("iq_custom_post_data_title", get_the_title($post_id) . $show_item_badges, $post_id) . $upcoming;
            }
        } else {
            foreach ($post_ids as $post_id) {
                $upcoming   = get_post_meta($post_id, 'name_upcoming', true);
                $upcoming   = !empty($upcoming) ? esc_html__(" - Upcoming", 'streamit-extensions') : '';

                $show_item_badges           = $show_item_badges ? ' - ' . get_post_type($post_id) : '';
                $iqonic_blog_list[$post_id] = apply_filters("iq_custom_post_data_title", get_the_title($post_id) . $show_item_badges, $post_id) . $upcoming;
            }
        }
    }
    wp_reset_postdata();

    //caches post data
    if (is_array($post_type)) {
        foreach ($post_type as $CPT) {
            if (!isset($iq_get_CPT[$CPT]) && empty($iq_get_CPT[$CPT])) {
                $iq_get_CPT[$CPT][$post_return_key] = $iqonic_blog_list;
            }
        }
    } else {
        $iq_get_CPT[$post_type][$post_return_key] = $iqonic_blog_list;
    }

    return $iqonic_blog_list;
}

add_filter("iq_custom_post_data_title", "add_wpml_language_in", 10, 2);
function add_wpml_language_in($title, $post_id)
{
    if (is_plugin_active('sitepress-multilingual-cms/sitepress.php'))
        $title .= " - " . apply_filters('wpml_post_language_details', NULL, $post_id)['display_name'];
    return $title;
}

if (!function_exists('iq_custom_post_data_archive_link')) {
    function iq_custom_post_data_archive_link($include_archive_page = array('movie', 'tv_show', 'video', 'person', 'post'))
    {
        $link = array();
        // if (!isset($_REQUEST['action'])) return $link;

        foreach ($include_archive_page as $post_type) {
            $link[get_post_type_archive_link($post_type)] = $post_type;
        }
        return $link;
    }
}

function iq_get_most_liked($post_type = '')
{
    $liked = wp_ulike_get_most_liked_posts(10, array($post_type), 'post', 'all', 'like');

    if ($liked) {
        foreach ($liked as $post) {
            $most_liked_ids[] = $post->ID;
        }
        return $most_liked_ids;
    }
}

//user profile picture update
if (!function_exists('iq_get_attachment_id')) {
    function iq_get_attachment_id($img)
    {
        $url = '';
        $profile_image = $img;
        $type = $profile_image['type'];
        $userdata = wp_get_current_user();

        $extension = pathinfo($profile_image['name'], PATHINFO_EXTENSION);

        // Upload dir.
        $upload_dir = wp_upload_dir();
        $upload_path = str_replace('/', DIRECTORY_SEPARATOR, $upload_dir['path']) . DIRECTORY_SEPARATOR;

        // Save the image in the uploads directory.
        error_log($upload_path);

        $upload_file = move_uploaded_file($profile_image["tmp_name"], $upload_path . $profile_image["name"]);

        $attachment = array(
            'post_mime_type' => $extension,
            'post_title' => preg_replace('/\.[^.]+$/', '', $profile_image["name"]),
            'post_content' => '',
            'post_status' => 'inherit',
            'guid' => $upload_dir['url'] . '/' . $profile_image["name"]
        );

        $attach_id = wp_insert_attachment($attachment, $upload_dir['path'] . '/' . $profile_image["name"]);

        // Regenerate Thumbnail
        global $wpdb;
        $images = $wpdb->get_results("SELECT ID FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type LIKE 'image/%' AND ID ='$attach_id'");

        foreach ($images as $image) {
            $id = $image->ID;
            $fullsizepath = get_attached_file($id);

            if (false === $fullsizepath || !file_exists($fullsizepath))
                return;
        }
        $url = wp_get_attachment_url($attach_id);

        $update = update_user_meta($userdata->ID, 'streamit_profile_image', $url);

        if (!is_wp_error($update)) {
            // Update the user's avatar field
            $user_data = array(
                'ID' => $userdata->ID,
                'avatar' => $url,
            );

            // Update the user's data
            wp_update_user($user_data);

            $img = get_user_meta($userdata->ID, 'streamit_profile_image');
            $data['profile_image'] = $img[0];
        }
        return $url;
    }
}

add_filter('views_edit-pricing', 'my_filter');

function my_filter($views)
{
    $views['import'] = '<form method="post" action="' . admin_url('edit.php?post_type=pricing') . '">
                            <button style="color: rgb(0, 113, 161);
                            border:1px solid rgb(0, 113, 161);
                            cursor:pointer;
                            background: rgb(243, 245, 246);
                            vertical-align: top;border-radius:5px;" name="import_pms_plans" value="Import">Import PMS Plans</button> 
                            <label style="background:white;color:green;cursor: default;">Click on import to get all subscriptions from Paid Member Subscription plugin</label>
                        </form>';
    return $views;
}

// imdb update
if (!get_option('is_streamit_imdb_updated') && get_option('is_streamit_imdb_updated') !== "yes") {
    if (!function_exists("streamit_update_imdb")) {

        function streamit_update_imdb()
        {
            $args = array(
                'post_type' => array('movie', 'tv_show', 'episode'),
                'posts_per_page' => -1,
            );

            $wp_query = new \WP_Query($args);

            if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();

                    $old_imdb_rating = get_post_meta(get_the_ID(), '_imdb_id', true);
                    if (isset($old_imdb_rating) && is_numeric($old_imdb_rating)) {
                        update_post_meta(get_the_ID(), 'name_custom_imdb_rating', $old_imdb_rating);
                    } else {
                        update_post_meta(get_the_ID(), 'name_custom_imdb_rating', 1);
                    }
                }
                update_option('is_streamit_imdb_updated', 'yes');
            }
        }
        add_action('admin_init', 'streamit_update_imdb');
    }
}

// for regenerate css,js remove
function remove_all_minified_files()
{
    $upload_dir = wp_get_upload_dir()['basedir'];
    $css_dir    = $upload_dir . "/streamit/css/";
    $js_dir     = $upload_dir . "/streamit/js/";

    if (!class_exists('WP_Filesystem_Direct')) {
        require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
        require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
    }

    $rm = new WP_Filesystem_Direct([]);

    if (isset($_GET['post_id']) && !empty($_GET['post_id']) && isset($_GET['mode']) && !empty($_GET['mode'])) {
        $mode    = $_GET['mode'];
        $page_id = $_GET['post_id'];

        if ($mode === "current") {
            $css_filename = $css_dir . 'iqonic-post-' . $page_id . '.min.css';
            $js_filename  = $js_dir . 'iqonic-post-' . $page_id . '.min.js';

            if (file_exists($css_filename)) $rm->delete($css_filename, true, 'd');
            if (file_exists($js_filename))  $rm->delete($js_filename, true, 'd');

            update_post_meta($page_id, "iqonic_page_dependent_scripts_" . $page_id, '');
        } elseif ($mode === "all") {
            if (file_exists($css_dir)) $rm->delete($css_dir, true, 'd');
            if (file_exists($js_dir))  $rm->delete($js_dir, true, 'd');

            $args = array(
                'post_type'         => array("post", "page", "movie", "tv_show", "video", "person", "episode"),
                'post_status'       => array("publish"),
                "posts_per_page"    => -1,
                'fields'            => 'ids',
            );

            $wp_query = new WP_Query($args);

            if ($wp_query->have_posts()) {
                $post_ids = $wp_query->posts;
                foreach ($post_ids as $loop_page_id) {
                    update_post_meta($loop_page_id, "iqonic_page_dependent_scripts_" . $loop_page_id, '');
                }
            }
            wp_reset_postdata();
        }

        $redirect_link = get_the_permalink($page_id);
        wp_redirect($redirect_link);
        exit;
    }
}

add_action('elementor/editor/after_save', 'streamit_save_data');

function streamit_save_data($post_id)
{
    $upload_dir = wp_get_upload_dir()['basedir'] . "/streamit";
    $css = $upload_dir . "/css/iqonic-post-$post_id.min.css";
    $js = $upload_dir . "/js/iqonic-post-$post_id.min.js";

    if (file_exists($css))
        unlink($css);
    if (file_exists($js))
        unlink($js);
}

if (!function_exists('iqonic_import_pms_plans')) {
    function iqonic_import_pms_plans()
    {
        global $wpdb;

        if (isset($_POST['import_pms_plans']) && $_POST['import_pms_plans'] === 'Import') {
            $pms_args = array(
                'post_type' => 'pms-subscription',
                'post_status' => 'active',
                'posts_per_page' => -1
            );
            $pricing_args = array(
                'post_type' => 'pricing',
                'post_status' => 'publish',
                'posts_per_page' => -1,
                'meta_key' => 'name_paid_sub_id'
            );
            $pms_subscription = new \WP_Query($pms_args);
            $pricing_query = new \WP_Query($pricing_args);
            $existing_ids = [];
            if ($pricing_query->posts) {
                foreach ($pricing_query->posts as $key => $value) {
                    $existing_ids[] = get_post_meta($value->ID, 'name_paid_sub_id', true);
                }
            }
            if ($pms_subscription->posts) {
                foreach ($pms_subscription->posts as $key => $value) {
                    if (!in_array($value->ID, $existing_ids)) {
                        $id = $value->ID;

                        $price = get_post_meta($id, 'pms_subscription_plan_price', true);
                        $price = !empty($price) ? '$' . $price : '';

                        $duration = get_post_meta($id, 'pms_subscription_plan_duration', true);
                        $duration = !empty($duration) ? $duration : '';

                        $discount = get_post_meta($id, 'pms_discount_price', true);
                        $discount = !empty($discount) ? '$' . $discount : '';

                        $duration_unit = get_post_meta($id, 'pms_subscription_plan_duration_unit', true);
                        $duration_unit = !empty($duration_unit) ? $duration_unit : '';
                        $duration = $duration . ' ' . $duration_unit;

                        $title = $value->post_title;
                        $title = !empty($title) ? $title : '';

                        $post = array(
                            'post_title' => $title,
                            'post_status' => 'publish',
                            'post_type' => 'pricing',
                        );

                        if ($pricing_id = wp_insert_post($post)) {
                            update_post_meta($pricing_id, 'name_price', $price);
                            update_post_meta($pricing_id, 'name_paid_sub_id', $id);
                            update_post_meta($pricing_id, 'name_period', $duration);
                            update_post_meta($pricing_id, 'name_discount', $discount);
                            $page_redirect = get_option('pms_general_settings')['register_page'];
                            $page_redirect = !empty($page_redirect) ? $page_redirect : '';
                            update_post_meta($pricing_id, 'name_pricing_redirect_link', $page_redirect);
                        }
                    }
                }
            }
        }
    }

    add_action('admin_init', 'iqonic_import_pms_plans');
}
function get_opt_name()
{
    return 'streamit_options';
}

require_once 'content_importer_helpers.php';
