<?php

// streamit multiplatform data import

add_action('wp_ajax_streamit_ajax', 'streamit_route_handler');

function streamit_route_handler()
{
    // streamit route handler
    require_once(STREAMIT_EXTENSION_PLUGIN_PATH . 'feature/ClassStreamitRouteHelper.php');
    (new ClassStreamitRouteHelper)->request($_POST);
}

function streamit_admin_menu_add()
{
    $menu = add_menu_page(__('Streamit/Import'), 'Content Import', 'administrator', 'streamit-import', 'streamit_multiplatform_data_import', STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/stremit.png', 5);
    add_action('admin_print_styles-' . $menu, 'iqonic_admin_scripts');
}

add_action('admin_menu', 'streamit_admin_menu_add');

function iqonic_admin_scripts()
{
    wp_enqueue_style('iq-boostrap', STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/css/bootstrap.min.css', array(), '1.0.0', 'all');
    wp_enqueue_script('iq-boostrap', STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/js/bootstrap.min.js', ['jquery'], '1.0.0', true);
}

function streamit_multiplatform_data_import()
{
    $import_types = ['youtube', 'imdb', 'vimeo', 'omdb', 'tmdb'];

    $developer_key = [];

    foreach ($import_types as $key => $value) {

        $status = '';
        $key = '';

        $key = get_option('streamit_' . $value . '_auth');
        $status = get_option('streamit_' . $value . '_status');

        if ($key) {
            $developer_key[$value] = $key;
        } else {
            $developer_key[$value] = '';
        }
        if ($status) {
            $developer_key[$value . '_status'] = $status;
        } else {
            $developer_key[$value . '_status'] = '';
        }
    }

    wp_enqueue_style('streamit-import-style', STREAMIT_EXTENSION_PLUGIN_URL . 'feature/' . 'streamit-import-style.css', array(), '1.0.2');
    wp_enqueue_script('streamit-data-import', STREAMIT_EXTENSION_PLUGIN_URL . 'feature/' . 'streamit-data-import.js', array('jquery'), '1.0.2', false);
    wp_localize_script('streamit-data-import', 'streamit_localize', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('ajax_post'),
        'youtube' => $developer_key['youtube'],
        'vimeo' => $developer_key['vimeo'],
        'imdb' => $developer_key['imdb'],
        'omdb' => $developer_key['omdb'],
        'tmdb' => $developer_key['tmdb'],
    ));

    $default['loader_url'] = STREAMIT_EXTENSION_PLUGIN_URL . '/feature/assets/img/loader.gif';

    // streamit route handler
    require_once(STREAMIT_EXTENSION_PLUGIN_PATH . 'feature/ClassStreamitRouteHelper.php');

    (new ClassStreamitRouteHelper)->init();

    include(STREAMIT_EXTENSION_PLUGIN_PATH . 'feature/import-ui.php');
}
