<?php

//===========FOR SHORTCODE BLOG===========
add_action('wp_ajax_loadmore_blog_grid',        'streamit_blog_grid_loadmore_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_blog_grid', 'streamit_blog_grid_loadmore_ajax_handler');

if (!function_exists('streamit_blog_grid_loadmore_ajax_handler')) {
    function streamit_blog_grid_loadmore_ajax_handler()
    {
        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === "array") {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;

            $wp_query       = new \WP_Query($args);
            $post_ids       = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Blog/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//--------------------------CARDS WIDGET SECTION START--------------------------//

//===========FOR SHORTCODE MOVIE CARDS===========
add_action('wp_ajax_movie_cards',          'streamit_movie_cards_ajax_handler');
add_action('wp_ajax_nopriv_movie_cards',   'streamit_movie_cards_ajax_handler');

if (!function_exists('streamit_movie_cards_ajax_handler')) {
    function streamit_movie_cards_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;
            $wp_query       = new \WP_Query($args);
            $post_ids       = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE TV SHOW CARDS===========
add_action('wp_ajax_tvshow_cards',         'streamit_tvshow_cards_ajax_handler');
add_action('wp_ajax_nopriv_tvshow_cards',  'streamit_tvshow_cards_ajax_handler');

if (!function_exists('streamit_tvshow_cards_ajax_handler')) {
    function streamit_tvshow_cards_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;

            $wp_query           = new \WP_Query($args);
            $post_ids           = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE VIDEO CARDS===========
add_action('wp_ajax_video_cards',         'streamit_video_cards_ajax_handler');
add_action('wp_ajax_nopriv_video_cards',  'streamit_video_cards_ajax_handler');

if (!function_exists('streamit_video_cards_ajax_handler')) {
    function streamit_video_cards_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;

            $wp_query = new \WP_Query($args);
            $post_ids = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
                }
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE POPULAR===========
add_action('wp_ajax_popular_cards',          'streamit_popular_cards_ajax_handler');
add_action('wp_ajax_nopriv_popular_cards',   'streamit_popular_cards_ajax_handler');

if (!function_exists('streamit_popular_cards_ajax_handler')) {
    function streamit_popular_cards_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
        }

        if (gettype($settings) === 'array') {
            extract($settings);

            $paged          = $_POST['page'] + 1;
            $offset         = $limit * ($paged - 1);
            $query          = streamit_popular_custom_query($post_type, $limit, $offset);
            $result         = $query['results'];
            $total_pages    = $query['total_pages'];

            if ($result) :
                foreach ($result as $key => $item) {
                    $post_id = $item->post_id;
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//--------------------------CARDS WIDGET SECTION ENDS--------------------------//

//===========FOR SHORTCODE TOP TEN===========
add_action('wp_ajax_top_ten',           'streamit_top_ten_ajax_handler');
add_action('wp_ajax_nopriv_top_ten',    'streamit_top_ten_ajax_handler');

if (!function_exists('streamit_top_ten_ajax_handler')) {
    function streamit_top_ten_ajax_handler()
    {
        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === "array") {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;
            $count_numbers  = $_POST['count_numbers'];

            $wp_query = new \WP_Query($args);
            $post_ids = $wp_query->posts;

            if ($wp_query->have_posts()) {
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Top_Ten/template.php';
                }
                wp_reset_postdata();
            }
        }
        die;
    }
}

//--------------------------SLIDER WIDGET SECTION STARTS--------------------------//

//===========FOR SHORTCODE MOVIE SLIDER===========
add_action('wp_ajax_movie_slider',          'streamit_movie_slider_ajax_handler');
add_action('wp_ajax_nopriv_movie_slider',   'streamit_movie_slider_ajax_handler');

if (!function_exists('streamit_movie_slider_ajax_handler')) {
    function streamit_movie_slider_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;

            $wp_query = new WP_Query($args);
            $post_ids = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE TV SHOW SLIDER===========
add_action('wp_ajax_tvshow_slider',         'streamit_tvshow_slider_ajax_handler');
add_action('wp_ajax_nopriv_tvshow_slider',  'streamit_tvshow_slider_ajax_handler');

if (!function_exists('streamit_tvshow_slider_ajax_handler')) {

    function streamit_tvshow_slider_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array'  && gettype($args) === 'array') {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;

            $wp_query = new \WP_Query($args);
            $post_ids = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE VIDEO SLIDER===========
add_action('wp_ajax_video_slider',          'streamit_video_slider_ajax_handler');
add_action('wp_ajax_nopriv_video_slider',   'streamit_video_slider_ajax_handler');

if (!function_exists('streamit_video_slider_ajax_handler')) {
    function streamit_video_slider_ajax_handler()
    {
        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            $args['paged']  = $_POST['page'] + 1;

            extract($settings);

            $wp_query = new \WP_Query($args);
            $post_ids = $wp_query->posts;

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//--------------------------SLIDER WIDGET SECTION ENDS--------------------------//

//===========FOR SHORTCODE GENRES===========
add_action('wp_ajax_loadmore_genres', 'streamit_genres_loadmore_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_genres', 'streamit_genres_loadmore_ajax_handler');

if (!function_exists('streamit_genres_loadmore_ajax_handler')) {
    function streamit_genres_loadmore_ajax_handler()
    {
        if (!isset($_POST['settings'])) die;

        global $streamit_options;

        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $current_page       = $_POST['page'] + 1;
            $offset             = ($terms_per_page * $current_page) - $terms_per_page;
            $args['paged']      = $current_page;
            $args['offset']     = $offset;
            $terms              = get_terms($taxonomy, $args);

            if ($terms) {
                foreach ($terms as $term) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Genres/template.php';
                }
            }
        }
        die;
    }
}

//===========FOR SHORTCODE TAGS===========
add_action('wp_ajax_loadmore_tags', 'streamit_tags_loadmore_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_tags', 'streamit_tags_loadmore_ajax_handler');

if (!function_exists('streamit_tags_loadmore_ajax_handler')) {
    function streamit_tags_loadmore_ajax_handler()
    {
        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $current_page   = $_POST['page'] + 1;
            $offset         = ($terms_per_page * $current_page) - $terms_per_page;
            $args['number'] = $terms_per_page;
            $args['offset'] = $offset;

            $tags     = get_terms($taxonomy, $args);
            $target   = "target=" . $link_target . "";

            if ($tags) {
                foreach ($tags as $val) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Tags/template.php';
                }
            }
        }
        die;
    }
}

//===========FOR SHORTCODE PERSONS===========
add_action('wp_ajax_loadmore_person', 'streamit_person_loadmore_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_person', 'streamit_person_loadmore_ajax_handler');

if (!function_exists('streamit_person_loadmore_ajax_handler')) {
    function streamit_person_loadmore_ajax_handler()
    {
        if (gettype($_POST['settings']) === 'string') {
            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);
        }

        if (gettype($settings) === 'array' && gettype($args) === 'array') {
            extract($settings);

            $args['paged']  = $_POST['page'] + 1;

            $wp_query = new \WP_Query($args);
            $post_ids = $wp_query->posts;

            if ($wp_query->have_posts()) {
                foreach ($post_ids as $post_id) {
                    require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Persons/template.php';
                }
            }
            wp_reset_postdata();
        }
        die;
    }
}

//===========FOR VIEW ALL GRID===========
add_action('wp_ajax_loadmore_viewall',          'streamit_viewall_loadmore_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_viewall',   'streamit_viewall_loadmore_ajax_handler');

if (!function_exists('streamit_viewall_loadmore_ajax_handler')) {
    function streamit_viewall_loadmore_ajax_handler()
    {
        if (gettype($_POST['settings']) === 'string') {
            global $streamit_options;

            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);

            extract($settings);

            $args['paged']          = $_POST['page'] + 1;

            $wp_query               = new \WP_Query($args);
            $post_ids               = $wp_query->posts;
            $settings               = [
                'image_style'       => $image_style,
                'play_now_text'     => esc_html__("Play Now", SE_TEXT_DOMAIN),
            ];

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    $post_type = get_post_type($post_id);

                    if ($style == '2') {
                        if ("movie" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                            continue;
                        } else if ("tv_show" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
                            continue;
                        } else if ("video" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
                            continue;
                        }
                    } else {
                        if ("movie" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                            continue;
                        } else if ("tv_show" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
                            continue;
                        } else if ("video" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
                            continue;
                        }
                    }
                }
                wp_reset_postdata();
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE WATCHLIST===========
add_action('wp_ajax_loadmore_watchlist',        'streamit_watchlist_loadmore_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_watchlist', 'streamit_watchlist_loadmore_ajax_handler');

if (!function_exists('streamit_watchlist_loadmore_ajax_handler')) {
    function streamit_watchlist_loadmore_ajax_handler()
    {
        if (gettype($_POST['settings']) === 'string') {
            global $streamit_options;

            $settings   = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
            $args       = json_decode(str_replace("'", "\"", stripslashes($_POST['query_args'])), true);

            extract($settings);

            $args['paged']      = $_POST['page'] + 1;

            $user               = wp_get_current_user();
            $user_id            = $user->ID;
            $watchlist          = get_user_meta($user_id, '_user_watchlist', true);

            $args = array(
                'post_type'         => array('movie', 'tv_show', 'video'),
                'post_status'       => 'publish',
                'post__in'          => explode(',', $watchlist),
                'paged'             => $_POST['page'] + 1,
                'posts_per_page'    => $streamit_options['streamit_post_per_page'],
                'fields'            => 'ids'
            );

            $wp_query = new WP_Query($args);
            $post_ids = $wp_query->posts;
            $settings = [
                'image_style'   => $img_orientation,
                'play_now_text' => esc_html__("Play Now", SE_TEXT_DOMAIN),
            ];

            if ($wp_query->have_posts()) :
                foreach ($post_ids as $post_id) {
                    $post_type = get_post_type($post_id);

                    if ("cards" == $style) {
                        if ("movie" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                            continue;
                        } else if ("tv_show" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
                            continue;
                        } else if ("video" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
                            continue;
                        }
                    } else {
                        if ("movie" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                            continue;
                        } else if ("tv_show" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
                            continue;
                        } else if ("video" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
                            continue;
                        }
                    }
                }
                wp_reset_postdata();
            else :
                echo esc_html__("Please add some posts to your watchlist to view them", SE_TEXT_DOMAIN);
            endif;
        }
        die;
    }
}

//===========FOR SHORTCODE TVSHOW SEASON===========
add_action('wp_ajax_tvshow_seasons_data', 'tvshow_seasons_data_ajax_handler');
add_action('wp_ajax_nopriv_tvshow_seasons_data', 'tvshow_seasons_data_ajax_handler');

if (!function_exists('tvshow_seasons_data_ajax_handler')) {
    function tvshow_seasons_data_ajax_handler()
    {
        $tvshow_id = '';
        if (isset($_POST['tvshow_id']) && !empty($_POST['tvshow_id']))
            $tvshow_id = $_POST['tvshow_id'];
        else
            wp_die();

        $k = 1;
        $episode_card_btn_text = (isset($_POST['episode_card_text']) && !empty($_POST['episode_card_text'])) ? $_POST['episode_card_text'] : '';
        $season_ajax = $season_data = $episodes_data = array();
        $season_data = get_post_meta($tvshow_id, '_seasons', true);

        //seasons count change
        if (isset($_POST['season_change']) && $_POST['season_change'] == 'true') {
            array_push($season_ajax, array('tvshow_id' => $tvshow_id));
            foreach ($season_data as $index => $val) {
                ob_start(); ?>
                <a class="nav-item nav-link streamit-episodes-meta tvshow-<?php echo esc_attr($tvshow_id); ?>" data-tvshow-id="<?php echo esc_attr($tvshow_id); ?>" data-season="<?php echo $index; ?>">
                    <?php echo esc_html($val['name']); ?>
                </a>
            <?php
                $k++;
                $season_content = ob_get_clean();

                array_push($season_ajax, array('season_content' => $season_content));
            }
        }

        //episodes change
        $season_data = $season_data[$_POST['season_number']];
        $episode_count = 0;
        if (!empty($season_data['episodes'])) {
            foreach ($season_data['episodes'] as $epdata) {
                $episode_run_time = $url = '';
                $_episode_run_time = get_post_meta($epdata, '_episode_run_time');
                $_thumbnail_id = get_post_meta($epdata, '_thumbnail_id');
                $thumbnail_id = get_post_thumbnail_id($epdata);
                $image_alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);

                if (!empty($image_alt)) {
                    $image_alt = $image_alt;
                } else {
                    $image_alt = esc_attr__('image', ' streamit-extensions');
                }

                if (isset($_thumbnail_id[0])) {
                    $url = wp_get_attachment_url($_thumbnail_id[0]);
                }

                if (isset($_episode_run_time[0])) {
                    $episode_run_time = $_episode_run_time[0];
                }

                ob_start(); ?>

                <div class="episodes-info episode-<?php echo esc_attr($epdata); ?> tvshow-<?php echo esc_attr($tvshow_id); ?>-season-<?php echo esc_attr($_POST['season_number'] + 1); ?>">
                    <div class="episode-img">
                        <img src="<?php echo esc_attr($url); ?>" alt="episode-img">
                    </div>

                    <div class="episodes-meta">
                        <div class="episode-name">
                            <a href="<?php echo get_the_permalink($epdata); ?>">
                                <?php echo get_the_title($epdata); ?>
                            </a>
                        </div>

                        <div class="episode-time mt-2">
                            <?php echo esc_html($episode_run_time); ?>
                        </div>
                    </div>
                </div>
                <?php
                $block_content = ob_get_clean();

                array_push($season_ajax, array('block_content' => $block_content));

                if ($episode_count == 4) { // To show only 5 episodes
                    ob_start(); ?>
                    <div class="view-all-btn episodes-info tvshow-<?php echo esc_attr($tvshow_id); ?>-season-<?php echo esc_attr($_POST['season_number'] + 1); ?>">
                        <div class="p-btns align-items-center justify-content-center">
                            <a href="<?php echo get_the_permalink($tvshow_id) ?>" class="season-btn">
                                <?php echo esc_html($episode_card_btn_text); ?>
                            </a>
                        </div>
                    </div>
            <?php
                    $button_content = ob_get_clean();
                    array_push($season_ajax, array('button_content' => $button_content));
                    break;
                } else {
                    $episode_count++;
                }
            }
        }
        array_push($episodes_data, $season_ajax);

        echo json_encode($season_ajax);
        wp_die();
    }
}

//===========FOR SHORTCODE TVSHOW TAB===========
add_action('wp_ajax_loadmore_tvshow_episodes', 'loadmore_tvshow_episodes_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_tvshow_episodes', 'loadmore_tvshow_episodes_ajax_handler');

if (!function_exists('loadmore_tvshow_episodes_ajax_handler')) {
    function loadmore_tvshow_episodes_ajax_handler()
    {
        $season_data = $_POST['data'];
        $season_data = $season_data[$_POST['season']];
        $season_ajax = array();

        foreach ($season_data['episodes'] as $epdata) {
            $ep_obj = get_post($epdata);
            $episode_number = '';
            $episode_run_time = '';
            $url = '';
            $_episode_number = get_post_meta($epdata, '_episode_number');
            $_episode_run_time = get_post_meta($epdata, '_episode_run_time');
            $_thumbnail_id = get_post_meta($epdata, '_thumbnail_id');
            $thumbnail_id = get_post_thumbnail_id($epdata);
            $image_alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
            if (!empty($image_alt)) {
                $image_alt = $image_alt;
            } else {
                $image_alt = esc_attr__('image', ' streamit-extensions');
            }
            if (isset($_thumbnail_id[0])) {
                $url = wp_get_attachment_url($_thumbnail_id[0]);
            }

            if (isset($_episode_number[0])) {
                $episode_number = $_episode_number[0];
            }
            if (isset($_episode_run_time[0])) {
                $episode_run_time = $_episode_run_time[0];
            }
            ob_start();
            ?>
            <a href="<?php the_permalink($epdata); ?>">
                <img src="<?php echo esc_html($url); ?>" class="img-fluid" alt="<?php echo $image_alt; ?>">
            </a>
            <span class="episode-duration"><?php echo esc_html($episode_run_time); ?></span>
            <div class="episode-play-info">
                <div class="episode-play">
                    <a href="<?php the_permalink($epdata); ?>" tabindex="0"><i class="fas fa-play"></i></a>
                </div>
            </div>
            <?php
            $block_img = ob_get_clean();
            ob_start();
            ?>
            <div class="d-flex align-items-center iq-tab-no-title">
                <div class="episode-number"><?php echo esc_html($episode_number); ?></div>
                <a href="<?php the_permalink($epdata); ?>"><?php echo esc_html($ep_obj->post_title); ?></a>
            </div>
            <p class="mb-0">
                <?php
                $content = $ep_obj->post_excerpt;
                if (!empty($content)) {
                    $iq_remove_tags = array("<p>", "</p>");
                    $iq_excerpt = str_replace($iq_remove_tags, "", $content);
                    echo __($iq_excerpt);
                }
                ?>
            </p>

        <?php
            $block_content = ob_get_clean();

            array_push($season_ajax, array('block_img' => $block_img, 'block_contnt' => $block_content));
        }

        echo json_encode(array('success' => true, 'result' => $season_ajax));
        wp_die();
    }
}

//===========FOR SHORTCODE MOVIE / VIDEO TAB : LOAD SIMILAR MOVIE / VIDEOS===========
add_action('wp_ajax_loadmore_similar_movies_videos', 'streamit_loadmore_similar_movies_videos_ajax_handler');
add_action('wp_ajax_nopriv_loadmore_similar_movies_videos', 'streamit_loadmore_similar_movies_videos_ajax_handler');

if (!function_exists('streamit_loadmore_similar_movies_videos_ajax_handler')) {
    function streamit_loadmore_similar_movies_videos_ajax_handler()
    {

        $season_ajax = array();
        $genre = $_POST['data'];
        $post_type = $_POST['post_type'];
        $slug = array();
        $taxonomy = $genre[0]['taxonomy'];
        ?>
        <?php
        foreach ($genre as $epdata) {
            $slug[] = $epdata['slug'];
        }

        $args = array(
            'post_type' => $post_type,
            'post_status' => 'publish',
            'orderby' => 'date',
            'order' => 'DESC',
            'posts_per_page' => 10,
            'tax_query' => array(
                array(
                    'taxonomy' => $taxonomy,
                    'field' => 'slug',
                    'terms' => $slug,
                ),
            ),
        );
        $wp_query1 = new \WP_Query($args);
        if ($wp_query1->have_posts()) {
            while ($wp_query1->have_posts()) {

                $wp_query1->the_post();
                $url = get_the_post_thumbnail_url(get_the_ID());
                $thumbnail_id = get_post_thumbnail_id(get_the_ID());
                $run_time = get_post_meta(get_the_ID(), '_' . $post_type . '_run_time');
                $image_alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true);
                $year = get_the_date('M Y');
                if (!empty($image_alt)) {
                    $image_alt = $image_alt;
                } else {
                    $image_alt = esc_attr__('image', ' streamit-extensions');
                }
                if (isset($run_time[0])) {
                    $run_time = $run_time[0];
                }

                ob_start(); ?>
                <a href="<?php the_permalink(); ?>">
                    <img src="<?php echo esc_html($url); ?>" class="img-fluid" alt="<?php echo $image_alt; ?>">
                </a>
                <span class="episode-duration"><?php echo esc_html($run_time); ?></span>
                <div class="episode-play-info">
                    <div class="episode-play">
                        <a href="<?php the_permalink(); ?>" tabindex="0"><i class="fas fa-play"></i></a>
                    </div>
                </div>
                <?php
                $block_img = ob_get_clean();
                ob_start();
                ?>
                <div class="d-flex align-items-center iq-tab-no-title">
                    <div class="episode-number"><?php echo esc_html($year); ?></div>
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </div>
                <p class="mb-0 mt-2 movies-tab-desc">
                    <?php
                    $thecontent = get_the_excerpt();
                    if (!empty($thecontent)) {
                        echo wp_trim_words($thecontent, 20, '...');
                    }
                    ?>
                </p>
        <?php
                $block_content = ob_get_clean();

                array_push($season_ajax, array('block_img' => $block_img, 'block_contnt' => $block_content));
            }
        }

        echo json_encode(array('success' => true, 'result' => $season_ajax));
        wp_die();
    }
}

//===========FOR SHORTCODE AJAX SEARCH : SEARCH HISTORY(shows last 10 search keywords to user)===========
add_action('wp_ajax_load_search_result', 'streamit_load_search_result_handler');
add_action('wp_ajax_nopriv_load_search_result', 'streamit_load_search_result_handler');

if (!function_exists('streamit_load_search_result_handler')) {
    function streamit_load_search_result_handler()
    {
        global $streamit_options;

        if ($streamit_options['enable_search_history_module'] != "yes") die;

        $current_user_id        = get_current_user_id();
        $stored_search_results  = get_user_meta($current_user_id, '_streamit_search_results', true);

        if (empty($stored_search_results)) die; ?>

        <div class="widget streamit-ajax-custom-search mb-0">
            <h5 class="most_recent_search text-center"> <?php echo esc_html($streamit_options['search_history_label']); ?> </h5>
            <ul class="search_history_list">
                <?php foreach ($stored_search_results as $result) {
                    echo
                    '<li class="mr-0 d-block">
                        <h6 class="search-result">' . esc_html(trim($result)) . '</h6>
                    </li>';
                } ?>
            </ul>
        </div>
<?php
        die;
    }
}
