<?php

add_shortcode('iqonic_user_watchlist', 'iqonic_watchlist_view');

if (!function_exists('iqonic_watchlist_view')) {
    function iqonic_watchlist_view($atts)
    {
        if (is_user_logged_in()) {
            $attributes = shortcode_atts(array(
                'style'             => "tiles",
                'img-orientation'   => "landscape",
                'post_title'        => "show"
            ), $atts);

            return iqonic_get_watchlist_view($attributes);
        } else {
            $iqonic_signin_link = home_url();
            if (class_exists('ReduxFramework')) {
                global $streamit_options;
                if (isset($streamit_options['streamit_signin_link']) && !empty($streamit_options['streamit_signin_link'])) {
                    $iqonic_signin_link = get_page_link($streamit_options['streamit_signin_link']);
                }
            }
            echo "<script>location.href = '" . esc_url($iqonic_signin_link) . "';</script>";
            die;
        }
    }
}

if (!function_exists('iqonic_get_watchlist_view')) {
    function iqonic_get_watchlist_view($attributes)
    {
        ob_start();

        global $paged, $streamit_options;

        $style                  = $attributes['style'];
        $img_orientation        = $attributes['img-orientation'];
        $user                   = wp_get_current_user();
        $user_id                = $user->ID;
        $paged                  = get_query_var('paged') ? get_query_var('paged') : 1;
        $watchlist              = get_user_meta($user_id, '_user_watchlist', true);

        $rand                   = rand(10, 100);
        $slider_title           = $view_cat = $view_all = $col = $lazy_load = $ajax_load = '';

        $current_page           = '1';
        $can_be_loaded          = false;
        $loadmore_btn           = 'watchlist-load-btn-' . $rand;

        $is_grid                = true;
        $options_streamit_load  = $streamit_options['streamit_display_buttons'];

        $is_ajax_enable         = true;
        $is_badges_enable       = true;
        $show_title             = $attributes['post_title'] == "show";

        $thumbnail_size         = "full";
        $lazy_load              = $is_ajax_enable ? " iqonic-lazy-load-images" : '';
        $col                    = ($style == "cards") && ($img_orientation == "portrait") ? "col-xl-2 col-lg-4 col-md-4 col-sm-6 col-6 wl-child" : "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child";
        $img_orientation        = isset($img_orientation) && !empty($img_orientation) ? $img_orientation : 'portrait';

        $loadmore_text          = $streamit_options['streamit_display_loadmore_text'];
        $loading_text           = $streamit_options['streamit_display_loadmore_text_2'];

        $pagination             = $streamit_options['streamit_display_buttons'];
        $pagination             = ($pagination == "infinite_scroll")  ? "infinite" : $pagination;
        $pagination             = ($pagination == "load_more")        ? "loadmore" : $pagination;
        $pagination             = ($pagination == "pagination")       ? "yes"      : $pagination;

        $args = array(
            'post_type'         => array('movie', 'tv_show', 'video', 'episode'),
            'post_status'       => 'publish',
            'order'             => $streamit_options['streamit_display_order'],
            'post__in'          => explode(',', $watchlist),
            'posts_per_page'    => $streamit_options['streamit_post_per_page'],
            'paged'             => $paged,
            'fields'            => 'ids',
        );

        $settings = [
            'is_grid'               => $is_grid,
            'thumbnail_size'        => $thumbnail_size,
            'image_style'           => $img_orientation,
            'lazy_load'             => $lazy_load,
            'is_ajax_enable'        => $is_ajax_enable,
            'col'                   => $col,
            'options_streamit_load' => $options_streamit_load,
            'is_badges_enable'      => $is_badges_enable,
            'img_orientation'       => $img_orientation,
            'style'                 => $style,
            'play_now_text'         => esc_html__("Play Now", SE_TEXT_DOMAIN),
            'button_text'           => esc_html__("Play Now", SE_TEXT_DOMAIN),
            'lazy_load'             => $lazy_load,
            'show_title'            => $show_title,
        ];

        $main_class         = ($style == "cards") ? "iq-card-wrapper" : "watchlist-contens";
        wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . "includes/Elementor/assets/css/cards-general.css", [], STREAMIT_EXTENSION_VERSION, "all");

        $wp_query = new \WP_Query($args);

        $post_ids        = $wp_query->posts;
        $count           = $wp_query->post_count;
        $total_pages     = $wp_query->max_num_pages;

        if ($is_ajax_enable) {
            $current_page     = '0';
            $can_be_loaded    = true;
            $ajax_load        = 'ajax_load';
            $lazy_load        = " iqonic-lazy-load-images";
        } ?>

        <div class="<?php echo esc_attr(($main_class)); ?> streamit-watchlist-container iq-ajax-content streamit_watchlist_ajax <?php echo esc_attr($lazy_load); ?>" data-options="<?php echo esc_html($pagination); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
            <div class="list-grid list-inline  row p-0 mb-0">
                <?php if (!$is_ajax_enable && $wp_query->have_posts()) {
                    foreach ($post_ids as $post_id) {
                        if ("cards" == $style) {
                            get_watchlist_cards($wp_query, $img_orientation, $post_ids, $settings);
                        } else {
                            get_watchlist_tiles($wp_query, $post_ids, $settings);
                        }
                    }
                    wp_reset_postdata();
                } else {
                    for ($i = 0; $i < $count; $i++) {
                        if ($style == 'cards') :
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/ajax_Cards.php';
                        else :
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/ajax_Slider.php';
                        endif;
                    }
                } ?>
            </div>

            <?php if ($is_grid && $can_be_loaded && $pagination == 'yes') {
                streamit_get_numbers_pagination($total_pages);
            } elseif ($is_grid && $can_be_loaded && $pagination == 'infinite' && $total_pages > 1) {
                echo '<div class="loader-wheel-container"></div>';
            } ?>
        </div>

        <?php if ($can_be_loaded) { ?>
            <div class="loader-wheel-container">
                <?php if ($is_grid && $pagination == 'loadmore' && $total_pages > 1) : ?>
                    <div class="<?php echo esc_attr($loadmore_btn); ?>">
                        <div class="btn btn-hover iq-button">
                            <span><?php echo !empty($loadmore_text) ? esc_html($loadmore_text) : '' ?></span>
                        </div>
                    </div>
                <?php endif;

                if ($is_grid && $pagination == "yes") {
                    $current_page  = max(1, get_query_var('paged')) - 1;
                }

                $pagination_args = [
                    'action'            => 'loadmore_watchlist',
                    'current_page'      => $current_page,
                    'total_pages'       => $total_pages,
                    'loadmore_btn'      => $loadmore_btn,
                    'loading_text'      => $loading_text,
                    'query_args'        => $args,
                    'temp_settings'     => $settings,
                    'posts_per_page'    => $count,
                    'ajax_load'         => $ajax_load,
                    'is_ajax_enable'    => $is_ajax_enable,
                ];

                streamit_get_pagination_args($pagination_args); ?>
            </div>
        <?php }

        return ob_get_clean();
    }
}

if (!function_exists("get_watchlist_tiles")) {
    function get_watchlist_tiles($wp_query, $post_ids, $settings)
    {
        global $streamit_options;

        extract($settings); ?>

        <div class="watchlist-contens streamit_datapass_watchlist">
            <div class="row wl watchlist-grid list-grid list-inline">
                <?php if ($wp_query->have_posts()) {
                    foreach ($post_ids as $post_id) {
                        $post_type = get_post_type($post_id);

                        if ("movie" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Slider/template.php';
                            continue;
                        } else if ("tv_show" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Slider/template.php';
                            continue;
                        } else if ("video" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Slider/template.php';
                            continue;
                        } elseif ("episode" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/Slider_General.php';
                            continue;
                        }
                    }
                    wp_reset_postdata();
                } else { ?>
                    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child">
                        <?php
                        echo esc_html__('Your Watchlist is empty...', "streamit-extensions");
                        ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    <?php
    }
}

if (!function_exists("get_watchlist_cards")) {
    function get_watchlist_cards($wp_query, $img_orientation, $post_ids, $settings)
    {
        global $streamit_options;
        extract($settings); ?>

        <div class="iq-card-wrapper grid-view streamit_datapass_watchlist favorites-contens">
            <ul class="row list-inline list-grid favorites-grid">
                <?php if ($wp_query->have_posts()) {
                    foreach ($post_ids as $post_id) {

                        $post_type = get_post_type($post_id);

                        if ("movie" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Movie_Cards/template.php';
                            continue;
                        } else if ("tv_show" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/TvShow_Cards/template.php';
                            continue;
                        } else if ("video" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Video_Cards/template.php';
                            continue;
                        } elseif ("episode" == $post_type) {
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/Cards_General.php';
                            continue;
                        }
                    }
                    wp_reset_postdata();
                } else { ?>
                    <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child">
                        <?php echo esc_html__('Your Watchlist is empty...', SE_TEXT_DOMAIN); ?>
                    </div>
                <?php } ?>
            </ul>
        </div>
<?php
    }
} ?>