<?php

use function Streamit\Utility\streamit;


function streamit_register_ajax_handler()
{
    if (isset($_POST['iqonic_register_nonce']) && wp_verify_nonce($_POST['iqonic_register_nonce'], 'iqonic-register-nonce')) {

        $user_first     = $_POST['user_fname'];
        $user_last      = $_POST['user_lname'];
        $user_email     = $_POST['user_email'];
        $user_name      = $_POST['user_username'];
        $user_pass      = $_POST['user_password'];
        $pmpro_plan_id = $_POST['plan_id'];
        $pmpro_product_id = $_POST['product_id'];

        $fields = array($user_first, $user_last, $user_email, $user_name, $user_pass);

        $term_condition = isset($_POST["iqonic_term_condition"]) ? $term_condition = $_POST["iqonic_term_condition"] : '';

        $errors = array();
        $aValid = array('-', '_');

        if (email_exists($user_email)) {
            $errors['email_error'] = __('Email already exists.', 'streamit-extensions');
        }

        if (username_exists($user_name)) {
            $errors['uname_error'] = __('Username already exists.', 'streamit-extensions');
        } elseif (!ctype_alnum(str_replace($aValid, '', $user_name))) {
            $errors['uname_error'] = __('Your username is not properly formatted.', 'streamit-extensions');
        }

        if (empty($user_pass)) {
            $errors['pass_error'] = __('Password fields should not be empty', 'streamit-extensions');
        }

        if (empty($term_condition)) {
            $errors['terms_conditions'] = __('Please select terms & Conditions', 'streamit-extensions');
        }
        $errors = apply_filters("registration_error", $errors);
        // only create the user in if there are no errors
        if (empty($errors)) {
            $args = array(
                'user_login'        => $user_name,
                'user_pass'         => $user_pass,
                'user_email'        => $user_email,
                'first_name'        => $user_first,
                'last_name'         => $user_last,
                'user_registered'   => date('Y-m-d H:i:s'),
                'role'              => 'subscriber'
            );

            $new_user_id = wp_insert_user($args);
            if ($new_user_id) {

                $user = get_user_by('id', $new_user_id);

                // send an email to the admin alerting them of the registration
                wp_new_user_notification($new_user_id);

                update_user_meta($new_user_id, 'user_terms_conditions', esc_attr($term_condition));

                do_action('wp_login', $user_name, $user);
                do_action('register_new_user', $new_user_id);
                do_action("user_register", $new_user_id, $args);

                // log the new user in
                wp_set_current_user($new_user_id, $user_name);
                wp_set_auth_cookie($new_user_id);

                do_action("streamit_save_registration_form_fields", $fields, $new_user_id);

                if ($user_name == NULL) sanitize_text_field($user_name = $user->user_login);
                if ($user_pass == NULL) sanitize_text_field($user_pass = $user->user_pass);

                $user_login_cred = array(
                    "user_login"        => $user_name,
                    "user_password"     => $user_pass,
                    "remember"          => true
                );

                $is_user_logged_in  = wp_signon($user_login_cred);

                if ($is_user_logged_in && is_plugin_active('paid-memberships-pro/paid-memberships-pro.php')) {
                    $pmpro_user_created = streamit()->streamit_register_pmpro_user($new_user_id);

                    if ($pmpro_user_created !== NULL) {
                        if (is_plugin_active("pmpro-woocommerce/pmpro-woocommerce.php") && $pmpro_plan_id !== NULL && $pmpro_product_id !== NULL) {
                            require_once 'user-loggedin.php';
                        } else {
                            wp_redirect(home_url());
                            exit;
                        }
                    } else {
                        if (!$streamit_show_pmp_payment && $pmpro_plan_id !== NULL && $pmpro_product_id !== NULL) {
                            require_once 'user-loggedin.php';
                        } else {
                            $redirect = pmpro_getOption("levels_page_id");
                            $redirect = get_page_link($redirect);
                            wp_redirect($redirect);
                            exit;
                        }
                    }
                } else {
                    wp_redirect($redirect);
                    exit;
                }
            }
        }
    }
}

add_action('admin_post_streamit_register', 'streamit_register_ajax_handler');
add_action('admin_post_nopriv_streamit_register', 'streamit_register_ajax_handler');

add_shortcode('iqonic_register_form', 'iqonic_registration_form');

if (!function_exists('iqonic_registration_form')) {
    function iqonic_registration_form($atts)
    {
        extract(shortcode_atts(array(
            'redirect' => home_url(),
        ), $atts));

        return iqonic_registration_form_fields($atts);
    }
}

if (!function_exists('iqonic_registration_form_fields')) {
    function iqonic_registration_form_fields($atts)
    {
        global $streamit_options;

        $fields = array();
        $form_fields = array(
            "user_fname" => array(
                "class"         => "",
                "required"      => false,
                "type"          => "text",
                "parent_class"  => "col-md-6",
                "text"          => "First Name",
            ),
            "user_lname" => array(
                "class"         => "",
                "required"      => false,
                "type"          => "text",
                "parent_class"  => "col-md-6",
                "text"          => "Last Name",
            ),
            "user_email" => array(
                "class"         => "",
                "required"      => true,
                "type"          => "email",
                "text"          => "Email *",
                "parent_class"  => "col-md-12",
            ),
            "user_username" => array(
                "class"         => "",
                "required"      => true,
                "type"          => "text",
                "parent_class"  => "col-md-6",
                "text"          => "Username *",
            ),
            "user_password"  => array(
                "class"         => "",
                "required"      => true,
                "type"          => "password",
                "text"          => "Password *",
                "parent_class"  => "col-md-6 login-password",
            ),
        );

        ob_start();

        $is_user_logged_in          = is_user_logged_in();
        $streamit_show_pmp_payment  = apply_filters("streamit_show_pmp_payment", true);
        $form_fields                = apply_filters("streamit_add_registration_form_fields", $form_fields);

        $pmpro_plan_id              = isset($_REQUEST['plan_id']) && !empty($_REQUEST['plan_id'])       ? $_REQUEST['plan_id']     : NULL;
        $pmpro_product_id           = isset($_REQUEST['product_id']) && !empty($_REQUEST['product_id']) ? $_REQUEST['product_id']  : NULL;
?>

        <div class="iq-signup-form pmp_payment_bg rounded">
            <?php if ($is_user_logged_in) {
                require_once 'user-loggedin.php';
            } else {
                extract(shortcode_atts(array(
                    'redirect' => home_url(),
                ), $atts)); ?>

                <h4 class="iqonic_header">
                    <?php _e('Create Your Account', 'streamit-extensions'); ?>
                </h4>

                <?php

                if (!is_user_logged_in()) { ?>
                    <form id="iqonic_registration_form" class="iqonic_form" action="<?php echo esc_url(admin_url('admin-post.php')) ?>" method="POST">
                        <input type="hidden" name="action" value="streamit_register">
                        <input type="hidden" name="pmpro_plan_id" value="<?php echo $pmpro_plan_id; ?>">
                        <input type="hidden" name="pmpro_product_id" value="<?php echo $pmpro_product_id; ?>">
                        <fieldset>
                            <div class="row">
                                <?php foreach ($form_fields as $key => $value) {
                                    if ($value['type'] !== "select") { ?>
                                        <div class="<?php echo esc_attr($value['parent_class']) ?>">
                                            <p>
                                                <label for="<?php echo esc_attr($key) ?>">
                                                    <?php esc_html_e($value['text'], SE_TEXT_DOMAIN); ?>
                                                </label>

                                                <input name="<?php echo esc_attr($key) ?>" id="<?php echo esc_attr($key) ?>" type="<?php echo esc_attr($value['type']) ?>" <?php echo $value['required'] == true ? 'required' : '' ?> value="<?php echo isset($_REQUEST[$key]) ? esc_attr($_REQUEST[$key]) : ''; ?>" />
                                            </p>
                                        </div>
                                    <?php } elseif ($value['type'] == "select") { ?>
                                        <div class="<?php echo esc_attr($value['parent_class']) ?>">
                                            <p>
                                                <label for="<?php echo esc_attr($key) ?>">
                                                    <?php esc_html_e($value['text'], SE_TEXT_DOMAIN); ?>
                                                </label>

                                                <select name="<?php echo esc_attr($key) ?>" id="<?php echo esc_attr($key) ?>" type="<?php echo esc_attr($value['type']) ?>" <?php echo $value['required'] == true ? 'required' : '' ?>>
                                                    <?php if (isset($value['options']) && !empty($value['options'])) {
                                                        foreach ($value['options'] as $key => $value) { ?>
                                                            <option name="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($key); ?>"> <?php echo esc_html($value); ?> </option>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </select>
                                            </p>
                                        </div>
                                    <?php } ?>
                                <?php } ?>

                                <div class="col-xl-12">
                                    <p class="login-remember d-flex align-items-start">
                                        <input type="checkbox" class="iq-term mb-0" name="iqonic_term_condition" id="iqonic_term_condition" value="accepted" required>
                                        <label for="iqonic_term_condition" class="mb-0">
                                            <?php esc_html_e("I've read and accepted the", SE_TEXT_DOMAIN); ?>
                                            <a href="<?php echo esc_html(get_page_link($streamit_options['streamit_term_condition'])) ?>"><?php _e('Terms & conditions*', 'streamit-extensions'); ?></a>
                                        </label>
                                    </p>
                                </div>

                                <div class="col-xl-12 hover-buttons">
                                    <p class="signup-submit mb-0 text-center">
                                        <input type="hidden" name="iqonic_register_nonce" class="btn btn-hover" value="<?php echo wp_create_nonce('iqonic-register-nonce'); ?>" />
                                        <button type="submit" class="btn btn-hover iq-button w-50 text-capitalize" value="<?php _e('Sign Up', 'streamit-extensions'); ?>"><?php _e('Sign Up', 'streamit-extensions'); ?></button>
                                    </p>
                                </div>

                                <div class="col-xl-12">
                                    <div class="d-flex justify-content-center links">
                                        <?php if (isset($streamit_options['streamit_signin_link'])) {
                                            $iqonic_signin_link = get_page_link($streamit_options['streamit_signin_link']);
                                            $iqonic_signin_title = $streamit_options['streamit_signin_title']; ?>
                                            <?php _e('Already have an account?', 'streamit-extensions'); ?><a href="<?php echo esc_url($iqonic_signin_link) ?>" class="iq-sub-card setting-dropdown">

                                                <h6 class="mb-0">
                                                    <?php if (!empty($iqonic_signin_title)) {
                                                        echo esc_html($iqonic_signin_title);
                                                    } else {
                                                        echo esc_html__('Sign In', 'streamit-extensions');
                                                    } ?>
                                                </h6>
                                            </a>
                                        <?php } ?>
                                    </div>
                                    <?php if (shortcode_exists('miniorange_social_login') && !is_user_logged_in()) { ?>

                                        <div class="streamit-seperator">
                                            <span class="line-1"></span>
                                            <span class="or-section"><?php esc_html__("OR", 'streamit'); ?> </span>
                                            <span class="line-2"></span>
                                        </div>

                                        <div class="streamit-social-login-section">
                                            <?php echo do_shortcode('[miniorange_social_login]'); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                <?php } ?>
            <?php } ?>
        </div>
<?php
        return ob_get_clean();
    }
} ?>