<?php

if (!defined('ABSPATH')) exit;
if (!is_plugin_active('masvideos/masvideos.php')) return;

add_shortcode('iqonic_user_playlist', 'iqonic_user_playlist');

if (!function_exists('iqonic_user_playlist')) {
    function iqonic_user_playlist()
    {
        $tabs['movie_playlist'] = array(
            'title'     => esc_html__('Movie Playlist', 'streamit-extensions'),
            'callback'  => array('MasVideos_Shortcode_My_Account', 'manage_playlists'),
            'priority'  => 10
        );

        $tabs['video_playlist'] = array(
            'title'     => esc_html__('Video Playlist', 'streamit-extensions'),
            'callback'  =>  array('MasVideos_Shortcode_My_Account', 'manage_playlists'),
            'priority'  => 20
        );

        $tabs['tv_show_playlist'] = array(
            'title'     => esc_html__('TV Show Playlist', 'streamit-extensions'),
            'callback'  =>  array('MasVideos_Shortcode_My_Account', 'manage_playlists'),
            'priority'  => 30,
        );
        $default_active_tab = isset($_GET['playlistof']) && array_key_exists($_GET['playlistof'] . '_playlist', $tabs) ? $_GET['playlistof'] . '_playlist' :  'movie_playlist';

        if (!empty($tabs)) {
            get_template_part('template-parts/global/tabs', '', array('tabs' => $tabs, 'default_active_tab' => $default_active_tab));
        }
    }
}

add_shortcode('iqonic_playlist', 'iqonic_playlist_dropdown');
function iqonic_playlist_dropdown()
{
    global $post, $streamit_options;

    $post_type = get_post_type();
    if (!in_array($post_type, array('movie', 'episode', 'video', 'tv_show'))) return;

    $content_id = $post->ID; ?>

    <div class="<?php echo $post_type ?>-actions--link_add-to-playlist dropdown iqonic-playlist-dropdown">
        <a class="dropdown-toggle" role="button" href="#" id="<?php echo 'dropdown-playlist-"' . $content_id; ?>" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <svg width="7" height="8" viewBox="0 0 7 8" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M6.04368 4.16417H1.14368" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                <path d="M3.59448 6.61387V1.71387" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            </svg>

            <?php echo esc_html__('Playlist', 'streamit-extensions') ?></a>

        <div class="dropdown-menu" aria-labelledby="<?php echo 'dropdown-playlist-"' . $content_id; ?>">
            <?php $link =  add_query_arg('playlistof', $post_type, get_permalink($streamit_options['streamit_playlist_page']));
            if (is_user_logged_in()) { ?>
                <a class="create-playlist-link" href="<?php echo esc_attr($link); ?>">
                    <svg width="7" height="8" viewBox="0 0 7 8" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M6.04368 4.16417H1.14368" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M3.59448 6.61387V1.71387" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>

                    <?php echo esc_html__('Create a playlist', 'streamit-extensions'); ?>
                </a>
                <?php

                $content_playlists = call_user_func('masvideos_get_current_user_' . $post_type . '_playlists');
                if (!empty($content_playlists)) {
                    foreach ($content_playlists as $key => $content_playlist) {
                        $playlist_id = $content_playlist->ID;
                        $is_content_added =  call_user_func('masvideos_is_' . $post_type . '_added_to_playlist', $playlist_id, $content_id); ?>
                        <a class="toggle-playlist masvideos-ajax-toggle-<?php echo str_replace("_", "-", $post_type); ?>-playlist<?php echo $is_content_added ? ' added' : ''; ?>" href="<?php echo get_permalink($playlist_id); ?>" data-playlist_id=<?php echo esc_attr($playlist_id); ?> data-<?php echo  $post_type; ?>_id=<?php echo esc_attr($content_id); ?>>
                            <?php
                            printf(
                                "%s%s",
                                '<svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M8.674 0.75H3.61708C1.85483 0.75 0.75 1.99775 0.75 3.7635V8.52817C0.75 10.2939 1.84958 11.5417 3.61708 11.5417H8.67342C10.4415 11.5417 11.5417 10.2939 11.5417 8.52817V3.7635C11.5417 1.99775 10.4415 0.75 8.674 0.75Z" stroke="white" stroke-linecap="round" stroke-linejoin="round"/>
                                <path class="checked" d="M4.25 6.21775L5.63483 7.602L8.40333 4.8335" stroke="white" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>',
                                get_the_title($playlist_id)
                            ); ?>
                        </a>
                <?php
                    }
                }
            } else { ?>
                <a class="login-link" href="<?php echo get_permalink($streamit_options['streamit_signin_link']); ?>">
                    <?php echo esc_html__('Sign in to add this ' . str_replace("_", " ", $post_type) . ' to a playlist.', 'streamit-extensions'); ?>
                </a>
            <?php
            }
            ?>
        </div>
    </div>
<?php
}
