<?php

add_shortcode('iqonic_login', 'iqonic_login_form');
add_action('wp_login_failed', 'user_login_fail');

if (!function_exists('user_login_fail')) {
    function user_login_fail($username)
    {
        $referrer = $_SERVER['HTTP_REFERER'];
        if (!empty($referrer) && !strstr($referrer, 'wp-login') && !strstr($referrer, 'wp-admin') && !isset($_REQUEST['pms_login'])) {
            wp_redirect($referrer . '?login=failed');
            exit;
        }
    }
}

if (!function_exists('iqonic_login_form')) {
    function iqonic_login_form()
    {
        // get registration form if user not logged in
        if (!is_user_logged_in() || is_user_logged_in()) {
            global $current_url;

            $page = explode('?', $current_url);
            $get_page = end($page);
            if ($get_page === 'forgot-password' || (isset($_POST['action']) && $_POST['action'] == 'forgot-password'))
                return iqonic_edit_pass_form();
            else
                return iqonic_user_login();
        } else {
            if (!is_super_admin(get_current_user_id()))
                wp_redirect(home_url());
        }
    }
}

if (!function_exists('iqonic_user_login')) {
    function iqonic_user_login()
    {
        ob_start(); ?>

        <div class="iqonic-user-forms streamit-login-form">
            <div class="iq-login-form">
                <div class="iq-login-title mb-3">
                    <h4>
                        <?php echo apply_filters('streamit_login_form_title', esc_html__('Sign In', SE_TEXT_DOMAIN)); ?>
                    </h4>
                </div>

                <div class="error-msg"></div>

                <?php
                if (isset($_REQUEST['login']) && $_REQUEST['login'] === 'failed') { ?>
                    <div class="error-login"><?php echo esc_html__('Please Enter Valid Username / Email And Password', SE_TEXT_DOMAIN); ?></div>
                <?php }

                $args = array(
                    'echo'  => false,
                    'label_log_in'      => esc_html__('Log In', SE_TEXT_DOMAIN),
                    'label_username'    => esc_html__('Username Or Email Address', SE_TEXT_DOMAIN),
                    'label_password'    => esc_html__('Password', SE_TEXT_DOMAIN),
                    'redirect'          => esc_url(home_url()),
                );

                $login_form = wp_login_form($args);

                //add the placeholders
                $uname_placeholder  = 'name="log" required=""';
                $pass_placeholder   = 'name="pwd" required=""';
                $login_form         = str_replace('name="log"', $uname_placeholder, $login_form);
                $login_form         = str_replace('name="pwd"', $pass_placeholder, $login_form);

                // Find the "Remember Me" section in the output HTML
                $remember_me_start      = strpos($login_form, '<p class="login-remember">');
                $remember_me_end        = strpos($login_form, '</p>', $remember_me_start) + 4;
                $remember_me_section    = substr($login_form, $remember_me_start, $remember_me_end - $remember_me_start);

                // Modify the structure of the "Remember Me" section
                $modified_remember_me_section = '
                    <p class="login-remember">
                        <input name="rememberme" type="checkbox" id="rememberme" value="forever">
                        <label for="rememberme"> ' . esc_html__("Remember Me", SE_TEXT_DOMAIN) . ' </label>
                    </p>';

                // Replace the original "Remember Me" section with the modified one
                $login_form = str_replace($remember_me_section, $modified_remember_me_section, $login_form);

                echo $login_form; ?>
            </div>
        </div>
<?php
        return ob_get_clean();
    }
} ?>