<?php

/**
 * Template for displaying the PMP Plan Information if user is logged in, and selecting the payment gateway option.
 * 
 */

use function Streamit\Utility\streamit;

if ($pmpro_plan_id !== NULL) {
    $pmpro_level        = pmpro_getLevel($pmpro_plan_id);

    $pmpro_description  = $pmpro_level->description;
    $is_plan_free       = pmpro_isLevelFree($pmpro_level);
    $billing_price      = pmpro_formatPrice($pmpro_level->billing_amount);
    $billing_amount     = pmpro_round_price($pmpro_level->billing_amount);

    $price              = pmpro_formatPrice($pmpro_level->initial_payment);
    $initial_payment    = pmpro_round_price($pmpro_level->initial_payment);

    if (isset($_GET['discount_code']) && !empty($_GET['discount_code'])) {
        $discount_code = '&discount_code=' . $_GET['discount_code'];
    } else {
        $discount_code = '';
    }

    if ($pmpro_level->expiration_number > 0) {
        $expiration_info = $pmpro_level->expiration_number . ' ' . $pmpro_level->expiration_period;
    } else {
        $expiration_info = '';
    }

    if (function_exists('pmprosd_getDelay')) {
        $trial_period = (int)pmprosd_getDelay($pmpro_plan_id);
    }

    if (!$streamit_show_pmp_payment || isset($_POST['iqonic_pmpro_wpg_nonce']) && wp_verify_nonce($_POST['iqonic_pmpro_wpg_nonce'], 'iqonic-pmpro-wpg-nonce')) {
        $redirect = streamit()->streamit_pmpro_woo_payment_gatway($pmpro_plan_id, $pmpro_product_id);
        wp_redirect($redirect);
        exit;
    }

    if (!empty($trial_period)) {
        echo '<p class="trial-period rounded d-inline-block position-absolute m-0">' .
            esc_html__(sprintf("%d Day(s) Trial", $trial_period), SE_TEXT_DOMAIN) .
            '</p>';
    } ?>

    <?php if (is_plugin_active('paid-memberships-pro/paid-memberships-pro.php') && is_plugin_active("pmpro-woocommerce/pmpro-woocommerce.php")) { ?>
        <?php if (isset($pmpro_level->name) && !empty($pmpro_level->name)) { ?>
            <h5 class="text-center pt-3">
                <?php echo esc_html__("You have selected the ", SE_TEXT_DOMAIN) . esc_html($pmpro_level->name) . esc_html__(" membership level", SE_TEXT_DOMAIN); ?>
            </h5>
        <?php }

        if ($initial_payment != 0) {
            $period         = $pmpro_level->cycle_period;
            $period_number  = $pmpro_level->cycle_number;

            if ($period_number == 0 && $period == "Day") {
                $period_text = esc_html__('Month', "streamit");
            } else {
                if ($period_number > 1) {
                    $period_text = $period_number . ' ' . $period;
                } else {
                    $period_text = ' ' . $period;
                }
            } ?>

            <h5 class="text-center d-block mt-2 mb-3">
                <span class="main-price">
                    <?php echo esc_html($price); ?>
                </span>

                <?php if ($billing_amount !== $initial_payment) {
                    echo '<span class="streamit-billing_amount">';
                    esc_html_e('Now and ', 'streamit');
                    echo esc_html($billing_price);
                    echo '</span>';
                } ?>

                <span class="plan-date-pack">/ <?php echo esc_html($period_text); ?></span>
            </h5>
        <?php }

        if (!empty($expiration_info)) {
            echo '<p class="expiration-info text-center my-2 my-md-5 d-block">' . esc_html("Membership Expires After ", "streamit") . $expiration_info . '</p>';
        }

        if (!empty($pmpro_description)) {
            echo '<p class="expiration-info text-center my-2 my-md-5 d-block">' . esc_html($pmpro_description) . '</p>';
        } ?>

        <div class="payment-wrapper p-3 p-md-5 rounded">
            <h4 class="text-center mb-2"> <?php echo esc_html__("Choose Payment Option", SE_TEXT_DOMAIN) ?></h4>

            <div class="d-flex payment_gateway_wrapper justify-content-center flex-wrap">
                <?php if ($streamit_show_pmp_payment) { ?>
                    <div class="text-center mt-1">
                        <a href="<?php echo esc_url(pmpro_url("checkout", "?level=" . $pmpro_level->id, "https") . $discount_code) ?>" class="btn btn-hover iq-button text-capitalize">
                            <?php echo apply_filters("streamit_pmpro_text", esc_html__("PMP Payment", SE_TEXT_DOMAIN)); ?>
                        </a>
                    </div>
                <?php } ?>

                <?php if ($pmpro_product_id != '') { ?>
                    <form id="iqonic_pmpro_wpg_form" action="<?php echo esc_url($_SERVER['REQUEST_URI']); ?>" method="POST" class="ml-3">
                        <button type="submit" class="btn btn-hover iq-button text-capitalize mt-1 ps-3">
                            <?php echo apply_filters("streamit_pmpro_woo_text", esc_html__("Woocommerce Payment", SE_TEXT_DOMAIN)); ?>
                        </button>
                        <div class="col-xl-12 hover-buttons mt-1">
                            <p class="m-0">
                                <input type="hidden" name="iqonic_pmpro_wpg_nonce" class="btn btn-hover" value="<?php echo wp_create_nonce('iqonic-pmpro-wpg-nonce'); ?>" />
                            </p>
                        </div>
                    </form>
                <?php } ?>
            </div>
        </div>
    <?php }
} else { ?>
    <div class="iq-signup-form logged-in">
        <h4 class="iqonic_header">
            <?php echo esc_html__('You Are Already Logged In', SE_TEXT_DOMAIN); ?>
        </h4>

        <div class="d-flex justify-content-around">
            <?php echo '<div class="text-center"><a href="' . home_url()  . '" class="btn btn-hover iq-button text-center" value="Home">' . esc_html__("Home") . '</a></div>'; ?>
            <?php echo '<div class="text-center"><a href="' . wp_logout_url(home_url())  . '" class="btn btn-hover iq-button text-center" value="Home">' . esc_html__("Log Out") . '</a></div>'; ?>
        </div>
    </div>
<?php
}
