<?php

if (!function_exists('user_post_view_count')) {
    function user_post_view_count($tv_show_id = '')
    {
        set_post_view();

        if ($tv_show_id !== '') {
            $key = 'tv_show_views_count';
            $post_id = $tv_show_id[0];
            $seasons = get_post_meta($post_id, '_seasons');

            if (isset($seasons) && !empty($seasons)) {
                $ep_id = array_column($seasons[0], 'episodes');
                $id = call_user_func_array('array_merge', $ep_id);
                $count = count($id);
                $sum = 0;
                $args = array(
                    'post_type' => 'episode',
                    'post__in' => $id,
                );
                
                $query = new WP_Query($args);
                if ($query->have_posts()) {
                    while ($query->have_posts()) {
                        $query->the_post();
                        $view = get_post_meta(get_the_ID(), 'post_views_count', true);

                        if ($view) {
                            $sum += $view;
                        }
                    }
                    wp_reset_postdata();
                }
                update_post_meta($post_id, $key, ceil($sum / $count));
            }
        }
    }
}

function get_post_view($post_id = NULL)
{
    if (empty($post_id)) $post_id = get_the_ID();
    $count = countFormat(get_post_meta($post_id, 'post_views_count', true));
    if (empty($count))
        return __(' No Views Yet', 'streamit-extensions');
    if (preg_match('/^[a-zA-Z]$/', $count[-1]))
        return sprintf(' %s %s', $count, __("views", 'streamit-extensions'));

    return sprintf(' %s %s', $count, _n("view", "views",  $count, 'streamit-extensions'));
}

function countFormat($num)
{ // Fn Format Counter View No

    if ($num > 1000) {

        $x = round($num);
        $x_number_format = number_format($x);
        $x_array = explode(',', $x_number_format);
        $x_parts = array('K', 'M', 'B', 'T');
        $x_count_parts = count($x_array) - 1;
        $x_display = $x;
        $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
        $x_display .= $x_parts[$x_count_parts - 1];

        return $x_display;
    }

    return $num;
}

function get_tv_show_view()
{
    $count = get_post_meta(get_the_ID(), 'tv_show_views_count', true);

    if (empty($count))
        return __('No Views Yet', 'streamit-extensions');
    if (preg_match('/^[a-zA-Z]$/', $count[-1]))
        return sprintf('%s %s', $count, __("views", 'streamit-extensions'));

    return sprintf('%s %s', $count, _n("view", "views",  $count, 'streamit-extensions'));
}

function set_post_view($increament = true, $start_counter = 0, $post_id = null)
{
    $key = 'post_views_count';
    $post_id = empty($post_id) ? get_the_ID() : $post_id;
    $count = (int) get_post_meta($post_id, $key, true);

    $count = $increament ? $count + 1 : $start_counter; // set val of counter that val is increament or setcounter
    update_post_meta($post_id, $key, $count);
}

function posts_column_views($columns)
{
    if (in_array(get_post_type(), ['movie', 'episode', 'video', 'tv_show']))
        $columns['post_views'] = __('Views', 'streamit-extensions');

    return $columns;
}

function posts_custom_column_views($column)
{
    if (in_array(get_post_type(), ['movie', 'episode', 'video', 'tv_show']))
        if ($column === 'post_views') {
            if (get_post_type() === 'tv_show') {
                echo get_tv_show_view();
            } else {
                echo get_post_view();
            }
        }
}
add_filter('manage_posts_columns', 'posts_column_views');
add_action('manage_posts_custom_column', 'posts_custom_column_views');
