<?php

add_shortcode('iqonic_view_all', 'iqonic_get_view_all');

if (!function_exists('iqonic_get_view_all')) {
    function iqonic_get_view_all($attr)
    {
        $args = shortcode_atts(
            array(
                'style'         => '1',
                'image'         => 'landscape',
                'post_title'    => true
            ),
            $attr
        );

        return iqonic_show_view_all($args);
    }
}

if (!function_exists('iqonic_show_view_all')) {
    function iqonic_show_view_all($args)
    {
        global $streamit_options;

        $title = $genres = $tags = $filter = $post_type = '';

        $style          = (isset($_GET['style']))       ? $_GET['style']        : $args['style'];
        $image_style    = (isset($_GET['image']))       ? $_GET['image']        : $args['image'];
        $show_title     = (isset($_GET['post_title']))  ? $_GET['post_title']   : $args['post_title'];

        $show_title     = ($show_title == "show");

        ob_start();

        if (!empty($_GET['filter'])) {
            $filter = $_GET['filter'];
        }

        $paged = get_query_var('paged') ? get_query_var('paged') : 1;

        $args = array(
            'post_status'       => 'publish',
            'posts_per_page'    => $streamit_options['streamit_post_per_page'],
            'order'             => $streamit_options['streamit_display_order'],
            'paged'             => $paged,
            'fields'            => 'ids',
        );

        if (isset($_GET['type'])) {
            if ($_GET['type'] === 'videos') {
                $post_type = 'video';
            } else if ($_GET['type'] === 'tv_shows') {
                $post_type = 'tv_show';
            } else {
                $post_type = 'movie';
            }
        }

        $args['post_type'] = array('movie', 'tv_show', 'video');

        if (empty($filter) || $filter === 'latest') {
            $args['meta_query'] = array(
                array(
                    'key'     => 'name_upcoming',
                    'value'   => '',
                    'compare' => '=='
                )
            );
        } elseif ($filter === 'upcoming') {
            $args['meta_query'] = array(
                array(
                    'key'     => 'name_upcoming',
                    'value'   => '"yes"',
                    'compare' => 'LIKE'
                )
            );
        }

        if (isset($_GET['title'])) {
            $title = str_replace('_', ' ', $_GET['title']);
        }

        if ($filter === 'most_liked') {
            $args['post__in'] = iq_get_most_liked($post_type);
            $args['orderby'] = 'post__in';
        }
        if ($filter === 'most_viewd') {
            $args['meta_key']          = 'post_views_count';
            $args['orderby']           = 'meta_value_num';
            $args['order']             = 'DESC';
        }
        if ($filter === 'alphabetic') {
            $args['orderby'] = 'title';
            $args['order'] = 'ASC';
        }


        if (isset($_GET['type']) && $_GET['type'] === 'movies') {
            $args['post_type'] = 'movie';
            //Genres
            if (!empty($_GET['genres'])) {
                $genres = $_GET['genres'];


                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'movie_genre',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $genres),
                    ),
                );
            }
            // Tags 
            if (!empty($_GET['tags'])) {
                $tags = $_GET['tags'];
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'movie_tag',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $tags),
                    ),
                );
            }
            if (!empty($genres) && !empty($tags)) {
                $args['tax_query'] = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'movie_genre',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $genres),
                    ),
                    array(
                        'taxonomy' => 'movie_tag',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $tags),
                    ),
                );
            }
        } elseif (isset($_GET['type']) && $_GET['type'] === 'tv_shows') {
            $args['post_type'] = 'tv_show';
            // Genres
            if (!empty($_GET['genres'])) {
                $genres = $_GET['genres'];

                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'tv_show_genre',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $genres),
                    ),
                );
            }

            // Tags 
            if (!empty($_GET['tags'])) {
                $tags = $_GET['tags'];
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'tv_show_tag',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' =>  explode(',', $tags),
                    ),
                );
            }
            if ($genres && $tags) {
                $args['tax_query'] = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'tv_show_genre',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $genres),
                    ),
                    array(
                        'taxonomy' => 'tv_show_tag',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $tags),
                    ),
                );
            }
        } elseif (isset($_GET['type']) && $_GET['type'] === 'videos') {
            $args['post_type'] = 'video';
            // Category
            if (!empty($_GET['genres'])) {
                $genres = $_GET['genres'];
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'video_cat',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $genres),
                    ),
                );
            }

            // Tags 
            if (!empty($_GET['tags'])) {
                $tags = $_GET['tags'];
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'video_tag',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' =>  explode(',', $tags),
                    ),
                );
            }

            if (!empty($genres) && !empty($tags)) {
                $args['tax_query'] = array(
                    'relation' => 'OR',
                    array(
                        'taxonomy' => 'video_cat',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $genres),
                    ),
                    array(
                        'taxonomy' => 'video_tag',
                        'field' => 'slug',
                        'operator' => 'IN',
                        'terms' => explode(',', $tags),
                    ),
                );
            }
        } elseif (isset($_GET['type']) && $_GET['type'] === 'product') {
            $args['post_type'] = 'product';
            $args['orderby'] = 'title';
            $args['order'] = 'ASC';

            if (isset($_GET['p_type']) && $_GET['p_type'] == 'featured_products') {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'terms' => 'featured',
                        'field' => 'name',
                        'operator' => 'IN',
                    ),
                );
                $args['orderby'] = 'date ID';
            } else if (isset($_GET['p_type']) && $_GET['p_type'] == 'recent_products') {
                $args['orderby'] = 'date ID';
                $args['order'] = 'ASC';
            } else if (isset($_GET['p_type']) && $_GET['p_type'] == 'sale_products') {
                $args['order'] = 'ASC';
                $args['orderby'] = 'title';
                $args['post__in'] = wc_get_product_ids_on_sale();
            } else if (isset($_GET['p_type']) && $_GET['p_type'] == 'best_selling_products') {
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_visibility',
                        'field' => 'name',
                        'operator' => 'NOT IN',
                    ),
                );
                $args['orderby'] = 'meta_value_num';
                $args['meta_key'] = 'total_sales';
            } else if (isset($_GET['p_type']) && $_GET['p_type'] == 'top_rated_products') {
                $args['orderby'] = 'meta_value_num';
                $args['meta_key'] = '_wc_average_rating';
            }
            if (isset($_GET['cat'])) {
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_cat',
                    'field' => 'slug',
                    'terms' => explode(',', $_GET['cat']),
                );
            }
        }

        $rand             = rand(10, 100);
        $slider_title     = $view_cat = $view_all = $col = $lazy_load = $ajax_load = '';

        $current_page     = '1';
        $can_be_loaded    = false;
        $thumbnail_size   = $image_style == "landscape" ? "medium_large" : "full";

        $loadmore_btn     = 'viewall-load-btn-' . $rand;

        $is_grid          = true;
        $pagination       = $streamit_options['streamit_display_buttons'];
        $pagination       = ($pagination == "infinite_scroll")  ? "infinite" : $pagination;
        $pagination       = ($pagination == "load_more")        ? "loadmore" : $pagination;
        $pagination       = ($pagination == "pagination")       ? "yes"      : $pagination;

        $post_filter      = $filter;
        $is_ajax_enable   = true;
        $is_badges_enable = true;

        $wp_query           = new \WP_Query($args);

        $post_ids           = $wp_query->posts;
        $count              = $wp_query->post_count;
        $total_pages        = $wp_query->max_num_pages;
        $loading_text       = $streamit_options['streamit_display_loadmore_text_2'];
        $lazy_load          = $is_ajax_enable ? " iqonic-lazy-load-images" : '';
        $loadmore_text      = $streamit_options['streamit_display_loadmore_text'];

        $col = ($style == "2") ? "col-xl-2 col-lg-4 col-md-4 col-sm-6 col-6 wl-child" : "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child";

        if ($is_ajax_enable) {
            $current_page   = '0';
            $can_be_loaded  = true;
            $ajax_load      = 'ajax_load';
            $lazy_load      = " iqonic-lazy-load-images";
        }

        $can_be_loaded      = ($is_ajax_enable || $total_pages > 1) ? true : false;

        $temp_settings = [
            'col'               => $col,
            'style'             => $style,
            'is_grid'           => $is_grid,
            'thumbnail_size'    => $thumbnail_size,
            'is_badges_enable'  => $is_badges_enable,
            'image_style'       => $image_style,
            'is_ajax_enable'    => $is_ajax_enable,
            'lazy_load'         => $lazy_load,
            'show_title'        => $show_title,
        ];

        $settings = [
            'image_style'       => $image_style,
            'play_now_text'     => esc_html__("Play Now", SE_TEXT_DOMAIN),
        ];

        $main_class         = ($style == "2") ? "iq-card-wrapper" : "watchlist-contens";
        wp_enqueue_style("cards-general", STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/css/cards-general.css'); ?>

        <div class="<?php echo esc_attr(($main_class)); ?> streamit-viewall-container iq-ajax-content streamit_view_all_ajax <?php echo esc_attr($lazy_load); ?>" data-options="<?php echo esc_html($pagination); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
            <div class="list-grid list-inline  row p-0 mb-0">
                <?php if (!$is_ajax_enable && $wp_query->have_posts()) {
                    if ($style == '2') :
                        require_once 'viewall_template/viewall-2.php';
                    else :
                        require_once 'viewall_template/viewall-1.php';
                    endif;
                    wp_reset_postdata();
                } else {
                    for ($i = 0; $i < $count; $i++) {
                        if ($style == '2') :
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/ajax_Cards.php';
                        else :
                            require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/General/ajax_Slider.php';
                        endif;
                    }
                } ?>
            </div>

            <?php if ($is_grid && $can_be_loaded && $pagination == 'yes') {
                streamit_get_numbers_pagination($total_pages);
            } elseif ($is_grid && $can_be_loaded && $pagination == 'infinite' && $total_pages > 1) {
                echo '<div class="loader-wheel-container"></div>';
            } ?>
        </div>

        <?php if ($can_be_loaded) { ?>
            <div class=" loader-wheel-container">
                <?php if ($is_grid && $pagination == 'loadmore' && $total_pages > 1) : ?>
                    <div class="<?php echo esc_attr($loadmore_btn); ?>">
                        <div class="btn btn-hover iq-button">
                            <span><?php echo !empty($loadmore_text) ? esc_html($loadmore_text) : '' ?></span>
                        </div>
                    </div>
                <?php endif;

                if ($is_grid && $pagination == "yes") {
                    $current_page  = max(1, get_query_var('paged')) - 1;
                }

                $pagination_args = [
                    'action'            => 'loadmore_viewall',
                    'current_page'      => $current_page,
                    'total_pages'       => $total_pages,
                    'loadmore_btn'      => $loadmore_btn,
                    'loading_text'      => $loading_text,
                    'query_args'        => $args,
                    'temp_settings'     => $temp_settings,
                    'posts_per_page'    => $count,
                    'ajax_load'         => $ajax_load,
                    'is_ajax_enable'    => $is_ajax_enable,
                ];

                streamit_get_pagination_args($pagination_args); ?>
            </div>
<?php
        }

        return ob_get_clean();
    }
}
