<?php

namespace Iqonic\Shortcodes;

use function Streamit\Utility\streamit;
use Streamit\Utility\Helper\Options\Notification;

class Iqonic_Notification
{
    public function __construct()
    {
        add_shortcode("iqonic_notification", [$this, "streamit_notification_info"]);

        add_shortcode("iqonic_notification_all", [$this, "streamit_view_all_notification"]);
    }

    function streamit_notification_info()
    {
        echo '
        <div class="streamit-notification notification-shortcode">
				<a href="javascript:void(0);" class="notification-wrapper">
					<i class="fas fa-bell"></i>
					<span class="notification-count"></span>
				</a>
		</div>';

        new Notification();
    }

    function streamit_view_all_notification()
    {
        ob_start();

        global $streamit_options;

        $guest_user_notification    = $streamit_options['enable_guest_user_notification'] == "yes";

        if (!is_user_logged_in() && $guest_user_notification) {
            $admin_user = get_users(['role' => "administrator"]);
            $user_id    = ($admin_user) ? $admin_user[0]->ID : false;
        } else {
            $user_id = get_current_user_id();
        }

        $notifications  = get_user_meta($user_id, '_streamit_notification', true);
        $post_types     = apply_filters('streamit_notification_post_type', array('movie', 'tv_show', 'video', 'episode'));

        if ($notifications) {
            $newly_added_post_ids = array();
            foreach ($notifications['_streamit_newly_added'] as $key => $value) {
                $newly_added_post_ids[] = $value['post_id'];
            }

            if (!empty($newly_added_post_ids)) {
                $args = array(
                    'post_type'     => $post_types,
                    'post_status'   => 'publish',
                    'posts_per_page' => -1,
                    'post__in'      => $newly_added_post_ids,
                    'order'         => 'DESC',
                    'date_query'    => array(
                        array(
                            'after'     => '15 days ago', // Show posts published after the last 15 days
                            'inclusive' => true,          // Include the posts published on the 15th day ago
                        ),
                    )
                );

                $wp_query = new \WP_Query($args);

                if ($wp_query->have_posts()) { ?>
                    <div class="streamit_notification_wrapper view-all-notification">
                        <div class="notifications_meta_data">
                            <?php while ($wp_query->have_posts()) {
                                $wp_query->the_post();

                                $post_id        = get_the_ID();
                                $post_type      = get_post_type();

                                $thumbnail_id   = get_post_meta($post_id, '_thumbnail_id', true);
                                $run_time       = get_post_meta($post_id, '_' . $post_type . '_run_time', true);

                                $src = $thumbnail_id ? wp_get_attachment_url($thumbnail_id) : get_lazy_load_image(); ?>

                                <div class="notification_post_details">
                                    <div class="img-box">
                                        <a href="<?php echo get_the_permalink() ?>">
                                            <img src="<?php echo esc_attr($src) ?>" alt="<?php echo esc_attr__("img", "streamit") ?>">
                                        </a>
                                    </div>

                                    <div class="meta_data">
                                        <div class="post-name">
                                            <a href="<?php echo get_the_permalink() ?>">
                                                <?php echo get_the_title() ?>
                                            </a>
                                        </div>

                                        <div class="run_time"><?php echo esc_html($run_time) ?></div>

                                        <div class="imdb_rating">
                                            <?php streamit()->streamit_display_imdb_rating($post_id, false) ?>
                                        </div>
                                    </div>
                                </div>
                            <?php
                            } ?>
                        </div>
                    </div>
<?php
                } else {
                    $this->streamit_notification_not_found();
                }
            }
        } else {
            $this->streamit_notification_not_found();
        }

        wp_reset_postdata();
        return ob_get_clean();
    }

    public function streamit_notification_not_found()
    {
        echo
        '<div class="streamit_notification_wrapper notification-close">
            <span class="no_notification"> ' . esc_html__("No Notifications Found", "streamit") . ' </span>
        </div>';
    }
}
