/*------------------------
Banner Slider
--------------------------*/
(function (jQuery) {
    "use strict";
        if (jQuery('.iq-woocommerce-product-slider .products').length > 0) {
            callProductSlider();
        }
})(jQuery);

function callProductSlider() {
    let homebannerSlider = jQuery('.iq-woocommerce-product-slider .products');
    homebannerSlider.addClass('iq-rtl-direction');

    homebannerSlider.each(function () {

        if(jQuery(this).hasClass('slick-slider'))return;
        let jQuerySlider = jQuery(this).parents('.iq-woocommerce-product-slider');

        jQuery(this).slick({
            cssEase: 'ease-in-out',
            lazyLoad: 'progressive',
            slidesToShow: jQuerySlider.data("items"),
            dots: false,
            arrows: jQuerySlider.data("nav"),
            infinite: false,
            speed: jQuerySlider.data("speed"),
            infinite: jQuerySlider.data("infinite"),
            autoplay: jQuerySlider.data("autoplay"),
            autoplaySpeed: jQuerySlider.data("autoplay-speed"),
            nextArrow: '<a href="#" class="slick-arrow slick-next"><i class= "fa fa-chevron-right"></i></a>',
            prevArrow: '<a href="#" class="slick-arrow slick-prev"><i class= "fa fa-chevron-left"></i></a>',
            responsive: [
                {
                    breakpoint: 1366,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-laptop"),
                        infinite: true,
                        dots: false
                    }
                },
                {
                    breakpoint: 1200,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-tab")
                    }
                },
                {
                    breakpoint: 769,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-mobile")
                    }
                },
                {
                    breakpoint: 601,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-mobile-sm")
                    }
                }
            ]
        }).slickAnimation();
        jQuery('.slick-nav').on('click touch', function (e) {

            e.preventDefault();

            let arrow = jQuery(this);

            if (!arrow.hasClass('animate')) {
                arrow.addClass('animate');
                setTimeout(() => {
                    arrow.removeClass('animate');
                }, 1600);
            }

        });
    });
}