(function (jQuery) {
    "use strict";

    jQuery(document).ready(function () {

        jQuery('.iq-movies-tab-similar,.iq-video-tab-similar').one('click', function () {
            var btn = jQuery(this);
            var episode = jQuery(this).data('similar');
            var target = btn.parents('.trending-custom-tab').find('.episodes-contens');
            var data = {
                'action': 'loadmore_similar_movies_videos',
                'data': episode,
                'post_type': jQuery(this).data('type'),
            };

            jQuery.ajax({
                url: streamit_loadmore_params.ajaxurl, // AJAX handler
                data: data,
                type: 'POST',
                beforeSend: function (xhr) {

                },
                success: function (res) {
                    let json_res = JSON.parse(res);
                    if (json_res['success']) {
                        var lenght = 0;
                        jQuery.each(target.find('.owl-item'), function (key, value) {
                            if (typeof json_res['result'][key] === 'undefined') {
                                jQuery(this).remove(); // Remove Extra Loader contain
                                return;
                            }
                            jQuery(this).find('.block-image').append(json_res['result'][key]['block_img']);
                            jQuery(this).find('.block-image').removeClass('skeleton');
                            jQuery(this).find('.block-image').addClass('animate');

                            jQuery(this).find('.episodes-description').append(json_res['result'][key]['block_contnt']);
                            jQuery(this).find('.episodes-description').addClass('animate');

                            length = key + 1;
                        });

                        if (length < json_res['result'].length) { // Condition For Response Pending Content For Append 

                            let carousel = target.find('.owl-carousel-ajax').owlCarousel({
                                loop: false,
                                margin: 20,
                                nav: true,
                                navText: ["<i class='fas fa-angle-left'></i>", "<i class='fas fa-angle-right'></i>"],
                                dots: false,
                                responsive: {
                                    0: {
                                        items: 1
                                    },
                                    500: {
                                        items: 2
                                    },
                                    1000: {
                                        items: 4
                                    }
                                }
                            });

                            for (let index = length; index < json_res['result'].length; index++) { //loop for add Pending response content
                                let a = target.find('.owl-item:last .e-item');
                                const element = json_res['result'][index];

                                carousel.trigger('add.owl.carousel', a.clone()).trigger('refresh.owl.carousel');

                                target.find('.owl-item:last .block-image').empty().append(json_res['result'][index]['block_img']);
                                target.find('.owl-item:last .episodes-description').empty().append(json_res['result'][index]['block_contnt']);
                            }
                        }
                    }
                }
            });

        });
    });
})(jQuery);