/*------------------------
Banner Slider
--------------------------*/
(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        if (jQuery('.iq-topten').length > 0) {
            callVerticleSlider();
        }
    });
})(jQuery);

function callVerticleSlider() {
    let toptenSlider = jQuery('.iq-topten');
    toptenSlider.each(function () {
        var $this = jQuery(this);
        if ($this.find('.top-ten-slider').hasClass('slick-slider')) return false;
        let top_ten_slider = '#' + $this.find('.top-ten-slider').attr('data-rand');
        let top_ten_slider_nav = '#' + $this.find('.top-ten-slider-nav ,.slider-with-navs').attr('data-rand');
        if ($this.hasClass('slider-with-details')) {
            var centerMode = true;
            var arrowParent = $this.find('.topten-contens');
        } else {
            var arrowParent = $this.find('.top-ten-slider-nav , .slider-with-navs');
            var centerMode = false;
        }

        if (jQuery('#iq-topten').hasClass('vertical-slider-2')) {
            var nextArrow_main = '<button class="NextArrow-two"><i class="fas fa-angle-right"></i></button>';
            var prevArrow_main = '<button class="PreArrow-two"><i class="fas fa-angle-left"></i></button>';
        } else {
            var nextArrow_main = '<button class="NextArrow"><i class="fas fa-angle-right"></i></button>';
            var prevArrow_main = '<button class="PreArrow"><i class="fas fa-angle-left"></i></button>';
        }

        jQuery(top_ten_slider).slick({
            slidesToShow: 1,
            arrows: false,
            fade: true,
            asNavFor: top_ten_slider_nav,
            responsive: [{
                breakpoint: 992,
                settings: {
                    asNavFor: false,
                    arrows: true,
                    nextArrow: nextArrow_main,
                    prevArrow: prevArrow_main,
                }
            }]
        });

        if (jQuery('#iq-topten').hasClass('vertical-slider-2')) {
            var nextArrow = '<button class="NextArrow-two"><i class="fas fa-angle-down"></i></button>';
            var prevArrow = '<button class="PreArrow-two"><i class="fas fa-angle-up"></i></button>';
        } else {
            var nextArrow = '<button class="NextArrow"><i class="fas fa-angle-down"></i></button>';
            var prevArrow = '<button class="PreArrow"><i class="fas fa-angle-up"></i></button>';
        }

        jQuery(top_ten_slider_nav).slick({
            slidesToShow: 3,
            asNavFor: top_ten_slider,
            dots: false,
            arrows: true,
            infinite: true,
            vertical: true,
            verticalSwiping: true,
            centerMode: centerMode,
            appendArrows: arrowParent,
            nextArrow: nextArrow,
            prevArrow: prevArrow,
            focusOnSelect: true,
            responsive: [{
                breakpoint: 1200,
                settings: {
                    slidesToShow: 2,
                }
            },
            {
                breakpoint: 992,
                settings: {
                    arrows: false
                }
            },
            {
                breakpoint: 600,
                settings: {
                    asNavFor: false,
                    arrows: false
                }
            },
            ]
        });
    });
}