/*------------------------
Banner Slider
--------------------------*/
(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        var tabSlider = jQuery('.tvshow_tab_new_slider');
        if (tabSlider.length > 0) {
            callTvShowTabNew(tabSlider);
            ajaxChangeSeason();
        }
        TabScroll();
    });
})(jQuery);

function callTvShowTabNew(item) {
    item.each(function () {
        var jQuerySlider = jQuery(this);
        if (jQuerySlider.hasClass('slick-slider')) return;

        jQuerySlider.slick({
            dots: false,
            arrows: jQuerySlider.data("nav"),
            infinite: jQuerySlider.data("loop"),
            speed: jQuerySlider.data("speed"),
            autoplay: false,
            slidesToShow: 1,
            nextArrow: '<button class="NextArrow-two slick-next"><i class="fas fa-angle-right"></i></button>',
            prevArrow: '<button class="PreArrow-two slick-prev"><i class="fas fa-angle-left"></i></button>',
            responsive: [{
                    breakpoint: 1601,
                    settings: {
                        infinite: true,
                        dots: false
                    }
                },
                {
                    breakpoint: 1366,
                    settings: {
                        infinite: true,
                        dots: false
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        arrows: false
                    }
                },
            ]
        });

        var active = jQuerySlider.find(".slick-active");
        var detailWrap = jQuerySlider.parent().find('.streamit-wrap-details');
        var episode_card_text = detailWrap.find('.p-btns').data('episode_card_text');
        active.addClass("current-episode");
        detailWrap.find(".nav-tabs-inner a:first").addClass("active").data('ajax-loaded', true);
        active.data('ajax-loaded', true);

        jQuerySlider.on('afterChange', function (event, slick, currentSlide) {
            var element = jQuerySlider.find("[data-slick-index=" + currentSlide + "]");
            var tvShowId = element.data("post");

            detailWrap.find(".nav-tabs-inner a").removeClass('active');

            if (!element.data("ajax-loaded")) {
                data = {
                    'action': 'tvshow_seasons_data',
                    'tvshow_id': tvShowId,
                    'season_change': true,
                    'season_number': 0,
                    'episode_card_text': episode_card_text,
                };
                ajaxCall(data, element);
            } else {
                detailWrap.find('.season-episodes-details .episodes-info').hide();
                detailWrap.find('.streamit-episodes-meta').hide();

                var $show_seasons = ".tvshow-" + tvShowId;
                var $show_episodes = ".tvshow-" + tvShowId + "-season-1";

                detailWrap.find($show_seasons).first().addClass('active');
                detailWrap.find($show_seasons).show();
                detailWrap.find($show_episodes).show();
            }

        });
    });
}

function ajaxChangeSeason() {
    // season change
    jQuery(document).on("click", '.streamit-episodes-meta', function () {
        var $this = jQuery(this);
        var parent = $this.closest('.streamit-wrap-details');
        var episode_card_text = parent.find('.p-btns').data('episode_card_text');
        var tvShowId = $this.data('tvshow-id');
        var season_number = parseInt($this.data('season'));
        var ajax_loaded = $this.data('ajax-loaded');
        var next_season_number = season_number + 1;
        var $show = ".tvshow-" + tvShowId + "-season-" + next_season_number;

        parent.find('.streamit-episodes-meta').removeClass('active');
        parent.find('.season-episodes-details .episodes-info').hide();
        $this.addClass('active');

        jQuery($show).show();
        if (parent.find('.episodes-info').hasClass('fade-in-anim')) {
            parent.find('.episodes-info').removeClass("fade-in-anim");
        }
        jQuery($show).addClass("fade-in-anim");

        data = {
            'action': 'tvshow_seasons_data',
            'tvshow_id': tvShowId,
            'season_change': false,
            'season_number': season_number,
            'episode_card_text': episode_card_text,
        };

        if (!ajax_loaded)
            ajaxCall(data, $this);
    });
}

function ajaxCall(data, $this) {
    var mainParent = $this.closest(".streamit-tvshow-tab-new");
    jQuery.ajax({
        url: streamit_loadmore_params.ajaxurl, // AJAX handler
        data: data,
        type: 'POST',
        beforeSend: function (xhr) {
            mainParent.find('.season-episodes-details .episodes-info').hide();
            for (i = 0; i < 4; i++) {
                mainParent.find('.season-episodes-details').append('<div class="episodes-info skeleton-box"><div class="skeleton-img skeleton"></div><div class="skeleton-meta"><div class="skeleton-name skeleton"></div><div class="skeleton-time skeleton"></div></div></div>');
            }
        },

        success: function (res) {
            let json_res = JSON.parse(res);
            mainParent.find('.skeleton-box').remove();

            if (json_res.length !== 0) {
                if (json_res[0]['tvshow_id'] !== undefined) {
                    mainParent.find('.nav-tabs-inner .streamit-episodes-meta').hide();
                }

                json_res.forEach(function (value, index) {
                    if (value['season_content'] !== undefined) {
                        mainParent.find('.nav-tabs-inner').append(value['season_content']);
                        mainParent.find('.nav-tabs-inner .tvshow-' + json_res[0]['tvshow_id']).first().addClass('active').data('ajax-loaded', true);
                    }

                    mainParent.find('.season-episodes-details').append(value['block_content']);

                    if (value['button_content'] !== undefined) {
                        mainParent.find('.season-episodes-details').append(value['button_content']);
                    }
                });

                $this.data('ajax-loaded', true);
                mainParent.find('.tvshow-' + json_res[0]['tvshow_id']).first().addClass("active").data('ajax-loaded', true);
            } else {
                mainParent.find('.season-episodes-details').append(("<div class='episodes-info'>No Episodes Found</div>"));
            }
        }
    });
}

function TabScroll() {

    if (jQuery(document).find('.iq-trending-tabs').length > 0) {

        jQuery(document).find('.trending-info  .nav.nav-tabs').each(function (e) {

            const slider = document.querySelector('.nav');
            let isDown = false;
            let startX;
            let scrollLeft;

            slider.addEventListener('mousedown', (e) => {
                isDown = true;
                slider.classList.add('active');
                startX = e.pageX - slider.offsetLeft;
                scrollLeft = slider.scrollLeft;
            });
            slider.addEventListener('mouseleave', () => {
                isDown = false;
                slider.classList.remove('active');
            });
            slider.addEventListener('mouseup', () => {
                isDown = false;
                slider.classList.remove('active');
            });
            slider.addEventListener('mousemove', (e) => {
                if (!isDown) return;
                e.preventDefault();
                const x = e.pageX - slider.offsetLeft;
                const walk = (x - startX) * 3; //scroll-fast
                slider.scrollLeft = scrollLeft - walk;
            });
        });

    }


}