/*------------------------
Banner Slider
--------------------------*/

(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        callSlickSlider(jQuery('.favorites-slider'));
    });
})(jQuery);

// Call Slider Function  
function callSlickSlider(item) {
    item.each(function () {
        var jQuerySlider = jQuery(this);
        if (jQuerySlider.hasClass('slick-slider')) return;
        if (jQuery(this).hasClass('iq-arrow-2')) {
            var nextArrow = '<button class="NextArrow-two"><i class="fas fa-angle-right"></i></button>';
            var prevArrow = '<button class="PreArrow-two"><i class="fas fa-angle-left"></i></button>';
        } else {
            var nextArrow = '<a href="#" class="slick-arrow animated slick-next"><i class= "fa fa-chevron-right"></i></a>';
            var prevArrow = '<a href="#" class="slick-arrow animated slick-prev"><i class= "fa fa-chevron-left"></i></a>';
        }

        jQuerySlider.slick({
            dots: false,
            centerMode: false,
            arrows: jQuerySlider.data("nav"),
            infinite: jQuerySlider.data("loop"),
            speed: jQuerySlider.data("speed"),
            centerPadding: '100px',
            // slidesToScroll: 2,
            autoplay: jQuerySlider.data("autoplay"),
            autoplaySpeed: jQuerySlider.data("autoplay-speed"),
            slidesToShow: jQuerySlider.data("items"),
            nextArrow: nextArrow,
            prevArrow: prevArrow,
            responsive: [{
                    breakpoint: 1601,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-laptop-lg"),
                        infinite: jQuerySlider.data("loop"),
                        dots: false
                    }
                },
                {
                    breakpoint: 1366,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-laptop"),
                        infinite: jQuerySlider.data("loop"),
                        dots: false
                    }
                },
                {
                    breakpoint: 1199,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-tab")
                    }
                },
                {
                    breakpoint: 768,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-mobile")
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        slidesToShow: jQuerySlider.data("items-mobile-sm"),
                        arrows: false
                    }
                },
            ]
        });

        var active = jQuerySlider.find(".slick-active")
        var slideItems = jQuerySlider.find(".slick-track .slide-item,.slick-track .slide-items");
        active.first().addClass("first");
        active.last().addClass("last");

        jQuerySlider.on('afterChange', function (event, slick, currentSlide, nextSlide) {
            var active = jQuerySlider.find(".slick-active");
            slideItems.removeClass("first last");
            active.first().addClass("first");
            active.last().addClass("last");
        });

    });
}