/*------------------------
Banner Slider
--------------------------*/
(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        callBannerSlider(jQuery('.iq-product-banner-slider .product-slider'));
    });
})(jQuery);

function callProductBannerSlider() {
    let productbannerSlider = jQuery('.iq-product-banner-slider');
    productbannerSlider.each(function () {

        if (jQuery(this).hasClass('slick-slider')) return;
        let productslider = '#' + jQuery(this).find('.product-slider').attr('data-rand');
        let jQuerySlider = jQuery(this).find('.product-slider');
        jQuery(productslider).slick({
            cssEase: 'ease-in-out',
            lazyLoad: 'progressive',
            dots: jQuerySlider.data("dots"),
            arrows: jQuerySlider.data("nav"),
            infinite: false,
            speed: jQuerySlider.data("speed"),
            infinite: jQuerySlider.data("infinite"),
            autoplay: jQuerySlider.data("autoplay"),
            autoplaySpeed: jQuerySlider.data("autoplay-speed"),
            prevArrow: '<div class="slick-nav prev-arrow"><i></i><svg><use xlink:href="#circle"></svg></div>',
            nextArrow: '<div class="slick-nav next-arrow"><i></i><svg><use xlink:href="#circle"></svg></div>',
            responsive: [
                {
                    breakpoint: 1024,
                    settings: {
                        dots: true,
                        arrows: false,
                    }
                }
            ]
        }).slickAnimation();
        jQuery('.slick-nav').on('click touch', function (e) {

            e.preventDefault();

            let arrow = jQuery(this);

            if (!arrow.hasClass('animate')) {
                arrow.addClass('animate');
                setTimeout(() => {
                    arrow.removeClass('animate');
                }, 1600);
            }

        });
    });
}