
/*---------------------------------------------------------------------
        Active Class for Pricing Table
   -----------------------------------------------------------------------*/
(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        callPricing();
    });
})(jQuery);

function callPricing() {
    if (jQuery('.iq-pricing-card #my-table').length > 0) {
        let activePlan = jQuery('.iq-pricing-card #my-table').data('active');
        jQuery('.iq-pricing-card #my-table tr .' + activePlan).children().addClass('active');
        let col = jQuery('.iq-pricing-card #my-table tr .' + activePlan).index();
        jQuery(".iq-pricing-card #my-table tr td:nth-child(" + parseInt(col + 1) + ")").addClass('active');
    }
    let actWrap = '.iq-pricing-card-two .iq-price-rate-wrap';
    if (jQuery(actWrap).length > 0) {
        let planLink = jQuery('.iq-pricing-card-two .iq-button.secondary-btn').attr('href');
        jQuery(".iq-pricing-card-two .iq-pricing .table td:nth-child(" + parseInt(jQuery('.iq-pricing-card-two .iq-price-rate-wrap.active').parent().index() + 2) + ")").addClass('active');
        jQuery(document).on('click', actWrap, function () {
            jQuery(actWrap).removeClass('active');
            jQuery(this).addClass('active');
            let col = jQuery(this).parent().index()
            jQuery(".iq-pricing-card-two .iq-pricing .table td").removeClass('active');
            jQuery(".iq-pricing-card-two .iq-pricing .table td:nth-child(" + parseInt(col + 2) + ")").addClass('active');
            let planId = jQuery(this).data('paid-id');
            let discount_code = jQuery(this).find('.iq-pricing-discount').data('discount-code');
            let iq_subcription_link = new URL(planLink);

            iq_subcription_link.searchParams.set('subscription_plan', planId)
            if (discount_code != undefined)
                iq_subcription_link.searchParams.set('discount_code', discount_code)
            else
                iq_subcription_link.searchParams.delete('discount_code')

            jQuery('.iq-pricing-card-two .iq-button.secondary-btn').attr('href', iq_subcription_link.href);

        })
    }

    jQuery(".iq-pricing-card #my-table tr th").on("click", function () {
        jQuery('.iq-pricing-card #my-table tr th').children().removeClass('active');
        jQuery(this).children().addClass('active');
        jQuery(".iq-pricing-card #my-table td").each(function () {
            if (jQuery(this).hasClass('active')) {
                jQuery(this).removeClass('active')
            }
        });
        let col = jQuery(this).index();
        jQuery(".iq-pricing-card #my-table tr td:nth-child(" + parseInt(col + 1) + ")").addClass('active');
    });

    let iq_subcription_btn_text = false;
    let iq_subcription_btn = false;

    if (get_string = jQuery('[name="iq_subcription_btn_text"]').val()) {
        iq_subcription_btn_text = JSON.parse(get_string);
        iq_subcription_btn = jQuery("#iq-subscribe-btn");

        jQuery(".iq-pricing-card-three .iq-price-rate-wrap").on("click tap", function () {
            let price = jQuery(this).find('.iq-actual-price').data('price');
            let period = jQuery(this).find('.iq-period').data('period');
            let discount_code = jQuery(this).find('.iq-pricing-discount').data('discount-code');
            let subcription_id = jQuery(this).data('paid-id');
            if (discount_price = jQuery(this).find('.iq-discount-price').data('discount-price'))
                price = discount_price;

            let str_replace_ob = {
                "{{price}}": price,
                "{{period}}": period,
            }

            jQuery('.iq-pricing-card-three .iq-price-rate-wrap,.iq-price-head').removeClass('active')
            jQuery(this).addClass('active');
            jQuery(this.dataset.target).addClass('active')


            let iq_subcription_link = new URL(jQuery(iq_subcription_btn).attr('href'));
            iq_subcription_link.searchParams.set('subscription_plan', subcription_id)
            if (discount_code != undefined)
                iq_subcription_link.searchParams.set('discount_code', discount_code)
            else
                iq_subcription_link.searchParams.delete('discount_code')

            iq_subcription_btn.attr('href', iq_subcription_link.href)

            iq_subcription_btn.text(price == 0 ? iq_subcription_btn_text['free'] : iq_subcription_btn_text['other'].replace(/(?:{{price}}|{{period}})/gi, matched => {
                return str_replace_ob[matched]
            }));
        });
    }

}