/*------------------------
Banner Slider
--------------------------*/
(function ($) {
    "use strict";
    $(document).ready(function () {
        if ($('.iq-banner-thumb-slider .home-slider').length > 0)
            callBannerThumbSlider($('.iq-banner-thumb-slider .home-slider'), $);
    });
})(jQuery);

function callBannerThumbSlider(item, $) {
    item.each(function () {
        let iq_banner_thumb_slider = $(this);

        let iq_banner_thumb_slider_id = iq_banner_thumb_slider.attr('id');
        let BannerThumbSlider = '#' + iq_banner_thumb_slider_id;

        let bannner_thumb_slider_nav_id = iq_banner_thumb_slider.closest(".iq-main-slider").find('.banner-thumb-slider-nav').data('rand');
        let bannner_thumb_slider_nav = "#" + bannner_thumb_slider_nav_id;

        if (BannerThumbSlider !== undefined) {
            $(BannerThumbSlider).slick({
                cssEase: 'ease-in-out',
                lazyLoad: 'progressive',
                dots: false,
                centerMode: true,
                arrows: false,
                speed: iq_banner_thumb_slider.data("speed"),
                infinite: true,
                autoplay: iq_banner_thumb_slider.data("autoplay"),
                autoplaySpeed: iq_banner_thumb_slider.data("autoplay-speed"),
                asNavFor: bannner_thumb_slider_nav,
                responsive: [{
                    breakpoint: 999,
                    settings: {
                        dots: true,
                    }
                }]
            }).slickAnimation();
        }

        if (bannner_thumb_slider_nav_id !== undefined) {
            $(bannner_thumb_slider_nav).slick({
                slidesToShow: 2,
                slidesToScroll: 1,
                asNavFor: BannerThumbSlider,
                dots: false,
                focusOnSelect: true,
                nextArrow: '<button class="NextArrow-two"><i class="fas fa-angle-right"></i></button>',
                prevArrow: '<button class="PreArrow-two"><i class="fas fa-angle-left"></i></button>',
            });
        }
    });
}