/*------------------------
Banner Slider
--------------------------*/
(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        callInnerBannerSlider(jQuery('.iq-tvshows-slider'));
    })
})(jQuery);

function callInnerBannerSlider(item) {
    item.each(function () {
        let tvshowsslider = '#' + jQuery(this).find('.tvshows-slider').attr('data-rand');
        let jQuerySlider = jQuery(this).find('.tvshows-slider');
        if (jQuerySlider.hasClass('iq-tvshows-slider')) return;
        jQuery(tvshowsslider).slick({
            centerMode: true,
            centerPadding: '200px',
            cssEase: 'ease-in-out',
            speed: jQuerySlider.data("speed"),
            slidesToShow: 1,
            nextArrow: '<button class="NextArrow"><i class="fas fa-angle-right"></i></button>',
            prevArrow: '<button class="PreArrow"><i class="fas fa-angle-left"></i></button>',
            dots: false,
            arrows: jQuerySlider.data("nav"),
            infinite: jQuerySlider.data("infinite"),
            slidesToScroll: 1,
            autoplay: jQuerySlider.data("autoplay"),
            autoplaySpeed: jQuerySlider.data("autoplay-speed"),
            responsive: [
                {
                    breakpoint: 1200,
                    settings: {
                        arrows: false,
                        centerMode: true,
                        centerPadding: '50px',
                        slidesToShow: 1
                    }
                },
                {
                    breakpoint: 991,
                    settings: {
                        arrows: false,
                        centerMode: true,
                        centerPadding: '20px',
                        slidesToShow: 1
                    }
                },
                {
                    breakpoint: 480,
                    settings: {
                        arrows: false,
                        centerMode: true,
                        centerPadding: '20px',
                        slidesToShow: 1
                    }
                }
            ]
        });
    });
}