<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$is_user_logged_in = is_user_logged_in();

if ($settings['woocommerce_login_form'] == 'signup-form') { /* signup form */
    if (!$is_user_logged_in) {
        echo do_shortcode('[iqonic-signup-form]');
    } else {
        esc_html_e('Note: You are already logged in to your account', SE_TEXT_DOMAIN);
    }
} elseif ($settings['woocommerce_login_form'] == 'login-form') { /* login form */
    if ($settings['link_type'] == 'dynamic') {
        $url = get_permalink(get_page_by_path($settings['dynamic_link']));
        $this->add_render_attribute('streamit_class', 'href', esc_url($url));
    } else {
        if ($settings['link']['url']) {
            $url = $settings['link']['url'];
            $this->add_render_attribute('streamit_class', 'href', esc_url($url));

            if ($settings['link']['is_external']) {
                $this->add_render_attribute('streamit_class', 'target', '_blank');
            }

            if ($settings['link']['nofollow']) {
                $this->add_render_attribute('streamit_class', 'rel', 'nofollow');
            }
        }
    }

    $text_string = $settings['button_text_string'];
    $button_text = $settings['button_text'];

    if (!$is_user_logged_in) {
        echo do_shortcode('[iqonic-login-form btn_text_string="' . $text_string . '" button_text="' . $button_text . '" url="' . $url . '" ]');
    } else {
        esc_html_e('Note: You are already logged in to your account', SE_TEXT_DOMAIN);
    }
} elseif ($settings['woocommerce_login_form'] == 'my-account') { /* my account */
    if ($is_user_logged_in) {
        echo do_shortcode('[woocommerce_my_account]');
    } else {
        esc_html_e('Note: You cannot view this page without login to your account', SE_TEXT_DOMAIN);
    }
} elseif ($settings['woocommerce_login_form'] == 'order-tracking') {
    echo do_shortcode('[woocommerce_order_tracking]');
}
