<?php

namespace Iqonic\Elementor\Elements\WoocommerceLogin;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;
class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_woocommerce_login';
    }

    public function get_title()
    {
        return __('Iqonic Woocommerce Login', SE_TEXT_DOMAIN);
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-site-title';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_woocommerce_login',
            [
                'label' => esc_html__('Woocommerce Login', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'woocommerce_login_form',
            [
                'label'      => __('Select option', SE_TEXT_DOMAIN),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'signup-form',
                'options'    => [
                    'signup-form'     => __('Signup Form', SE_TEXT_DOMAIN),
                    'login-form'      => __('Login Form', SE_TEXT_DOMAIN),
                    'my-account'      => __('My Account', SE_TEXT_DOMAIN),
                    'order-tracking'  => __('Order tracking', SE_TEXT_DOMAIN),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_woocommerce_signup',
            [
                'label' => esc_html__('Signup URL', SE_TEXT_DOMAIN),
                'condition' => ['woocommerce_login_form' => 'login-form']
            ]
        );

        $this->add_control(
            'button_text_string',
            [
                'label' => __('Label string', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __("Don't have an account yet?", SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Sign Up', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'link_type',
            [
                'label' => __('Link Type', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::SELECT,
                'default' => 'dynamic',
                'options' => [
                    'dynamic' => __('Dynamic', SE_TEXT_DOMAIN),
                    'custom' => __('Custom', SE_TEXT_DOMAIN),
                ],
            ]
        );

        $this->add_control(
            'dynamic_link',
            [
                'label' => esc_html__('Select Page', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'link_type' => 'dynamic',
                ],
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data("page") : [],
            ]
        );

        $this->add_control(
            'link',
            [
                'label' => __('Link', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('https://your-link.com', SE_TEXT_DOMAIN),
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'link_type' => 'custom',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_order_tracking',
            [
                'label' => __('Order tracking', SE_TEXT_DOMAIN),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'woocommerce_login_form' => 'order-tracking',
                ],
            ]
        );

        $this->add_control(
            'heading_input_field',
            [
                'label' => esc_html__('Input field', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'order_tracking_typography',
                'label' => __('Typography', SE_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .woocommerce-form-track-order input::placeholder',
            ]
        );

        $this->add_control(
            'order_tracking_color',
            [
                'label' => __('Color', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-form-track-order input::placeholder ' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_button',
            [
                'label' => esc_html__('Button', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'order_button_typography',
                'label' => __('Typography', SE_TEXT_DOMAIN),
                'selector' => '{{WRAPPER}} .woocommerce-form-track-order button.button',
            ]
        );

        $this->add_control(
            'order_button_color',
            [
                'label' => __('Color', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-form-track-order button.button .streamit-btn-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'order_button_background',
            [
                'label' => __('Background Color', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-form-track-order button.buttons' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
    }
}
