<?php

namespace Iqonic\Elementor\Elements\Watchlist;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'Iq_Watchlist';
    }

    public function get_title()
    {
        return esc_html__('WatchList', SE_TEXT_DOMAIN);
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-video-playlist';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_watchlist',
            [
                'label' => esc_html__('WatchList', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'watchlist_style',
            [
                'label'     => esc_html__('WatchList Style', SE_TEXT_DOMAIN),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'tiles',
                'options'   => [
                    'tiles' => esc_html__('Tiles', SE_TEXT_DOMAIN),
                    'cards' => esc_html__('Cards', SE_TEXT_DOMAIN),
                ],
            ]
        );

        $this->add_control(
            'image_style',
            [
                'label'     => esc_html__('Image Style', SE_TEXT_DOMAIN),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'portrait',
                'options'   => [
                    'landscape' => esc_html__('Landscape', SE_TEXT_DOMAIN),
                    'portrait'  => esc_html__('Portrait', SE_TEXT_DOMAIN),
                ],
                'condition' => [
                    'watchlist_style' => 'cards'
                ]
            ]
        );

        $this->add_control(
            'show_title',
            [
                'label'         => __('Show Title', SE_TEXT_DOMAIN),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => __('Yes', SE_TEXT_DOMAIN),
                'label_off'     => __('No', SE_TEXT_DOMAIN),
                'return_value'  => 'show',
                'default'       => 'show',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
    }
}
