<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$id_int = rand(10, 100);
$args = $tax_query = array();

$settings                   = $this->get_settings();
$display_logo               = $settings['view_logo'] == "block";
$display_view               = $settings['show_view'] == "block";
$display_tag                = $settings['view_all_tag'] == "block";
$display_genre              = $settings['view_all_genres'] == "block";
$settings['show_no_videos'] = $settings['show_no_videos'] == 0 ? 10 : $settings['show_no_videos'];
$lazy_load                  = $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";


$args = array(
    'post_type'         => 'video',
    'fields'            => 'ids',
    'post_status'       => 'publish',
    'posts_per_page'    => $settings['show_no_videos'],
    'meta_key'          => 'post_views_count',
    'orderby'           => 'meta_value_num',
    'order'             => 'DESC',
    'meta_query'         => array(
        array(
            'key'     => 'name_upcoming',
            'value'   => '',
            'compare' => '=='
        )
    ),
);

$posts = get_posts($args);

if (count($posts) < 6) {
    $args2 = array(
        'post_type'         => 'video',
        'fields'            => 'ids',
        'post_status'       => 'publish',
        'posts_per_page'    => $settings['show_no_videos'],
        'order'             => 'DESC'
    );

    $wp_query2 = get_posts($args2);

    $allTheIDs  = array_merge($posts, $wp_query2);
    $id         = array_unique($allTheIDs);

    $args3 = array(
        'post_type'         => 'video',
        'fields'            => 'ids',
        'post__in'          => $allTheIDs,
        'post_status'       => 'publish',
        'posts_per_page'    => $settings['show_no_videos'],
        'order'             => 'DESC'
    );
    $posts = get_posts($args3);
} ?>

<div id="iq-trending" class="s-margin iq-videos-tabs iq-rtl-direction iq-trending-tabs <?php echo esc_attr($lazy_load) ?>">
    <?php if (isset($settings['show_title']) && $settings['show_title'] == 'yes') { ?>
        <div class="iq-main-header d-flex align-items-center justify-content-between">
            <h4 class="main-title">
                <?php if (!empty($settings['title_text'])) {
                    echo esc_attr($settings['title_text'], 'streamit-extensions');
                } else {
                    echo __('Trending', 'streamit-extensions');
                } ?>
            </h4>
        </div>
    <?php } ?>

    <div class="trending-contens">
        <ul id="<?php echo esc_attr('trending-slider-nav-' . $id_int); ?>" data-rand="<?php echo esc_attr('trending-slider-nav-' . $id_int); ?>" class="trending-slider-nav list-inline p-0 mb-0 row align-items-center">
            <?php foreach ($posts as $post) {

                $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post), "large")[0];
                $image_alt = esc_attr__('image', ' streamit-extensions');

                if (!empty($lazy_load)) {
                    $img_class = ' iqonic-lazy';
                    $lazy_image = get_lazy_load_image();

                    $original_image = $full_image;
                    $full_image     = $lazy_image;
                    $srcset         = "data-srcset=" . $original_image . "";
                } else {
                    $srcset = '';
                    $img_class = '';
                } ?>

                <li>
                    <a href="javascript:void(0);">
                        <div class="video-slick position-relative">
                            <img src="<?php echo esc_url($full_image) ?>" <?php echo esc_attr($srcset); ?> class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo $image_alt; ?>">
                        </div>
                    </a>
                </li>
            <?php } ?>
        </ul>

        <ul id="<?php echo esc_attr('trending-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('trending-slider-' . $id_int); ?>" class="trending-slider list-inline p-0 m-0  d-flex align-items-center">
            <?php $i = 1;
            foreach ($posts as $post) {
                $meta       = get_post_meta($post);
                $year       = get_the_date('M Y', $post);
                $run_time   = $meta['_video_run_time'][0];

                $post_image 	= get_the_post_thumbnail_url($post);
				if (!empty($lazy_load)) {
					$img_class = ' iqonic-lazy';
					$lazy_image = get_lazy_load_image();

					$original_image = $post_image;
					$post_image 	= $lazy_image;
					$srcset 		= "data-srcset=" . $original_image . "";
				} else {
					$srcset = '';
					$img_class = '';
				}

                if ($display_genre) {
                    $wp_object = wp_get_post_terms($post, 'video_cat');
                    if (!empty($wp_object)) {
                        $k = 1;
                        foreach ($wp_object as $val) {
                            if ($settings['show_no_genres'] == -1 || $settings['show_no_genres'] >= $k) {

                                if ($k == 1)
                                    $genre = '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                                else
                                    $genre .= ', ' . '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                                $k++;
                            }
                        }
                    }
                }

                if ($display_tag) {
                    $wp_object = wp_get_post_terms($post, 'video_tag');
                    if (!empty($wp_object)) {
                        $l = 1;
                        foreach ($wp_object as $val) {
                            if ($settings['show_no_tags'] == -1 || $settings['show_no_tags'] >= $l) {
                                if ($l == 1)
                                    $tag = '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                                else
                                    $tag .= ', ' . '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
                                $l++;
                            }
                        }
                    }
                } ?>

                <li>
                    <div class="tranding-block position-relative iqonic-lazy" style="background-image: url(<?php echo esc_url($post_image) ?>);" <?php echo esc_attr($srcset); ?>>
                        <div class="trending-custom-tab">
                            <div class="tab-title-info position-relative">
                                <ul class="trending-pills d-flex nav nav-pills justify-content-center align-items-center text-center" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-toggle="pill" href="#overview_<?php echo esc_attr($i . $id_int); ?>" role="tab" aria-selected="true">
                                            <?php if (!empty($settings['tab_text_overview'])) {
                                                echo esc_attr($settings['tab_text_overview']);
                                            } else {
                                                echo esc_html__('Overview', SE_TEXT_DOMAIN);
                                            } ?>
                                        </a>
                                    </li>

                                    <li class="nav-item">
                                        <a class="nav-link iq-video-tab-similar" data-toggle="pill" href="#similar_<?php echo esc_attr($i . $id_int); ?>" role="tab" aria-selected="false" data-similar='<?php echo json_encode(wp_get_post_terms($post, 'video_cat')) ?>' data-type="<?php echo esc_attr(get_post_type($post)) ?>">
                                            <?php if (!empty($settings['tab_text_similar'])) {
                                                echo esc_attr($settings['tab_text_similar']);
                                            } else {
                                                echo esc_html__('Similar Like This', SE_TEXT_DOMAIN);
                                            } ?>
                                        </a>
                                    </li>
                                </ul>
                            </div>

                            <div class="trending-content tab-content">
                                <div id="overview_<?php echo esc_attr($i . $id_int); ?>" class="overview-tab tab-pane fade active show">
                                    <div class="trending-info align-items-center w-100 animated fadeInUp">
                                        <?php if ($display_logo) { ?>
                                            <a href="javascript:void(0);" tabindex="0">
                                                <div class="res-logo">
                                                    <div class="channel-logo">
                                                        <?php echo wp_get_attachment_image($meta['name_logo'][0], 'full', false, ['class' => 'c-logo']); ?>
                                                    </div>
                                                </div>
                                            </a>
                                        <?php } ?>

                                        <h1 class="trending-text big-title text-uppercase"><?php echo get_the_title($post); ?></h1>

                                        <div class="d-flex align-items-center text-detail mb-4">
                                            <span class="badge badge-secondary p-1 mr-2">
                                                <?php if (function_exists('set_post_view')) {
                                                    echo '<i class="fa fa-eye"></i>';
                                                    if (get_post_view($post) == 0) {
                                                        echo esc_html__('0 Views', SE_TEXT_DOMAIN);
                                                    } else {
                                                        echo get_post_view($post);
                                                    };
                                                } ?>
                                            </span>
                                            <span><?php echo esc_html($run_time); ?></span>
                                            <span class="trending-year"><?php echo esc_html($year); ?></span>
                                        </div>


                                        <div class="d-flex align-items-center series mb-4">
											<?php if (!empty($settings['trending_top_img']['url'])) {?>
												<img src="<?php echo esc_url($settings['trending_top_img']['url']) ?>"
													class="img-fluid" alt="<?php echo esc_attr($top_trend_alt); ?>">
											<?php } ?>
											<span class="text-gold ml-3">#
												<?php
												echo esc_html($i);
												echo esc_html__(' in Videos Today', SE_TEXT_DOMAIN);
												?>
											</span>
										</div>

                                        <div class="trending-dec mb-4">
                                            <?php $excerpt = get_the_excerpt($post);
                                            if (!empty($excerpt)) {
                                                $iq_remove_tags = array("<p>", "</p>");
                                                $iq_excerpt = str_replace($iq_remove_tags, "", $excerpt);
                                                echo __($iq_excerpt, SE_TEXT_DOMAIN);
                                            } ?>
                                        </div>

                                        <div class="p-btns">
                                            <div class="d-flex align-items-center p-0">
                                                <a href="<?php echo the_permalink($post); ?>" class="btn btn-hover iq-button mr-2" tabindex="0"><i class="fa fa-play mr-2" aria-hidden="true"></i><?php echo esc_html_x('Play Now', 'video-tab', SE_TEXT_DOMAIN); ?></a>
                                            </div>
                                        </div>

                                        <div class="trending-list mt-4">
                                            <?php if (!empty($genre)) { ?><div class="text-primary title genres"><?php echo esc_html__('Categories:', SE_TEXT_DOMAIN); ?> <span class="text-body"><?php echo rtrim($genre, ","); ?></span>
                                                </div><?php } ?>
                                            <?php if (!empty($tag)) { ?><div class="text-primary title tag"><?php echo esc_html__('Tag:', SE_TEXT_DOMAIN); ?> <span class="text-body"><?php echo rtrim($tag, ","); ?></span>
                                                </div> <?php } ?>
                                        </div>
                                    </div>
                                </div>

                                <?php if (!empty($genre)) { ?>
                                    <div id="similar_<?php echo esc_attr($i . $id_int); ?>" class="overlay-tab tab-pane fade">
                                        <div class="trending-info align-items-center w-100 animated fadeInUp">
                                            <div class="episodes-contens iq-rtl-direction">
                                                <div class="owl-carousel-ajax episodes-slider1  owl-carousel owl-theme  list-inline p-0 mb-0 ajax-owl-load   active show" data-display="<?php echo esc_attr('0', 'streamit-extensions') ?>">
                                                    <?php for ($x = 0; $x < 4; $x++) { ?>
                                                        <div class="e-item animated fadeInUp ajax	">
                                                            <div class="block-image position-relative card-img skeleton"></div>
                                                            <div class="episodes-description text-body iq-ltr-direction card-body"></div>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </li>
            <?php $i++;
            } ?>
        </ul>
    </div>
</div>