<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$rand 				= rand(10, 100);
$slider_title 		= $view_cat = $view_all = $col = $lazy_load = $ajax_load = '';
$args = $tax_query 	= $taxargs = array();

$current_page 	= '1';
$can_be_loaded 	= false;
$post_type 		= 'video';
$loadmore_btn = "video-load-btn-" . $rand;

$settings 				= $this->get_settings();

$is_grid 				= $settings['slider_type'] == 'grid';
$options_streamit_load 	= $is_grid ? $settings['pagination'] : "";

$post_filter			= $settings['post_view_type'];
$is_ajax_enable			= $settings['enable_ajax'] == "yes";
$paged 					= (get_query_var('paged')) ? get_query_var('paged') : 1;

if (isset($settings['slider_title'])) {
	$slider_title = $settings['slider_title'];
	$slider_title_key  = str_replace(" ", "_", $slider_title);

	$title_option = $slider_title_key;
	if (!get_option($title_option)) {
		update_option($title_option, $slider_title);
	}
	$view_cat = '&title=' . $title_option;
}

if (!empty($settings['iq_video_genre'])) {
	$tax_query['taxonomy'] 	= 'video_cat';
	$tax_query['field'] 	= 'slug';
	$tax_query['terms'] 	= $settings['iq_video_genre'];
	$tax_query['operator'] 	= 'IN';
	$option_value 			= implode(',', $settings['iq_video_genre']);
	$view_cat 				.= '&categories=' . $option_value;
	array_push($taxargs, $tax_query);
}

if (!empty($settings['iq_video_tag'])) {
	$tax_query['taxonomy'] 	= 'video_tag';
	$tax_query['field'] 	= 'slug';
	$tax_query['terms'] 	= $settings['iq_video_tag'];
	$tax_query['operator'] 	= 'IN';
	$option_value 			= implode(',', $settings['iq_video_tag']);
	$view_cat 				.= '&tags=' . $option_value;
	array_push($taxargs, $tax_query);
}

if (!empty($settings['post_view_type']) && $settings['post_view_type'] !== 'none') {
	$view_cat .= '&filter=' . $settings['post_view_type'];
}

if ($settings['view_all_switch'] === 'yes') {
	$this->add_render_attribute('iq_class', 'class', 'iq-view-all');
	if ($settings['use_custom_link_viewall'] == 'yes') {
		if ($settings['view_all_custom_link']['url']) {
			$url = $settings['view_all_custom_link']['url'];
			$this->add_render_attribute('iq_class', 'href', esc_url($url));

			if ($settings['view_all_custom_link']['is_external']) {
				$this->add_render_attribute('iq_class', 'target', '_blank');
			}

			if ($settings['view_all_custom_link']['nofollow']) {
				$this->add_render_attribute('iq_class', 'rel', 'nofollow');
			}
		}
		$view_all_text = esc_html($settings['use_custom_link_text']);
		$view_all = '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
	} else {
		$view_all_text 			= $streamit_options['streamit_viewall_text'];
		$settings['show_title'] = $settings['show_title'] == "yes" ? "show" : "hide";
		$view_all 				= '<a class="iq-view-all" href="' . esc_url(get_page_link($streamit_options['streamit_viewall_link'])) . '?type=videos' . esc_attr($view_cat) . '?show_title=' . $settings['show_title'] . '">' . esc_html($view_all_text) . '</a>';
	}
}

$args = array(
	'post_type'         => 'video',
	'post_status'       => 'publish',
	'paged' 			=> $paged,
	'posts_per_page' 	=> $settings['posts_per_page']['size'],
	"suppress_filters"	=> true,
	'fields'			=> 'ids'
);

if (!empty($settings['iq_select_videos'])) {
	$args['post__in'] = $settings['iq_select_videos'];
}

if (empty($settings['iq_select_videos']) && $settings['post_view_type'] === 'most_liked') {
	$args['post__in'] = iq_get_most_liked('video');
	$args['orderby'] = 'post__in';
}

if (empty($settings['iq_select_movies']) && $settings['post_view_type'] === 'most_viewd') {
	$args['meta_key']          = 'post_views_count';
	$args['orderby']           = 'meta_value_num';
	$args['order']             = 'DESC';
}

if (!empty($settings['post_view_type']) && $settings['post_view_type'] !== 'none') {
	if ($settings['post_view_type'] === 'latest') {
		$args['orderby'] = 'publish_date';
		$args['order'] = 'DESC';
	}
}

if (!empty($settings['order']) && $settings['post_view_type'] === 'none') {
	$args['order'] = $settings['order'];
}

if (!empty($settings['order']) && $settings['post_view_type'] === 'upcoming') {
	$args['order'] = $settings['order'];
	$args['meta_query'] = array(
		array(
			'key'     => 'name_upcoming',
			'value'   => '"yes"',
			'compare' => 'LIKE'
		)
	);
} else {
	$args['meta_query'] = array(
		array(
			'key'     => 'name_upcoming',
			'value'   => '',
			'compare' => '=='
		)
	);
}

if (!empty($settings['order']) && $settings['post_view_type'] === 'alphabetic') {
	$args['orderby'] = 'title';
	$args['order'] = $settings['order'];
}

if (!empty($taxargs)) {
	$args['tax_query'] = $taxargs;
	$args['tax_query']['relation'] = 'OR';
}

$wp_query 		= new \WP_Query($args);

$post_ids		= $wp_query->posts;
$count 			= $wp_query->post_count;
$total_pages 	= $wp_query->max_num_pages;

if ($is_ajax_enable) {
	$current_page 	= '0';
	$can_be_loaded 	= true;
	$ajax_load 		= 'ajax_load';
	$lazy_load 		= " iqonic-lazy-load-images";
}

if (!$is_grid) {
	$col 			= '';
	$is_grid 		=  false;
	$thumbnail_size = "full";
	$align 			= 'favorites-slider';

	if (isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == 'style-2') {
		$align .= ' iq-arrow-2';
	}

	$this->add_render_attribute('slider', 'data-nav', 				$settings['nav-arrow']);
	$this->add_render_attribute('slider', 'data-items', 			$settings['desk_number']);
	$this->add_render_attribute('slider', 'data-items-laptop', 		$settings['lap_number']);
	$this->add_render_attribute('slider', 'data-items-tab', 		$settings['tab_number']);
	$this->add_render_attribute('slider', 'data-items-mobile', 		$settings['mob_number']);
	$this->add_render_attribute('slider', 'data-items-mobile-sm', 	$settings['mob_number']);
	$this->add_render_attribute('slider', 'data-autoplay', 			$settings['autoplay']);
	$this->add_render_attribute('slider', 'data-autoplay-speed', 	$settings['autoplay_speed']);
	$this->add_render_attribute('slider', 'data-infinite', 			$settings['infinite']);
	$this->add_render_attribute('slider', 'data-speed', 			$settings['speed']);
} else {
	$align = 'favorites-grid';

	$grid_style = [
		'1' => ["col" => "col-12 wl-child", "img_size" => "full"],
		'2' => ["col" => "col-lg-6 col-md-6 col-sm-6 wl-child", "img_size" => "large"],
		'3' => ["col" => "col-lg-4 col-md-4 col-sm-6 wl-child", "img_size" => "medium_large"],
		'4' => ["col" => "col-xl-3 col-lg-4 col-md-4 col-sm-6 col-6 wl-child", "img_size" => "medium_large"],
	];

	$can_be_loaded 	= ($is_ajax_enable || $total_pages > 1) ? true : false;
	$col 			= $grid_style[$settings['video_grid_style']]['col'];
	$thumbnail_size = $grid_style[$settings['video_grid_style']]["img_size"];
}

$temp_settings = [
	'col'				=> $col,
	'is_grid'			=> $is_grid,
	'thumbnail_size'	=> $thumbnail_size,
	'play_now_text'		=> $settings['play_now_text'],
	'is_ajax_enable'	=> $is_ajax_enable,
	'lazy_load'			=> $lazy_load,
]; ?>

<div class="iq-ajax-content favorites-contens watchlist-contens iq-rtl-direction streamit_datapass_video <?php echo esc_attr($lazy_load); ?> " data-options="<?php echo esc_html($options_streamit_load); ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded) ?>">

	<?php if (!empty($post_ids)) :
		$title_tag = 'h4';
		echo streamit_get_shortcode_title($slider_title, $title_tag, $view_all); ?>
	<?php endif; ?>

	<ul class="<?php echo esc_attr($align); ?> list-grid list-inline row p-0 mb-0 iq-rtl-direction" <?php echo $this->get_render_attribute_string('slider'); ?>>
		<?php if (!$is_ajax_enable && $wp_query->have_posts()) {
			foreach ($post_ids as $post_id) {
				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
			}
			wp_reset_postdata();
		} else {
			for ($i = 0; $i < $count; $i++) {
				require trailingslashit(STREAMIT_EXTENSION_PLUGIN_PATH) . 'includes/Elementor/Elements/General/ajax_Slider.php';
			}
		} ?>
	</ul>

	<?php if ($is_grid && $settings['pagination'] == 'yes') {
		streamit_get_numbers_pagination($total_pages);
	} elseif ($is_grid && $settings['pagination'] == 'infinite' && $total_pages > 1) {
		echo '<div class="loader-wheel-container"></div>';
	} ?>
</div>

<?php if ($can_be_loaded) { ?>
	<div class="loader-wheel-container">
		<?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) { ?>
			<div class="<?php echo esc_attr($loadmore_btn); ?>">
				<div class="btn btn-hover iq-button">
					<span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
				</div>
			</div>
		<?php }

		if ($is_grid && $settings['pagination'] == "yes") {
			$current_page  = max(1, get_query_var('paged')) - 1;
		}

		$pagination_args = [
			'action' 			=> 'video_slider',
			'current_page'		=> $current_page,
			'total_pages'		=> $total_pages,
			'loadmore_btn'		=> $loadmore_btn,
			'loading_text'		=> $settings['loading_text'],
			'query_args'		=> $args,
			'temp_settings'		=> $temp_settings,
			'posts_per_page' 	=> $count,
			'ajax_load'			=> $ajax_load,
			'is_ajax_enable'	=> $is_ajax_enable,
		];

		streamit_get_pagination_args($pagination_args); ?>
	</div>
<?php
}
