<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$image_html = $video_url = $icon = '';

$settings = $this->get_settings_for_display();

if ($settings['video_type'] == 'hosted') {
	$video_url = $settings['hosted_url']['url'];
}
if ($settings['video_type'] == 'video_link') {
	$video_url = $settings['link_url'];
}

if ($settings['media_style'] == 'image') {
	if ('' !== $settings['hover_animation']) {
		$image_html = 'elementor-animation-' . $settings['hover_animation'];
	}
	$icon = '<img class="hover-img ' . esc_html($image_html) . '" src="' . esc_url($settings['image_icon']['url']) . '" alt="fancybox">';
}
if ($settings['media_style'] == 'icon') {
	ob_start();
	\Elementor\Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
	$icon = ob_get_clean();
} ?>

<div class="streamit-popup-video <?php esc_attr_e($settings['pop_video_style']) ?>">
	<div class="<?php isset($settings['iq_bg_image']['url']) && !empty($settings['iq_bg_image']['url']) ? esc_attr_e('streamit-video-img', 'streamit-extensions') : '' ?> position-relative">
		<div class="streamit-video-icon FadeIn">
			<?php if ($settings['pop_video_style'] == 'style-one') { ?>
				<a href="<?php echo esc_url($video_url); ?>" class="streamit-video popup-youtube video-open">
					<?php echo $icon; ?>
				</a>
				<div class="streamit-waves">
					<div class="waves"></div>
				</div>
			<?php } else { ?>
				<a class="streamit-video-wrapper  video-open playbtn" href="<?php echo esc_url($video_url); ?>">
					<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="80px" viewBox="0 0 213.7 213.7" enable-background="new 0 0 213.7 213.7" xml:space="preserve">
						<polygon class='triangle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="73.5,62.5 148.5,105.8 73.5,149.1 " />
						<circle class='circle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" cx="106.8" cy="106.8" r="103.3" />
					</svg>
					<?php if ($settings['show_popup_text'] == 'yes') { ?>
						<span class="video-text"><?php echo $settings['popup_text'] ?></span>
					<?php } ?>
				</a>
			<?php } ?>
			<?php if (isset($settings['iq_bg_image']['url']) && !empty($settings['iq_bg_image']['url'])) { ?>
				<img class="hover-img w-100" src="<?php echo esc_url($settings['iq_bg_image']['url']); ?>" alt="image">
			<?php } ?>
		</div>
	</div>
</div>