<?php

namespace Iqonic\Elementor\Elements\VideoPopup;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic-VideoPopup';
    }

    public function get_title()
    {
        return esc_html__('Popup Video', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-video-camera';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section',
            [
                'label' => esc_html__('Popup Video', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'pop_video_style',
            [
                'label' => esc_html__('Popup Video Style', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-one',
                'options' => [
                    'style-one' => esc_html__('Style 1', 'streamit-extensions'),
                    'style-two' => esc_html__('Style 2', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'video_type',
            [
                'label' => esc_html__('Source', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'video_link',
                'options' => [
                    'video_link' => esc_html__('Link', 'streamit-extensions'),
                    'hosted' => esc_html__('Self Hosted', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'hosted_url',
            [
                'label' => esc_html__('Choose File', 'streamit-extensions'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'value' => 'fas fa-star',
                ],

                'media_type' => 'video',
                'condition' => [
                    'video_type' => 'hosted',
                ],
            ]
        );

        $this->add_control(
            'link_url',
            [
                'label' => esc_html__('Link', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter your URL', 'streamit-extensions'),
                'default' => esc_html__('https://www.youtube.com/watch?v=XHOmBV4js_E' . 'streamit-extensions'),
                'label_block' => true,
                'condition' => [
                    'video_type' => 'video_link',
                ],
            ]
        );

        $this->add_control(
            'show_popup_text',
            [
                'label' => esc_html__('Show Text', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'streamit-extensions'),
                'label_off' => esc_html__('Hide', 'streamit-extensions'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['pop_video_style' => 'style-two']
            ]
        );

        $this->add_control(
            'popup_text',
            [
                'label' => esc_html__('Text', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter Text', 'streamit-extensions'),
                'condition' => ['show_popup_text' => 'yes']
            ]
        );

        $this->add_control(
            'media_style',
            [
                'label'      => esc_html__('Select Style', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'none',
                'options'    => [
                    'icon'   => esc_html__('Icon', 'streamit-extensions'),
                    'image'  => esc_html__('Image', 'streamit-extensions'),
                    'none'   => esc_html__('none', 'streamit-extensions'),
                ],
                'condition' => ['pop_video_style' => 'style-one']
            ]
        );

        $this->add_control(
            'image_icon',
            [
                'label' => esc_html__('Choose Image', 'streamit-extensions'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'media_style'       => 'image',
                    'pop_video_style'   => 'style-one'
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => esc_html__('Play Icon', 'streamit-extensions'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star'

                ],
                'skin' => 'inline',
                'label_block' => false,
                'condition' => [
                    'media_style'       => 'icon',
                    'pop_video_style'   => 'style-one'
                ],
            ]
        );

        $this->add_control(
            'iq_bg_image',
            [
                'label' => esc_html__('Background Image', 'streamit-extensions'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_NZk6cbrofHfRt2C5bJS9',
            [
                'label' => esc_html__('Icon', 'streamit-extensions'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'media_style'       => 'icon',
                    'pop_video_style'   => 'style-one'
                ],
            ]
        );

        $this->add_control(
            'icon_back_color',
            [
                'label' => esc_html__('Icon Box Background Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'alpha' => true,
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video .streamit-video-icon .streamit-video,.streamit-popup-video .streamit-video-icon .streamit-waves .waves' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video .streamit-video-icon i' => 'color: {{VALUE}};', '{{WRAPPER}} .streamit-popup-video .streamit-video-icon svg path' => 'fill:{{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'streamit_icon_size',
            [
                'label' => esc_html__('Icon Size', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video .streamit-video-icon .streamit-video i,.streamit-popup-video .streamit-video-icon .streamit-video svg' => 'font-size: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'streamit_icon_width',
            [
                'label' => esc_html__('Width', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-video' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'streamit_icon_height',
            [
                'label' => esc_html__('Height', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-video' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__('Border Radius', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}}  .streamit-popup-video .streamit-video-icon .streamit-video' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'section_wave_style',
            [
                'label' => esc_html__('Wave', 'streamit-extensions'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'pop_video_style'   => 'style-one'
                ],
            ]
        );

        $this->add_control(
            'wave_color',
            [
                'label' => esc_html__('Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video .streamit-video-icon .waves::after,{{WRAPPER}} .streamit-popup-video .streamit-video-icon .waves::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'wave_radius',
            [
                'label' => esc_html__('Radius', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}}  .streamit-popup-video .streamit-video-icon .waves::after,{{WRAPPER}} .streamit-popup-video .streamit-video-icon .waves::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_NZk6cbrofHt2C5bJS9',
            [
                'label' => esc_html__('Image', 'streamit-extensions'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('image_effects');
        $this->start_controls_tab(
            'normal',
            [
                'label' => esc_html__('Normal', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'opacity',
            [
                'label' => esc_html__('Opacity', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters',
                'selector' => '{{WRAPPER}} .streamit-popup-video img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'hover',
            [
                'label' => esc_html__('Hover', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'opacity_hover',
            [
                'label' => esc_html__('Opacity', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .streamit-popup-video:hover img',
            ]
        );

        $this->add_control(
            'background_hover_transition',
            [
                'label' => esc_html__('Transition Duration', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video img' => 'transition-duration: {{SIZE}}s',
                ],
                'condition' => [
                    'media_style' => 'image',
                ],
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__('Hover Animation', 'streamit-extensions'),
                'type' => Controls_Manager::HOVER_ANIMATION,
                'condition' => [
                    'media_style' => 'image',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .streamit-popup-video img',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => esc_html__('Border Radius', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .streamit-popup-video img',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_caption',
            [
                'label' => esc_html__('Caption', SE_TEXT_DOMAIN),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'caption_space',
            [
                'label' => esc_html__('Spacing', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-popup-video img' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
    }
}
