<?php

use function Streamit\Utility\streamit;

foreach ($post_ids as $post_id) {

	$img_class 	= "img-fluid w-100";
	$meta 		= get_post_meta($post_id);
	$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "full");
	$full_image = !empty($full_image) ? $full_image[0] : STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/img/placeholder_genre.jpg';

	if (!empty($lazy_load)) {
		$img_class .= ' iqonic-lazy';
		$lazy_image = get_lazy_load_image();

		$original_image = $full_image;
		$full_image 	= $lazy_image;
		$srcset 		= "data-srcset=" . $original_image . "";
	} else {
		$srcset = '';
	}

	$image_alt 	= esc_attr__('image', ' streamit-extensions');

	if ($post_type === "movie") {
		$run_time 	= $slider_nav = isset($meta['_movie_run_time'][0]) ? $meta['_movie_run_time'][0] : '';
		$genres 	= wp_get_post_terms($post_id, 'movie_genre');
	} else if ($post_type === 'tv_show') {
		$seasons = unserialize($meta["_seasons"][0]);

		if ($seasons && is_array($seasons)) {
			$season_count 	= count($seasons);
			$censor_rating 	= $season_count . _n(" Season", " Seasons", $season_count, SE_TEXT_DOMAIN);
			$slider_nav 	= $censor_rating;
		} else {
			$censor_rating 	= esc_html__('Arriving Soon', SE_TEXT_DOMAIN);
		}

		$run_time = $censor_rating . " " . get_the_date('M Y', $post_id);
		$genres = wp_get_post_terms($post_id, 'tv_show_genre');
	} elseif ($post_type === 'video') {
		$run_time 	= $slider_nav = $meta['_video_run_time'][0];
		$run_time 	.= get_post_view() . " ";
		$genres 	= wp_get_post_terms($post_id, 'video_cat');
	}

	if (!empty($genres)) {
		$genre = '<ul class="p-0 mb-2 list-inline  d-flex flex-wrap align-items-center movie-content movie-space-action flex-wrap">';
		foreach ($genres as $val) {
			$genre .= '<li class="text-primary"><a href="' . get_term_link($val) . '"><span>' . esc_html($val->name) . '</span></a></li>';
		}
		$genre .= '</ul>';
	} else {
		$genre = '';
	}

	ob_start(); ?>

	<li class="slick-bg <?php echo esc_attr($post_type); ?>">

		<div class="iq-top-verticle-slider inner-content">
			<a href="<?php echo get_the_permalink($post_id); ?>">
				<img src="<?php echo esc_url($full_image); ?>" <?php echo esc_attr($srcset); ?> class="<?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>">
			</a>

			<div class="block-description">
				<div class="text-primary title genres slider-fade-in-right RightAnimate">
					<span class="text-body"><?php echo $genre; ?></span>
				</div>

				<h2 class="iq-verticle-title 1 RightAnimate-two"><?php echo get_the_title($post_id); ?></h2>

				<div class="movie-time-wrapper d-flex flex-wrap align-items-center RightAnimate-two">
					<?php streamit()->streamit_display_imdb_rating($post_id); ?>
					<div class="movie-time d-flex align-items-center mt-2 mt-md-3 ">
						<span class="movie-time-text font-normal"><?php echo esc_html($run_time); ?></span>
					</div>
				</div>

				<div class="description mt-2 RightAnimate-three"><?php echo get_the_excerpt($post_id); ?></div>

				<div class="btn-radius mt-3 RightAnimate-four">
					<a href="<?php echo get_the_permalink($post_id) ?>" class="btn btn-hover iq-button" tabindex="0">
						<?php echo sprintf(esc_html_x("%1s", "Verticle slider button for style one", SE_TEXT_DOMAIN), $settings['play_now_text']); ?><i class="fa fa-play mr-2" aria-hidden="true"></i>
					</a>
				</div>
			</div>
		</div>
	</li>
	<?php $nav_slider .= ob_get_clean();

	ob_start(); ?>
	<li>
		<div class="block-images position-relative">
			<a href="<?php echo get_the_permalink($post_id); ?>">
				<img src="<?php echo esc_url($full_image); ?>" <?php echo esc_attr($srcset); ?> class="<?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>">
			</a>

			<div class="block-description">
				<h5 class="iq-verticle-title"><?php echo get_the_title($post_id) ?></h5>
				<div class="movie-time d-flex align-items-center my-2 ">
					<span class="movie-time-text font-normal 3"><?php echo $slider_nav ?></span>
				</div>
			</div>
		</div>
	</li>
<?php
	$slider .= ob_get_clean();
}
wp_reset_postdata(); ?>

<div id="iq-topten" class="position-relative iq-rtl-direction iq-topten slider-with-details vertical-slider-2 <?php echo esc_attr($lazy_load) ?>">
	<div class="topten-contens">
		<ul id="<?php echo esc_attr('top-ten-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('top-ten-slider-' . $id_int); ?>" class="top-ten-slider list-inline p-0 m-0  d-flex align-items-center">
			<?php echo $nav_slider; ?>
		</ul>

		<div class="vertical_s">
			<ul id="<?php echo esc_attr('top-ten-slider-nav-' . $id_int); ?>" data-rand="<?php echo esc_attr('top-ten-slider-nav-' . $id_int); ?>" class="top-ten-slider-nav list-inline p-0 m-0  d-flex align-items-center">
				<?php echo $slider; ?>
			</ul>
		</div>
	</div>
</div>