<?php

foreach ($post_ids as $post_id) {

	$img_class 	= "img-fluid w-100";
	$meta		= get_post_meta($post_id);
	$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "full");
	$full_image = !empty($full_image) ? $full_image[0] : STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/img/placeholder_genre.jpg';

	if (!empty($lazy_load)) {
		$img_class .= ' iqonic-lazy';
		$lazy_image = get_lazy_load_image();

		$original_image = $full_image;
		$full_image 	= $lazy_image;
		$srcset 		= "data-srcset=" . $original_image . "";
	} else {
		$srcset = '';
	}

	$image_alt 	= esc_attr__('image', ' streamit-extensions');

	if ($post_type == "movie") {
		$run_time 		= isset($meta['_movie_run_time'][0]) ? $meta['_movie_run_time'][0] : '';
		$censor_rating 	= isset($meta['_movie_censor_rating'][0]) ? $meta['_movie_censor_rating'][0] : '';
	} elseif ($post_type === 'tv_show') {
		$run_time 	 = get_the_date('M Y', $post_id);
		$season_data = unserialize($meta['_seasons'][0]);

		if (isset($season_data) && is_array($season_data)) {
			$censor_rating = count($season_data) . _n('Season', 'Seasons', count($season_data), SE_TEXT_DOMAIN);
		} else {
			$censor_rating = esc_html__("Arriving Soon", SE_TEXT_DOMAIN);
		}
	} elseif ($post_type === 'video') {
		$run_time = $meta['_video_run_time'][0];

		if (function_exists('set_post_view')) {
			if (get_post_view() == 0) {
				$censor_rating = '<i class="fa fa-eye"></i> ' . esc_html__('0 Views', SE_TEXT_DOMAIN);
			} else {
				$censor_rating = '<i class="fa fa-eye"></i> ' . get_post_view();
			};
		}
	}

	ob_start(); ?>

	<li class="slick-bg <?php echo esc_attr($post_type); ?>">
		<a href="<?php echo get_the_permalink($post_id) ?>" class="iq-top-verticle-slider">
			<img src="<?php echo esc_url($full_image) ?>" <?php echo esc_attr($srcset); ?> class="<?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt) ?>">
		</a>

		<div class="responsive-verticle-slider">
			<a href="<?php echo get_the_permalink($post_id) ?>">
				<img src="<?php echo esc_url($full_image) ?>" <?php echo esc_attr($srcset); ?> class="<?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt) ?>">
			</a>

			<div class="block-description">
				<h5 class="iq-verticle-title">
					<?php echo get_the_title($post_id); ?>
				</h5>

				<div class="movie-time d-flex align-items-center my-2 ">
					<div class="badge badge-secondary p-1 mr-2"><?php echo $censor_rating; ?></div>
					<span class="movie-time-text font-normal"><?php echo esc_html($run_time); ?></span>
				</div>

				<div class="hover-buttons mt-2">
					<a href="<?php echo get_the_permalink($post_id); ?>" class="btn btn-hover iq-button" tabindex="0">
						<i class="fa fa-play mr-2" aria-hidden="true"></i><?php echo sprintf(esc_html_x("%1s", "Verticle slider button for style one", SE_TEXT_DOMAIN), $settings['play_now_text']); ?>
					</a>
				</div>
			</div>
		</div>
	</li>

	<?php $nav_slider .= ob_get_clean();

	ob_start(); ?>
	<li>
		<div class="block-images position-relative">
			<a href="<?php echo get_the_permalink($post_id); ?>">
				<img src="<?php echo esc_url($full_image); ?>" <?php echo esc_attr($srcset); ?> class="<?php echo esc_attr($img_class); ?>" alt="<?php echo esc_attr($image_alt); ?>">
			</a>

			<div class="block-description">
				<h5 class="iq-verticle-title">
					<?php echo get_the_title($post_id); ?>
				</h5>

				<div class="movie-time d-flex align-items-center my-2 ">
					<div class="badge badge-secondary p-1 mr-2"><?php echo $censor_rating; ?></div>
					<span class="movie-time-text font-normal"><?php echo esc_html($run_time); ?></span>
				</div>

				<div class="hover-buttons">
					<a href="<?php echo get_the_permalink($post_id) ?>" class="btn btn-hover iq-button" tabindex="0">
						<i class="fa fa-play mr-1" aria-hidden="true"></i><span><?php echo sprintf(esc_html_x("%1s", "Verticle slider button for style one", SE_TEXT_DOMAIN), $settings['play_now_text']); ?></span>
					</a>
				</div>
			</div>
		</div>
	</li>
<?php $slider .= ob_get_clean();
}
wp_reset_postdata(); ?>

<div id="iq-topten" class="position-relative iq-rtl-direction iq-topten <?php echo esc_attr($lazy_load) ?>">
	<h4 class="iq-title"><?php echo esc_html($settings['movie_section_title']); ?></h4>
	<div class="topten-contens">
		<ul id="<?php echo esc_attr('top-ten-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('top-ten-slider-' . $id_int); ?>" class="top-ten-slider list-inline p-0 m-0  d-flex align-items-center">
			<?php echo $nav_slider; ?>
		</ul>

		<div class="vertical_s">
			<ul id="<?php echo esc_attr('top-ten-slider-nav-' . $id_int); ?>" data-rand="<?php echo esc_attr('top-ten-slider-nav-' . $id_int); ?>" class="top-ten-slider-nav list-inline p-0 m-0  d-flex align-items-center">
				<?php echo $slider; ?>
			</ul>
		</div>
	</div>
</div>