<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$id_int 			= rand(10, 100);
$args = $tax_query 	= $taxargs = array();

$settings 			= $this->get_settings();
$post_type 			= $settings['iq_type'];
$lazy_load			= $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";

$args = array(
	'post_status' => 'publish',
	'fields' 	  => 'ids',
);

if ($settings['post_filter'] == "selected") {
	$repeater = $settings['tabs'];

	$args['post_type'] = array('tv_show', 'movie', 'video');

	foreach ($repeater as $index => $item) {
		$type = $item['iq_post_type'];
		if (!empty($item['iq_' . $type])) {
			$post_names[] = $item['iq_' . $type];
		}
	}
	$args['post_name__in'] 	= $post_names;
	$args['orderby'] 		= 'post_name__in';
} else {

	$args['post_type'] = $post_type;

	if (!empty($settings['iq_movie_genre']) && $post_type === 'movie') {
		$tax_query['taxonomy'] 	= 'movie_genre';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_movie_genre'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_movie_tag']) && $post_type === 'movie') {
		$tax_query['taxonomy'] 	= 'movie_tag';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_movie_tag'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_tv_show_genre']) && $post_type === 'tv_show') {
		$tax_query['taxonomy'] 	= 'tv_show_genre';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_tv_show_genre'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_tv_show_tag']) && $post_type === 'tv_show') {
		$tax_query['taxonomy'] 	= 'tv_show_tag';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_tv_show_tag'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_video_genre']) && $post_type === 'video') {
		$tax_query['taxonomy'] 	= 'video_cat';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_video_genre'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_video_tag']) && $post_type === 'video') {
		$tax_query['taxonomy'] 	= 'video_tag';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_video_tag'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($tax_query)) {
		$args['tax_query'] 				= $taxargs;
		$args['tax_query']['relation'] 	= 'OR';
	}
}

$nav_slider = $slider = '';

$wp_query = new \WP_Query($args);
$post_ids = $wp_query->posts;

if ($wp_query->have_posts()) {
	if ($settings['verticle_banner_style'] == 2) {
		require trailingslashit(plugin_dir_path(__FILE__)) . 'style-two.php';
	} else {
		require trailingslashit(plugin_dir_path(__FILE__)) . 'style-one.php';
	}
}
