<?php

namespace Iqonic\Elementor\Elements\Verticle_Slider;

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'Iq_Movie_Vertical_Slider';
	}

	public function get_title()
	{
		return esc_html__('Vertical Banner Slider', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-vertical';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Verticle Banner Slider', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'verticle_banner_style',
			[
				'label'      => __('Select Verticle Banner Style', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '1',
				'label_block' => true,
				'options'    => [
					'1'          => __('Style 1', 'streamit-extensions'),
					'2'          => __('Style 2', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'movie_section_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __('Title', 'streamit-extensions'),
				'condition' => [
					'verticle_banner_style' => '1'
				],
			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', 'plugin-domain'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Play Now', 'plugin-domain'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'options' => [
					'selected' 	=> __('Selected', 'streamit-extensions'),
					'default' 	=> __('Default', 'streamit-extensions')
				],
				'default' => 'default'
			]
		);

		$this->add_control(
			'iq_type',
			[
				'label' => __('Select Post Type To Display', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' 	=> __('Movie', 'streamit-extensions'),
					'tv_show' 	=> __('Tv Show', 'streamit-extensions'),
					'video' 	=> __('Video', 'streamit-extensions')
				],
				'default' => 'movie',
				'condition' => ['post_filter' => ['default']],
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_post_type',
			[
				'label' => __('Select Specific Post', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' 	=> __('Movie', 'streamit-extensions'),
					'tv_show' 	=> __('Tv Show', 'streamit-extensions'),
					'video' 	=> __('Video', 'streamit-extensions')
				],
				'default' => 'movie'
			]
		);

		$repeater->add_control(
			'iq_tv_show',
			[
				'label' => __('Display Specific Tv-Show', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show', true) : [],
				'condition' => ['iq_post_type' => ['tv_show']],
			]
		);

		$repeater->add_control(
			'iq_movie',
			[
				'label' => __('Display Specific Movie', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('movie', true) : [],
				'condition' => ['iq_post_type' => ['movie']],
			]
		);

		$repeater->add_control(
			'iq_video',
			[
				'label' => __('Display Specific Video', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('video', true) : [],
				'condition' => ['iq_post_type' => ['video']],
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' 	=> __('Item List', 'streamit-extensions'),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'condition' => ['post_filter' => ['selected']],
			]
		);

		$this->add_control(
			'iq_movie_genre',
			[
				'label' => __('Display Movie From Specific Genre', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_genre') : [],
				'condition' => [
					'post_filter' 	=> ['default'],
					'iq_type' 		=> ['movie']
				],
			]
		);

		$this->add_control(
			'iq_movie_tag',
			[
				'label' => __('Display Movie From Specific Tags', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_tag') : [],
				'condition' => [
					'post_filter' 	=> ['default'],
					'iq_type' 		=> ['movie']
				],
			]
		);

		$this->add_control(
			'iq_tv_show_genre',
			[
				'label' => __('Display Tv Show From Specific Genre', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_genre') : [],
				'condition' => [
					'post_filter' 	=> ['default'],
					'iq_type' 		=> ['tv_show']
				],
			]
		);

		$this->add_control(
			'iq_tv_show_tag',
			[
				'label' => __('Display Tv Show From Specific Tags', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_tag') : [],
				'condition' => [
					'post_filter' 	=> ['default'],
					'iq_type' 		=> ['tv_show']
				],
			]
		);

		$this->add_control(
			'iq_video_genre',
			[
				'label' => __('Display Video From Specific Categories', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('video_cat') : [],
				'condition' => [
					'post_filter' 	=> ['default'],
					'iq_type' 		=> ['video']
				],
			]
		);

		$this->add_control(
			'iq_video_tag',
			[
				'label' => __('Display Video From Specific Tags', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('video_tag') : [],
				'condition' => [
					'post_filter' 	=> ['default'],
					'iq_type' 		=> ['video']
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => __('Button', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .btn-radius .iq-button.btn, {{WRAPPER}} .hover-buttons .iq-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .btn-radius .iq-button.btn, {{WRAPPER}} .hover-buttons .iq-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callVerticleSlider();
				})(jQuery);
			</script>
<?php
		}
	}
}
