<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$user_login = false;

$settings   = $this->get_settings();
$style      = $settings['dropdown_menu_style'];

if (is_user_logged_in()) {
    $user_login = true;
}

// This Condition For User Preview
if (Plugin::$instance->editor->is_edit_mode()) {
    $user_login = $settings['user_login'];
}

if ($user_login) {
    $current_user = wp_get_current_user();
    $get_avatar = get_the_author_meta('streamit_profile_image', $current_user->ID);
    if (empty($get_avatar)) {
        $get_avatar = get_avatar_url($current_user->ID);
    }
    $user_name = get_the_author_meta('display_name', $current_user->ID);
}

if ($style == 'style-1') : ?>
    <div class="iq-users-settings user-btn nav-item nav-icon header-user-rights iq-usermenu-dropdown">
        <div class="nav-item nav-icon header-user-rights">
            <a href="javascript:void(0);" class="iq-user-dropdown search-toggle p-0 d-flex align-items-center active" data-toggle="search-toggle" id="btn-user-list">
                <?php if (!$user_login || $settings['user_avatar_fix']) {
                    echo '<span class="iq-avatar ' . $settings['avatar_style'] . ' " >';
                    Icons_Manager::render_icon($settings['user_avatar'], ['aria-hidden' => 'true', 'alt' => 'user']);
                    echo '</span>';
                } else { ?>
                    <img src="<?php echo esc_url($get_avatar) ?>" class="img-fluid avatar-40 rounded-circle" alt="user">
                <?php }

                if ($settings['avatar_style'] == "style-2"  && !empty($settings['avatar_text']) && !$user_login) { ?>
                    <span class="user-avatar-text"><?php echo esc_html($settings['avatar_text']) ?></span>
                <?php } ?>
            </a>

            <?php if (!$user_login) { ?>
                <div class="iq-sub-dropdown iq-user-dropdown">
                    <div class="iq-card shadow-none m-0">
                        <div class="iq-card-body p-0 pl-3 pr-3">
                            <?php if ($settings['list_user_non_login']) {
                                foreach ($settings['list_user_non_login'] as $item) {
                                    $target = '';
                                    if($item['use_archive_link'] == 'yes') {
                                        $link = $item['archive_dynamic_link'];
                                    } elseif($item['use_archive_link'] == 'no') {
                                        $link = get_permalink(get_page_by_path($item['list_page_link']));
                                    } else {
                                        $link = $item['custom_page_link']['url'];
                                        if ($item['link']['is_external']) {
                                            $target .= "target='_blank'";
                                        }

                                        if ($item['link']['nofollow']) {
                                            $target .= "rel='nofollow'";
                                        }
                                    } ?>

                                    <a href="<?php echo  esc_url($link) ?>" class="iq-list-link iq-sub-card" <?php echo esc_attr($target); ?>>
                                        <div class="media align-items-center">
                                            <div class="right-icon">
                                                <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'iq-user-list-icon']); ?>
                                            </div>

                                            <div class="media-body">
                                                <h6 class="m-0 ">
                                                    <?php echo esc_html($item['list_title']); ?>
                                                </h6>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                }
                            } ?>
                        </div>
                    </div>
                </div>
            <?php } else { ?>
                <div class="iq-sub-dropdown iq-user-dropdown">
                    <div class="iq-card shadow-none m-0">
                        <div class="iq-user-list-item iq-card-body p-0 pl-3 pr-3">
                            <?php if ($settings['list_user']) {
                                foreach ($settings['list_user'] as $item) {
                                    $target = '';
                                    if($item['use_archive_link'] == 'yes') {
                                        $link = $item['archive_dynamic_link'];
                                    } elseif($item['use_archive_link'] == 'no') {
                                        $link = get_permalink(get_page_by_path($item['list_page_link']));
                                    } else {
                                        $link = $item['custom_page_link']['url'];
                                        if ($item['link']['is_external']) {
                                            $target .= "target='_blank'";
                                        }

                                        if ($item['link']['nofollow']) {
                                            $target .= "rel='nofollow'";
                                        }
                                    } ?>

                                    <a href="<?php echo $item['is_logout'] != 'yes' ? esc_url($link) : wp_logout_url(home_url()) ?>" class="iq-list-link  iq-sub-card" <?php echo esc_attr($target); ?>>
                                        <div class="media align-items-center">

                                            <div class="right-icon">
                                                <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'iq-user-list-icon']); ?>
                                            </div>

                                            <div class="media-body">
                                                <h6 class="m-0 ">
                                                    <?php echo esc_html($item['list_title']); ?>
                                                </h6>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                }
                            } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </div>
<?php

else : ?>
    <div class="iq-users-settings user-btn nav-item nav-icon header-user-rights iq-usermenu-dropdown">
        <div class="nav-item nav-icon header-user-rights">
            <a href="javascript:void(0);" class="iq-user-dropdown search-toggle p-0 d-flex align-items-center active" data-toggle="search-toggle" id="btn-user-list">
                <?php if (!empty($settings['user_avatar'])) {
                    echo '<span class="iq-avatar ' . $settings['avatar_style'] . ' " >';
                    Icons_Manager::render_icon($settings['user_avatar'], ['aria-hidden' => 'true', 'alt' => 'user']);
                    echo '</span>';
                }

                if ($settings['avatar_style'] == "style-2"  && !empty($settings['avatar_text']) && !$user_login) { ?>
                    <span class="user-avatar-text"><?php echo esc_html($settings['avatar_text']) ?></span>
                <?php } ?>
            </a>

            <?php if (!$user_login) { ?>
                <div class="iq-sub-dropdown iq-user-dropdown-style-2">
                    <div class="iq-card shadow-none m-0">
                        <div class="iq-card-body">
                            <?php if ($settings['list_user_non_login']) {
                                foreach ($settings['list_user_non_login'] as $item) {
                                    $target = '';
                                    if($item['use_archive_link'] == 'yes') {
                                        $link = $item['archive_dynamic_link'];
                                    } elseif($item['use_archive_link'] == 'no') {
                                        $link = get_permalink(get_page_by_path($item['list_page_link']));
                                    } else {
                                        $link = $item['custom_page_link']['url'];
                                        if ($item['link']['is_external']) {
                                            $target .= "target='_blank'";
                                        }

                                        if ($item['link']['nofollow']) {
                                            $target .= "rel='nofollow'";
                                        }
                                    } ?>

                                    <a href="<?php echo  esc_url($link) ?>" class="iq-list-link iq-sub-card" <?php echo esc_attr($target); ?>>
                                        <div class="media align-items-center">
                                            <div class="right-icon">
                                                <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'iq-user-list-icon', 'fill' => 'white']); ?>
                                            </div>

                                            <div class="media-body">
                                                <h6 class="m-0 ">
                                                    <?php echo esc_html($item['list_title']); ?>
                                                </h6>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                }
                            } ?>
                        </div>
                    </div>
                </div>
            <?php
            } else { ?>
                <div class="iq-sub-dropdown iq-user-dropdown-style-2">
                    <div class="iq-card shadow-none m-0">
                        <div class="iq-user-list-item iq-card-body">
                            <div class="user-info">
                                <img src="<?php echo esc_url($get_avatar) ?>" class="img-fluid avatar-40" alt="user">
                                <span class="user-name">
                                    <?php echo esc_html($user_name); ?>
                                </span>
                            </div>

                            <?php if ($settings['list_user']) {
                                foreach ($settings['list_user'] as $item) {
                                    $target = '';
                                    if($item['use_archive_link'] == 'yes') {
                                        $link = $item['archive_dynamic_link'];
                                    } elseif($item['use_archive_link'] == 'no') {
                                        $link = get_permalink(get_page_by_path($item['list_page_link']));
                                    } else {
                                        $link = $item['custom_page_link']['url'];
                                        if ($item['custom_page_link']['is_external']) {
                                            $target .= "target='_blank'";
                                        }

                                        if ($item['custom_page_link']['nofollow']) {
                                            $target .= "rel='nofollow'";
                                        }
                                    }
                                    
                                    $is_logout = ($item['is_logout'] == "yes") ? 'iq-list-link iq-sub-card iq-logout-2' : 'iq-list-link iq-sub-card'; ?>

                                    <a href="<?php echo $item['is_logout'] != 'yes' ? esc_url($link) : wp_logout_url(home_url()) ?>" class="<?php echo esc_attr($is_logout); ?>" <?php echo esc_attr($target); ?>>
                                        <div class="media align-items-center">
                                            <div class="right-icon">
                                                <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'iq-user-list-icon', 'fill' => 'white']); ?>
                                            </div>

                                            <div class="media-body">
                                                <h6 class="m-0 ">
                                                    <?php echo esc_html($item['list_title']); ?>
                                                </h6>
                                            </div>
                                        </div>
                                    </a>
                                    <?php
                                }
                            } ?>
                        </div>
                    </div>
                </div>
            <?php
            } ?>
        </div>
    </div>
<?php
endif;
