<?php

namespace Iqonic\Elementor\Elements\User;

use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_layout_user';
    }

    public function get_title()
    {
        return esc_html__('Layouts: User', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_sc_layouts_user_button',
            [
                'label' => esc_html__('Layouts: User Button', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'user_login',
            [
                'label' => esc_html__('User Login?', 'streamit-extensions'),
                'description' => esc_html__('This is Option is only for Preview', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'true' => esc_html__('Yes', 'streamit-extensions'),
                'false' => esc_html__('No', 'streamit-extensions'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'avatar_style',
            [
                'label' => esc_html__('Menu holder design', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                    'style-1'  => esc_html__('Style 1', 'streamit-extensions'),
                    'style-2' => esc_html__('Style 2', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'dropdown_menu_style',
            [
                'label' => __('Dropdown design', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => __('Style 1', 'streamit-extensions'),
                    'style-2' => __('Style 2', 'streamit-extensions'),
                ],
                'default' => 'style-1',
            ]
        );

        $this->add_control(
            'avatar_text',
            [
                'label' => esc_html__('Avatar Text', 'streamit-extensions'),
                'description' => esc_html__('This Option Add Text Only For User On Not Login', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Login', 'streamit-extensions'),
                'label_block' => true,
                'condition' => [
                    'avatar_style'          => 'style-2',
                    'dropdown_menu_style'   => 'style-1'
                ]
            ]
        );

        $this->add_control(
            'user_avatar_fix',
            [
                'label' => esc_html__('Fixed User Avatar', 'streamit-extensions'),
                'description' => esc_html__('option use for fixed for login and logout user same avatar', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'true' => esc_html__('Yes', 'streamit-extensions'),
                'false' => esc_html__('No', 'streamit-extensions'),
                'default' => 'yes',
                'condition' => ['dropdown_menu_style' => 'style-1']
            ]
        );

        $this->add_control(
            'user_avatar',
            [
                'label' => esc_html__('User Avatar icon', 'streamit-extensions'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'far fa-user',
                    'library' => 'solid',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_sc_layouts_user',
            [
                'label' => esc_html__('Layouts: Login User Link', 'streamit-extensions'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'list_title',
            [
                'label' => esc_html__('Title', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('User', 'streamit-extensions'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'list_icon',
            [
                'label' => esc_html__('Select Icon', 'streamit-extensions'),
                'type' => Controls_Manager::ICONS,
            ]
        );

        $repeater->add_control(
            'use_archive_link',
            [
                'label' => __('Links?', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => __('Archive Page Links', 'streamit-extensions'),
                    'no' => __('Pages', 'streamit-extensions'),
                    'custom' => __('Custom', 'streamit-extensions'),
                ],
            ]
        );

        $repeater->add_control(
            'list_page_link',
            [
                'label' => esc_html__('Select Page ', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('page', true) : [],
                'label_block' => true,
                'condition' => [
                    'use_archive_link' => 'no',
                ],
            ]
        );

        $repeater->add_control(
            'archive_dynamic_link',
            [
                'label' => esc_html__('Select Archive', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'use_archive_link' => 'yes',
                ],
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data_archive_link() : [],
            ]
        );

        $repeater->add_control(
            'custom_page_link',
            [
                'label' => esc_html__('Custom URL ', 'streamit-extensions'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'condition' => [
                    'use_archive_link' => 'custom',
                ],
            ]
        );

        $repeater->add_control(
            'is_logout',
            [
                'label' => esc_html__('Is Logout Button?', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'no' => esc_html__('No', 'streamit-extensions'),
                'yes' => esc_html__('Yes', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'list_user',
            [
                'label' => esc_html__('Login User Settings', 'streamit-extensions'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => esc_html__('Account', 'streamit-extensions'),
                        'list_icon' => esc_html__('fa fa-start', 'streamit-extensions'),

                    ],
                    [
                        'list_title' => esc_html__('Logout', 'streamit-extensions'),
                        'list_icon' => esc_html__('fa fa-start', 'streamit-extensions'),

                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_sc_layouts_user_non_login',
            [
                'label' => esc_html__('Layouts: Non Login User Link', 'streamit-extensions'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'list_title',
            [
                'label' => esc_html__('Title', 'streamit-extensions'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('User', 'streamit-extensions'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'list_icon',
            [
                'label' => esc_html__('Select Icon', 'streamit-extensions'),
                'type' => Controls_Manager::ICONS,
            ]
        );

        $repeater->add_control(
            'use_archive_link',
            [
                'label' => __('Use Archive Page link?', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => __('Yes', 'streamit-extensions'),
                    'no' => __('No', 'streamit-extensions'),
                ],
            ]
        );

        $repeater->add_control(
            'list_page_link',
            [
                'label' => esc_html__('Select Page ', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('page', true) : [],
                'label_block' => true,
                'condition' => [
                    'use_archive_link' => 'no'
                ],
            ]
        );

        $repeater->add_control(
            'archive_dynamic_link',
            [
                'label' => esc_html__('Select Archive', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'use_archive_link' => 'yes'
                ],
                'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data_archive_link() : [],
            ]
        );

        $this->add_control(
            'list_user_non_login',
            [
                'label' => esc_html__('Non Login User Settings', 'streamit-extensions'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => esc_html__('Account', 'streamit-extensions'),
                        'list_icon' => esc_html__('fa fa-start', 'streamit-extensions'),
                    ],
                    [
                        'list_title' => esc_html__('Logout', 'streamit-extensions'),
                        'list_icon' => esc_html__('fa fa-start', 'streamit-extensions'),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();

        // Style Tab 
        $this->start_controls_section(
            'user_avatar_style',
            [
                'tab' => Controls_Manager::TAB_STYLE,
                'label' => esc_html__('User Avatar', 'streamit-extensions'),
            ]
        );

        $this->start_controls_tabs('user_tabs');
        $this->start_controls_tab(
            'user_c8fpaelTGDkf951QeYf2',
            [
                'label' => __('Normal', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'user_avatar_text_color',
            [
                'label' => esc_html__('Avatar Text Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-user-dropdown .user-avatar-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'user_avatar_icon_color',
            [
                'label' => esc_html__('Avatar Icon Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-avatar :is(i,svg path), {{WRAPPER}} .iq-usermenu-dropdown .iq-sub-dropdown .iq-card-body .right-icon  :is(i,svg path)' => 'color: {{VALUE}};stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Choose Background Color ', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-avatar' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'user_49pcfagYof19beG4w8Ee',
            [
                'label' => __('Hover', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'user_avatar_text_hover_color',
            [
                'label' => esc_html__('Avatar Hover Text Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-user-dropdown .user-avatar-text:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'user_avatar_icon_hover_color',
            [
                'label' => esc_html__('Avatar Hover Icon Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-avatar:hover :is(i,svg path),{{WRAPPER}} .iq-usermenu-dropdown .iq-sub-dropdown .iq-card-body .iq-sub-card:hover .right-icon  :is(i,svg path)' => 'color: {{VALUE}};stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_hover_color',
            [
                'label' => __('Choose Hover Background Color ', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-avatar:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .iq-users-settings .iq-user-dropdown .user-avatar-text',
            ]
        );

        $this->add_control(
            'btn_size',
            [
                'label' => esc_html__('Button Size', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-avatar' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_radius',
            [
                'label' => esc_html__('Button Radius', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-avatar' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_menu_list_size',
            [
                'label' => __('Icon size', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-user-dropdown span i, {{WRAPPER}} .iq-users-settings .iq-sub-dropdown .iq-card-body .right-icon i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_svg_size',
            [
                'label' => __('SVG Icon Size', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'default' => [
                    'unit' => 'rem', // Set default unit to rem
                    'size' => 1.5, // Set default size to 1.5
                ],
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .iq-users-settings .iq-user-dropdown span svg , {{WRAPPER}} .iq-users-settings  .iq-sub-dropdown .iq-card-body .right-icon svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'menu_parent_margin',
            [
                'label' => __('Margin', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iq-users-settings .iq-user-dropdown .user-avatar-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'menu_parent_padding',
            [
                'label' => __('Padding', 'streamit-extensions'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iq-users-settings' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
    }
}
