<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$id_int = rand(10, 100);
$args 	= $tax_query = array();

$settings 					 = $this->get_settings();
$display_logo 				 = $settings['view_logo'] == "block";
$display_tag 				 = $settings['view_all_tag'] == "block";
$display_genre 		 		 = $settings['view_all_genres'] == "block";
$display_cast 				 = $settings['view_all_starring'] == "block";
$settings['show_no_tv_show'] = $settings['show_no_tv_show'] == 0 ? 10 : $settings['show_no_tv_show'];
$lazy_load				 	 = $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";

$args = array(
	'post_type'         => 'tv_show',
	'fields'            => 'ids',
	'post_status'       => 'publish',
	'posts_per_page'    => $settings['show_no_tv_show'],
	'meta_query' 		=> array(
		array(
			'key'     => 'name_upcoming',
			'value'   => '',
			'compare' => '=='
		)
	),
);

if ($settings['post_filter'] == "selected") {
	$repeater = $settings['tabs'];

	foreach ($repeater as $index => $item) {
		if (!empty($item['iq_tv_show'])) {
			$post_names[] = $item['iq_tv_show'];
		}
	}
	$args['post_name__in'] 	= $post_names;
	$args['orderby'] 		= 'post_name__in';
} else {
	$args['meta_key'] 		= 'tv_show_views_count';
	$args['orderby']        = 'meta_value_num';
	$args['order']          = 'DESC';
}

$posts = get_posts($args);

if ($settings['post_filter'] == "default" && count($posts) < 6) {
	$args2 = array(
		'post_type'         => 'tv_show',
		'fields'            => 'ids',
		'post_status'       => 'publish',
		'posts_per_page'    => $settings['show_no_tv_show'],
		'order'             => 'DESC'
	);

	$wp_query2 = get_posts($args2);

	$allTheIDs 	= array_merge($posts, $wp_query2);
	$id 		= array_unique($allTheIDs);

	$args3 = array(
		'post_type'         => 'tv_show',
		'fields'            => 'ids',
		'post__in'          => $allTheIDs,
		'post_status'       => 'publish',
		'posts_per_page'    => $settings['show_no_tv_show'],
		'order'             => 'DESC'
	);
	$posts = get_posts($args3);
} ?>

<div id="iq-trending" class="s-margin iq-tvshow-tabs iq-rtl-direction iq-trending-tabs <?php echo esc_attr($lazy_load) ?>">
	<?php if (isset($settings['show_title']) && $settings['show_title'] == 'yes') { ?>
		<div class="iq-main-header d-flex align-items-center justify-content-between">
			<h4 class="main-title">
				<?php if (!empty($settings['title_text'])) {
					echo esc_attr($settings['title_text'], 'streamit-extensions');
				} else {
					echo __('Trending', 'streamit-extensions');
				} ?>
			</h4>
		</div>
	<?php } ?>

	<div class="trending-contens">
		<ul id="<?php echo esc_attr('trending-slider-nav-' . $id_int); ?>" data-rand="<?php echo esc_attr('trending-slider-nav-' . $id_int); ?>" class="trending-slider-nav list-inline p-0 mb-0 row align-items-center">
			<?php foreach ($posts as $post) {
				$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post), "large");
				$full_image = $full_image[0];

				$image_alt 	= esc_attr__('image', SE_TEXT_DOMAIN);

				if (!empty($lazy_load)) {
					$img_class = ' iqonic-lazy';
					$lazy_image = get_lazy_load_image();

					$original_image = $full_image;
					$full_image 	= $lazy_image;
					$srcset 		= "data-srcset=" . $original_image . "";
				} else {
					$srcset = '';
					$img_class = '';
				} ?>

				<li>
					<a href="javascript:void(0);">
						<div class="movie-slick position-relative">
							<img src="<?php echo esc_url($full_image) ?>" <?php echo esc_attr($srcset); ?> class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo $image_alt; ?>">
						</div>
					</a>
				</li>
			<?php } ?>
		</ul>

		<ul id="<?php echo esc_attr('trending-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('trending-slider-' . $id_int); ?>" class="trending-slider list-inline p-0 m-0  d-flex align-items-center">
			<?php $i = 1;
			foreach ($posts as $post) {
				$cast = $genre = $tag = '';

				$year 			= get_the_date('M Y');
				$meta 			= get_post_meta($post);
				$_cast 			= unserialize($meta['_cast'][0]);
				$season_data 	= unserialize($meta['_seasons'][0]);
				$movie_logo 	= wp_get_attachment_image_src($meta['name_logo'][0], "full");
				$movie_logo 	= !empty($movie_logo) ? $movie_logo[0] : '';
				$post_image 	= get_the_post_thumbnail_url($post);

				if (!empty($lazy_load)) {
					$img_class = ' iqonic-lazy';
					$lazy_image = get_lazy_load_image();

					$original_image = $post_image;
					$post_image 	= $lazy_image;
					$srcset 		= "data-srcset=" . $original_image . "";
				} else {
					$srcset = '';
					$img_class = '';
				}

				if (!empty($movie_logo['alt'])) {
					$alt = esc_attr($movie_logo['alt']);
				} else {
					$alt = esc_attr__('image', 'streamit-extensions');
				}

				if (!empty($settings['trending_top_img']['alt'])) {
					$top_trend_alt =  esc_attr($settings['trending_top_img']['alt']);
				} else {
					$top_trend_alt =  esc_attr__('image', SE_TEXT_DOMAIN);
				}

				if ($display_cast) {
					if (is_array($_cast)) {
						$j = 1;
						foreach ($_cast as $data) {
							if ($settings['show_no_starring'] == -1 || $settings['show_no_starring'] >= $j) {
								$cast_obj = get_post($data['id']);
								if (get_post_type($cast_obj) != 'person') continue;
								if ($j === 1)
									$cast = '<a href="' . get_permalink($cast_obj) . '"><span class="text-body">' . get_the_title($cast_obj) . '</span></a>';
								else
									$cast .= ", " . '<a href="' . get_permalink($cast_obj) . '"><span class="text-body">' . get_the_title($cast_obj) . '</span></a>';
								$j++;
							}
						}
					}
				}

				if ($display_genre) {
					$wp_object = wp_get_post_terms($post, 'tv_show_genre');
					if (!empty($wp_object)) {
						$k = 1;
						foreach ($wp_object as $val) {
							if ($settings['show_no_genres'] == -1 || $settings['show_no_genres'] >= $k) {
								if ($k == 1)
									$genre = '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
								else
									$genre .= ', ' . '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
								$k++;
							}
						}
					}
				}

				if ($display_tag) {
					$wp_object = wp_get_post_terms($post, 'tv_show_tag');
					if (!empty($wp_object)) {
						$l = 1;
						foreach ($wp_object as $val) {
							if ($settings['show_no_tags'] == -1 || $settings['show_no_tags'] >= $l) {
								if ($l == 1)
									$tag = '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
								else
									$tag .= ', ' . '<a href="' . get_term_link($val) . '"><span class="text-body">' . $val->name . '</span></a>';
								$l++;
							}
						}
					}
				} ?>

				<li>
					<div class="tranding-block position-relative iqonic-lazy" style="background-image: url(<?php echo esc_url($post_image); ?>);" <?php echo esc_attr($srcset); ?>>
						<div class="trending-custom-tab">
							<div class="tab-title-info position-relative">
								<ul class="trending-pills d-flex nav nav-pills justify-content-center align-items-center text-center" role="tablist">
									<li class="nav-item">
										<a class="nav-link active" data-toggle="pill" href="#overview_<?php echo esc_attr($i . $id_int); ?>" role="tab" aria-selected="true">
											<?php if (!empty($settings['tab_text_overview'])) {
												echo esc_attr($settings['tab_text_overview'], 'streamit-extensions');
											} else {
												echo esc_html__('Overview', SE_TEXT_DOMAIN);
											} ?>
										</a>
									</li>

									<li class="nav-item">
										<a class="nav-link iq-tv_show-episodes" data-toggle="pill" href="#episodes_<?php echo esc_attr($i . $id_int); ?>" role="tab" aria-selected="false" data-episodes="<?php echo esc_attr(json_encode($season_data)) ?>">
											<?php if (!empty($settings['tab_text_episode'])) {
												echo esc_attr($settings['tab_text_episode'], 'streamit-extensions');
											} else {
												echo esc_html__('Episodes', SE_TEXT_DOMAIN);
											} ?>
										</a>
									</li>
								</ul>
							</div>

							<div class="trending-content tab-content">
								<div id="overview_<?php echo esc_attr($i . $id_int); ?>" class="overview-tab tab-pane fade active show">
									<div class="trending-info align-items-center w-100 animated fadeIn">
										<?php if ($display_logo && !empty($movie_logo)) { ?>
											<a href="javascript:void(0);" tabindex="0">
												<div class="res-logo">
													<div class="channel-logo">
														<img src="<?php echo esc_url($movie_logo); ?>" class="c-logo" alt="<?php echo esc_attr($alt); ?>">
													</div>
												</div>
											</a>
										<?php } ?>

										<h1 class="trending-text big-title text-uppercase">
											<?php echo get_the_title($post); ?>
										</h1>

										<div class="d-flex align-items-center text-detail mb-4">
											<span class="season_date">
												<?php if (is_array($season_data)) {
													echo count($season_data) . ((count($season_data) == 1) ? esc_html__(' Season', 'streamit-extensions') : esc_html__(' Seasons', 'streamit-extensions'));
												} else echo esc_html__('1 Season', SE_TEXT_DOMAIN); ?>
											</span>

											<span class="trending-year">
												<?php echo esc_html($year); ?>
											</span>
										</div>

										<div class="d-flex align-items-center series mb-4">
											<?php if (!empty($settings['trending_top_img']['url'])) { ?>
												<img src="<?php echo esc_url($settings['trending_top_img']['url']) ?>"
													class="img-fluid" alt="<?php echo esc_attr($top_trend_alt); ?>">
											<?php } ?>
											<span class="text-gold ml-3">#
												<?php
												echo esc_html($i);
												echo esc_html__(' in Series Today', SE_TEXT_DOMAIN);
												?>
											</span>
										</div>

										<div class="trending-dec mb-4">
											<?php $excerpt = get_the_excerpt($post);
											if (!empty($excerpt)) {
												$iq_remove_tags = array("<p>", "</p>");
												$iq_excerpt = str_replace($iq_remove_tags, "", $excerpt);
												echo esc_html__($iq_excerpt);
											} ?>
										</div>

										<div class="p-btns">
											<div class="d-flex align-items-center p-0">
												<a href="<?php the_permalink($post); ?>" class="btn btn-hover iq-button mr-2" tabindex="0"><i class="fa fa-play mr-2" aria-hidden="true"></i><?php echo esc_html__('Play Now', SE_TEXT_DOMAIN); ?></a>
											</div>
										</div>

										<div class="trending-list mt-4">
											<?php if (!empty($cast)) { ?>
												<div class="text-primary title starring">
													<?php if (!empty($streamit_options['streamit_starring_title'])) {
														echo esc_html($streamit_options['streamit_starring_title']);
													} else {
														echo esc_html__('Starring:', SE_TEXT_DOMAIN);
													} ?> <span class="text-body"><?php echo rtrim($cast, ","); ?></span>
												</div>
											<?php } ?>

											<?php if (!empty($genre)) { ?>
												<div class="text-primary title genres">
													<?php if (!empty($streamit_options['streamit_genres_title'])) {
														echo esc_html($streamit_options['streamit_genres_title']);
													} else {
														echo esc_html__('Genres:', SE_TEXT_DOMAIN);
													} ?> <span class="text-body"><?php echo rtrim($genre, ","); ?></span>
												</div>
											<?php } ?>

											<?php if (!empty($tag)) { ?>
												<div class="text-primary title tag">
													<?php if (!empty($streamit_options['streamit_tag_title'])) {
														echo esc_html($streamit_options['streamit_tag_title']);
													} else {
														echo esc_html__('Tag:', SE_TEXT_DOMAIN);
													} ?> <span class="text-body"><?php echo rtrim($tag, ","); ?></span>
												</div>
											<?php } ?>
										</div>
									</div>
								</div>

								<?php if (!empty($season_data)) { ?>
									<div id="episodes_<?php echo esc_attr($i . $id_int); ?>" class="overlay-tab tab-pane fade">
										<div class="trending-info align-items-center w-100 animated fadeIn">
											<?php if ($display_logo && !empty($movie_logo)) { ?>
												<a href="<?php the_permalink();  ?>" tabindex="0">
													<div class="channel-logo">
														<img src="<?php echo esc_url($movie_logo); ?>" class="c-logo" alt="<?php if (isset($movie_logo['alt'])) echo esc_attr($movie_logo['alt']); ?>">
													</div>
												</a>
											<?php } ?>

											<h1 class="trending-text big-title text-uppercase"><?php echo get_the_title($post); ?></h1>
											<div class="d-flex align-items-center text-detail mb-4">

												<span class="season_date">
													<?php
													if (is_array($season_data)) {
														echo count($season_data) . ((count($season_data) == 1) ? esc_html__(' Season', 'streamit-extensions') : esc_html__(' Seasons', 'streamit-extensions'));
													} else echo esc_html__('1 Season', SE_TEXT_DOMAIN);
													?>
												</span>
												<span class="trending-year"><?php echo esc_html($year); ?></span>
											</div>
											<div class="iq-custom-select d-inline-block sea-epi">
												<select name="cars" class="form-control season-select">
													<?php
													foreach ($season_data as $index => $val) {
													?>
														<option value="<?php echo esc_html($index); ?>"><?php echo esc_html($val['name']); ?></option>
													<?php } ?>
												</select>
											</div>

											<div class="episodes-contens iq-rtl-direction">
												<div class="owl-carousel-ajax episodes-slider1  owl-carousel owl-theme  list-inline p-0 mb-0 ajax-owl-load   active show" data-display="<?php echo esc_attr('0', 'streamit-extensions') ?>">
													<?php for ($x = 0; $x < 4; $x++) { ?>
														<div class="e-item animated fadeInUp ajax	">
															<div class="block-image position-relative card-img skeleton "></div>
															<div class="episodes-description text-body iq-ltr-direction card-body skeleton"></div>
														</div>
													<?php } ?>
												</div>
											</div>
										</div>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
				</li>
			<?php $i++;
			}
			wp_reset_postdata(); ?>
		</ul>
	</div>
</div>