<?php

namespace Iqonic\Elementor\Elements\TvShow_Tab;

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'Iq_Tv_Show_Tab';
	}

	public function get_title()
	{
		return esc_html__('TvShow Tab', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('TvShow Banner', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'trending_top_img',
			[
				'label' => __('Trending Order Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/placeholder.jpg',
				],
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'options' => [
					'selected' 	=> __('Selected', 'streamit-extensions'),
					'default' 	=> __('Default', 'streamit-extensions')
				],
				'default' => 'default'
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_tv_show',
			[
				'label' 		=> __('Display Specific Tv-Show', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show', true) : [],
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' 	=> __('Item List', 'streamit-extensions'),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'condition' => ['post_filter' => ['selected']],
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'   => __('Show Title', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' => esc_html__('Yes', 'streamit-extensions'),
					'no' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'title_text',
			[
				'label' => __('Trending', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Trending', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['show_title' => ['yes']]
			]
		);

		$this->add_control(
			'show_no_tv_show',
			[
				'label' => __('Show Number Of Tv Show ', 'streamit-extensions'),
				'type' => Controls_Manager::NUMBER,
				'default' => __('6', 'streamit-extensions'),
				'min' => __('-1', 'streamit-extensions'),
				'max' => wp_count_posts('tv_show')->publish,
			]
		);

		$this->add_control(
			'tab_text_overview',
			[
				'label' => __('Overview Tab Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Overview', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'tab_text_episode',
			[
				'label' => __('Episode Tab Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Episodes', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'view_logo',
			[
				'label' => __('Show logo?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
				'selectors' => [
					'{{WRAPPER}} .iq-tvshow-tabs .channel-logo' => 'display: {{value}};',
				],
			]
		);

		$this->add_control(
			'view_all_starring',
			[
				'label' => __('Show Starring?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
				'selectors' => [
					'{{WRAPPER}} .iq-tvshow-tabs .text-primary.title.starring' => 'display: {{value}};',
				],
			]
		);

		$this->add_control(
			'show_no_starring',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__('Starring Count', 'streamit-extensions'),
				'placeholder' => esc_html__('Show Number of Starring', 'streamit-extensions'),
				'min' => -1,
				'default' => -1,
				'condition' => ['view_all_starring' => ['block']]
			]
		);

		$this->add_control(
			'view_all_genres',
			[
				'label' => __('Show Genres?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
				'selectors' => [
					'{{WRAPPER}} .iq-tvshow-tabs .text-primary.title.genres' => 'display: {{value}};',
				],
			]
		);

		$this->add_control(
			'show_no_genres',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__('Genres Count', 'streamit-extensions'),
				'placeholder' => esc_html__('Show Number of Genres', 'streamit-extensions'),
				'min' => -1,
				'default' => -1,
				'condition' => ['view_all_genres' => ['block']]
			]
		);

		$this->add_control(
			'view_all_tag',
			[
				'label' => __('Show Tags?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
				'selectors' => [
					'{{WRAPPER}} .iq-tvshow-tabs .text-primary.title.tag' => 'display: {{value}};',
				],
			]
		);

		$this->add_control(
			'show_no_tags',
			[
				'type' => Controls_Manager::NUMBER,
				'label' => esc_html__('Tags Count', 'streamit-extensions'),
				'placeholder' => esc_html__('Show Number of Tags', 'streamit-extensions'),
				'min' => -1,
				'default' => -1,
				'condition' => ['view_all_tag' => ['block']]
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callTabSlider();
					callTab();
					callOwl();
				})(jQuery);
			</script>
<?php
		}
	}
}
