<?php

$meta           = get_post_meta($post_id);
$season_data    = unserialize($meta['_seasons'][0]);

$image_alt      = esc_attr__('image', ' streamit-extensions');

$slider_image = ($is_grid) ? wp_get_attachment_image_src(get_post_thumbnail_id($post_id), $thumbnail_size)
    : $slider_image = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "medium_large");

if (is_array($slider_image))
    $slider_image = $slider_image[0];

if ($is_ajax_enable && isset($lazy_load) && !empty($lazy_load)) {
    $img_class      = ' iqonic-lazy';
    $lazy_image     = get_lazy_load_image();

    $original_image = $slider_image;
    $slider_image   = $lazy_image;
    $srcset         = "data-srcset=" . $original_image . "";
} else {
    $img_class  = '';
    $srcset     = '';
} ?>

<li class="slide-item <?php echo esc_attr($col); ?>">
    <div class="block-images position-relative">
        <div class="img-box">
            <a href="<?php echo get_the_permalink($post_id); ?>"></a>
            <img src="<?php echo esc_url($slider_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo $image_alt; ?>" <?php echo esc_attr($srcset); ?>>
        </div>

        <div class="block-description">
            <h6 class="iq-title">
                <a href="<?php echo get_the_permalink($post_id); ?>">
                    <?php echo get_the_title($post_id); ?>
                </a>
            </h6>

            <div class="movie-time d-flex align-items-center my-2 ">
                <span class="movie-time-text font-normal">
                    <?php if (is_array($season_data)) {
                        echo (count($season_data) != 1) ? count($season_data) . esc_html__(' Seasons', SE_TEXT_DOMAIN) : count($season_data) . esc_html__(' Season', SE_TEXT_DOMAIN);
                    } else {
                        echo esc_html__('1 Season', SE_TEXT_DOMAIN);
                    } ?>
                </span>
            </div>

            <div class="hover-buttons">
                <a href="<?php echo get_the_permalink($post_id); ?>" class="btn btn-hover iq-button">
                    <i class="fa fa-play mr-1" aria-hidden="true"></i>
                    <?php echo esc_html($settings['play_now_text']); ?>
                </a>
            </div>
        </div>

        <div class="block-social-info">
            <ul class="list-inline p-0 m-0 music-play-lists">
                <?php if (isset($streamit_options['streamit_display_social_icons']) && $streamit_options['streamit_display_social_icons'] == 'yes') { ?>
                    <li class="share">
                        <span><i class="fas fa-share-alt"></i></span>
                        <div class="share-wrapper">
                            <div class="share-box">
                                <svg width="15" height="40" viewBox="0 0 15 40" class="share-shape" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.8842 40C6.82983 37.2868 1 29.3582 1 20C1 10.6418 6.82983 2.71323 14.8842 0H0V40H14.8842Z" fill="#191919" />
                                </svg>

                                <div class="d-flex align-items-center">
                                    <a href="https://www.facebook.com/sharer?u=<?php echo get_the_permalink($post_id); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><i class="fab fa-facebook-f"></i></a>
                                    <a href="http://twitter.com/intent/tweet?text=<?php echo get_the_title($post_id); ?>&url=<?php echo get_the_permalink($post_id); ?>" target="_blank" rel="noopener noreferrer" class="share-ico"><svg xmlns="http://www.w3.org/2000/svg" fill="white" width="18" height="18" viewBox="0 0 512 512"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"></path></svg></a>
                                    <a href="#" data-link='<?php echo get_the_permalink($post_id); ?>' class="share-ico iq-copy-link"><i class="fas fa-link"></i></a>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php }

                if (class_exists('WpUlikeInit') && isset($streamit_options['streamit_display_like']) && $streamit_options['streamit_display_like'] == 'yes') { ?>
                    <li>
                        <div class="iq-like-btn">
                            <?php echo do_shortcode('[wp_ulike for="movie" id="' . esc_attr($post_id) . '" style="wpulike-heart"]'); ?>
                        </div>
                    </li>
                <?php }

                if (isset($streamit_options['streamit_display_watchlist']) && $streamit_options['streamit_display_watchlist'] == 'yes') { ?>
                    <li>
                        <?php if (!is_user_logged_in()) {
                            if (isset($streamit_options['streamit_signin_link'])) {
                                $iqonic_signin_link = get_page_link($streamit_options['streamit_signin_link']); ?>
                                <a class="watch-list-not" href="<?php echo esc_url($iqonic_signin_link) ?>">
                                    <span><i class="fas fa-plus"></i></span>
                                </a>
                            <?php }
                        } else { ?>
                            <a class="watch-list" rel="<?php echo esc_attr($post_id); ?>">
                                <?php echo add_to_watchlist($post_id); ?>
                            </a>
                        <?php } ?>
                    </li>
                <?php } ?>
            </ul>
        </div>
    </div>
</li>